set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7525070';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3210234',
      NULL,
      1,
      0,
      3,
      '3314',
      1,
      1,
      2.445945,
      35.650744,
      ' 3-28-1995',
      30.376005,
      NULL,
      0,
      0.976712,
      1.695400,
      ' 4-21-1987',
      46.800812,
      1,
      267.862712,
      18.623555,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.208945,
      1,
      NULL,
      NULL,
      0.027641,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957515,
      16,
      NULL,
      5,
      NULL,
      1,
      1,
      2,
      1.751066,
      0,
      2,
      0,
      4,
      NULL,
      1,
      0,
      NULL,
      0.857143,
      0.479980,
      NULL,
      0,
      4,
      3,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.804727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      0,
      0,
      0,
      0,
      5,
      3,
      0,
      5,
      1,
      4,
      2,
      4,
      NULL,
      1,
      4,
      2,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0.252599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341936,
      NULL,
      1.787415,
      1,
      1.517992,
      0.359517,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.213475,
      0.295476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457795,
      0,
      0,
      1.610399,
      NULL,
      1,
      1,
      0.656676,
      NULL,
      1,
      1.719812,
      NULL,
      NULL,
      NULL,
      2,
      0.628645,
      0,
      2,
      2,
      3,
      NULL,
      NULL,
      2,
      1,
      2,
      3,
      2,
      1.329030,
      2.118152,
      1.207632,
      0,
      1,
      1.974756,
      2,
      1,
      NULL,
      NULL,
      0.500799,
      0.204436,
      1.058948,
      1,
      NULL,
      NULL,
      2,
      5.568396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      62,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.694703,
      NULL,
      '',
      '',
      0.923672,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.365018,
      4.730164,
      184,
      53.987946,
      2.314878,
      NULL,
      NULL,
      26,
      0,
      1,
      1.536142,
      1,
      0.243925,
      5,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.572403,
      0,
      NULL,
      NULL,
      0.972116,
      NULL,
      NULL,
      0.559139,
      3.398537,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.182817,
      3,
      1.129664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.053272,
      0,
      0,
      1.946403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.671115,
      1,
      3.918958,
      2,
      0,
      0.823425,
      NULL,
      NULL,
      0,
      NULL,
      1.820703,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.484144,
      NULL,
      NULL,
      5,
      1,
      1.509522,
      1,
      0.509810,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.617260,
      NULL,
      1,
      2.562385,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.184876,
      NULL,
      NULL,
      9.156021,
      4.836339,
      NULL,
      1.679831,
      NULL,
      0,
      0.342528,
      NULL,
      0,
      1.314257,
      1,
      1.855318,
      1.036196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.938795,
      NULL,
      NULL,
      3,
      1.857768,
      NULL,
      1.541541,
      NULL,
      NULL,
      6,
      2,
      5,
      2.818188,
      2,
      9.596832,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.424940,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      0.004028,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.909941,
      NULL,
      2,
      9.554790,
      2.464937,
      3.641401,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0.252654,
      NULL,
      1,
      0.194290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.240238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.828500,
      NULL,
      NULL,
      1,
      0.422139,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.338829,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      1,
      NULL,
      NULL,
      8.717700,
      0.699290,
      NULL,
      NULL,
      5.451717,
      3.395488,
      NULL,
      NULL,
      16,
      1.398996,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      16.002834,
      0,
      NULL,
      NULL,
      17,
      1,
      NULL,
      NULL,
      0.365651,
      3.928301,
      NULL,
      NULL,
      0.469155,
      NULL,
      NULL,
      NULL,
      0,
      232,
      31.018725,
      2.753513,
      1530,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.559402,
      NULL,
      NULL,
      0,
      NULL,
      1.710668,
      1631.367739,
      8.897264,
      NULL,
      1.570507,
      1.553363,
      0.698487,
      0,
      0.833927,
      1.266875,
      2.503536,
      NULL,
      2,
      0.612534,
      3,
      0,
      3.709392,
      0,
      1.917049,
      0.300130,
      1.540382,
      NULL,
      1,
      NULL,
      0.943082,
      NULL,
      2,
      NULL,
      0.383173,
      NULL,
      1.198743,
      NULL,
      188,
      NULL,
      0,
      38,
      41,
      2,
      2.126206,
      2.418738,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.795707,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3.537818,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.438457,
      NULL,
      0,
      NULL,
      0.481776,
      0.107019,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1913,
      NULL,
      132.837582,
      NULL,
      0,
      NULL,
      0.662169,
      NULL,
      1,
      1,
      3.012533,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.516232,
      1.019842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335319,
      0.216531,
      NULL,
      2.867271,
      NULL,
      NULL,
      NULL,
      1125.990191,
      NULL,
      153,
      NULL,
      NULL,
      NULL,
      0.031596,
      NULL,
      0,
      0,
      1.145315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.249569,
      0,
      1.767888,
      NULL,
      0.664798,
      NULL,
      1.767943,
      NULL,
      NULL,
      NULL,
      0.794824,
      NULL,
      0.538858,
      NULL,
      NULL,
      NULL,
      3.775455,
      NULL,
      0.248952,
      1.524816,
      NULL,
      NULL,
      9.122221,
      1,
      1,
      NULL,
      6.588755,
      0,
      0,
      3,
      0,
      17.387454,
      1,
      0.821649,
      0,
      15.744784,
      3,
      1.902880,
      0.668454,
      3,
      6.619638,
      NULL,
      2.551602,
      1.010635,
      3.252553,
      1,
      1,
      NULL,
      1,
      3,
      2.746586,
      3.298251,
      3,
      NULL,
      0,
      2,
      3.928847,
      NULL,
      1.756583,
      4.770260,
      NULL,
      3.239820,
      NULL,
      15,
      NULL,
      17.221403,
      0.709314,
      1.789402,
      1,
      1.413695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503178,
      NULL,
      NULL,
      1.115462,
      1,
      3,
      6,
      2.673625,
      0,
      NULL,
      69.884934,
      62,
      4,
      1.418803,
      NULL,
      NULL,
      NULL,
      '32233',
      3.024070,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


