set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      29,
      19,
      '2223012',
      NULL,
      1.600221,
      NULL,
      1,
      '1423',
      NULL,
      0,
      NULL,
      NULL,
      '10- 6-1989',
      NULL,
      7.474897,
      NULL,
      1,
      0,
      ' 8-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 1-16-1983',
      NULL,
      ' 3-28-1975',
      1.481080,
      1,
      0.824813,
      0,
      3.441742,
      0,
      NULL,
      0.397993,
      1.168016,
      9.000818,
      5,
      13.370655,
      4.755354,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1.562344,
      2,
      0,
      0,
      1,
      0,
      NULL,
      3,
      0,
      1,
      1,
      0,
      NULL,
      5,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0.425775,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      3.522577,
      1,
      0,
      1,
      1,
      0.089999,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      2,
      0,
      NULL,
      2,
      4,
      3,
      3,
      2,
      1,
      0,
      0,
      3,
      '11-19-2002',
      418,
      ' 7-23-1988',
      399,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      2,
      1,
      0.473154,
      0,
      NULL,
      1.779386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.227988,
      3.491133,
      1,
      0.711420,
      0,
      0.322216,
      1.980272,
      2.288046,
      0.060306,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.951842,
      NULL,
      0.197624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.674708,
      NULL,
      1.048056,
      0.101345,
      1,
      1,
      0.835608,
      NULL,
      1,
      1.062686,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.004936,
      3,
      0,
      NULL,
      1,
      3,
      3,
      NULL,
      0,
      3,
      0,
      3.298884,
      2.841823,
      0.997608,
      NULL,
      1.498889,
      0.472640,
      1.864823,
      0,
      0,
      NULL,
      1.573446,
      0,
      NULL,
      1.218808,
      1,
      1,
      0,
      NULL,
      0.605651,
      11,
      3,
      4,
      NULL,
      11,
      1,
      4.077580,
      0.281385,
      2,
      1.301269,
      3,
      2,
      63.494786,
      0,
      1.203288,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.858686,
      '22003',
      '',
      '',
      0.214121,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.985062,
      16.409093,
      108,
      22,
      3,
      40,
      10.028215,
      4,
      3,
      2,
      0,
      0.114813,
      1.903376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.846734,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.305660,
      NULL,
      NULL,
      NULL,
      3.547792,
      1,
      0.816005,
      1.698752,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614434,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.371691,
      NULL,
      NULL,
      2.416796,
      NULL,
      NULL,
      0,
      1.930069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.202138,
      NULL,
      NULL,
      0.258762,
      NULL,
      NULL,
      1,
      1,
      0,
      0.236794,
      0,
      3,
      1,
      1,
      NULL,
      1,
      0.475294,
      1.209353,
      NULL,
      0.454460,
      1,
      1,
      0,
      NULL,
      NULL,
      1.675568,
      NULL,
      NULL,
      1.727259,
      NULL,
      NULL,
      3.687588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.019120,
      0.105186,
      2,
      1,
      NULL,
      NULL,
      0.307370,
      3.828997,
      5.567144,
      0,
      1,
      0.640003,
      3,
      0.171787,
      0.130043,
      4.784707,
      NULL,
      1.659911,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.286052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.629959,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.666288,
      0.515653,
      NULL,
      0.041230,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      6,
      0,
      2.706810,
      3,
      1,
      0,
      1.439443,
      NULL,
      NULL,
      0.761736,
      2.709750,
      NULL,
      0.115985,
      NULL,
      2,
      0,
      1.508066,
      NULL,
      NULL,
      2.339038,
      0,
      4,
      1.827632,
      NULL,
      1,
      1,
      1.809374,
      2.414225,
      NULL,
      NULL,
      0.596584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309224,
      NULL,
      NULL,
      0.363988,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.585902,
      NULL,
      NULL,
      4.252515,
      NULL,
      NULL,
      0.003424,
      1.353634,
      1.681573,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2.485737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.464168,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.056103,
      1.655170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.759904,
      1.519302,
      NULL,
      NULL,
      2.580946,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.842490,
      NULL,
      NULL,
      NULL,
      NULL,
      3.589498,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      1.825021,
      NULL,
      NULL,
      1,
      1.469589,
      NULL,
      NULL,
      NULL,
      3.069312,
      NULL,
      NULL,
      0.580560,
      NULL,
      4,
      1,
      2,
      79.061693,
      19,
      0.659291,
      21.641417,
      2,
      1,
      NULL,
      NULL,
      1.524700,
      3,
      0,
      1.056279,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.602863,
      18,
      1,
      NULL,
      0.150137,
      1,
      0.234909,
      1.231617,
      NULL,
      1.608172,
      2.751573,
      0,
      1.878636,
      0,
      NULL,
      0,
      NULL,
      0.083248,
      3.431338,
      0,
      0.964981,
      NULL,
      NULL,
      NULL,
      1.779487,
      NULL,
      2.484171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      111.535428,
      NULL,
      2,
      47.035392,
      21.658577,
      0.421104,
      1,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.862372,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.422793,
      NULL,
      1,
      NULL,
      0.485952,
      NULL,
      1.000086,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.055519,
      NULL,
      1,
      3.849613,
      1.733681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      23.244267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.562984,
      0,
      0.774493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491352,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.011321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.615992,
      NULL,
      1.604048,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      NULL,
      1.079812,
      NULL,
      0.374134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      14,
      5,
      1.962511,
      0.742862,
      0,
      7.460112,
      2,
      1.375952,
      3,
      1,
      0.896212,
      1.902737,
      NULL,
      2.440932,
      3.019556,
      1.872193,
      2,
      1,
      0,
      0,
      NULL,
      1.918535,
      1.182088,
      1,
      1.401863,
      0,
      0.698590,
      3.867855,
      2,
      3,
      0,
      1,
      0.991231,
      1,
      0.640130,
      1,
      1,
      NULL,
      0.932879,
      1.630306,
      0,
      0,
      2,
      2.575800,
      0.535778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.072460,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.604054,
      1.073875,
      0,
      79.002182,
      10,
      NULL,
      NULL,
      0.013806,
      '34403',
      '',
      '',
      0,
      '',
      '',
      '',
      1.903239,
      '',
      '',
      '');
commit;
end;
/


