set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3323420',
      2.243077,
      0.294566,
      3,
      0,
      '2122',
      1,
      1,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      1,
      1.143743,
      NULL,
      ' 7-25-1985',
      29.408266,
      5,
      NULL,
      32.052460,
      NULL,
      NULL,
      ' 5- 4-1981',
      '11- 3-2000',
      NULL,
      0.832989,
      NULL,
      NULL,
      0.829594,
      NULL,
      0,
      NULL,
      1.128759,
      0.650409,
      0,
      0.331099,
      1,
      NULL,
      19.153096,
      0,
      12,
      NULL,
      2,
      5.522641,
      0.559406,
      0,
      1,
      1.622048,
      1.320519,
      NULL,
      1.509142,
      0.251098,
      1.834685,
      0.467124,
      0,
      2,
      NULL,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      0,
      2.940682,
      NULL,
      0,
      1,
      1,
      0.383413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      4,
      1,
      1,
      3,
      1,
      NULL,
      1,
      2,
      0,
      3,
      3,
      NULL,
      4,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      5,
      NULL,
      0,
      0.973302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.673989,
      NULL,
      NULL,
      3.623809,
      3,
      0,
      NULL,
      3,
      1.549913,
      3.408502,
      3,
      0.485907,
      0.915368,
      0.519670,
      1.710483,
      2,
      NULL,
      0,
      3.924980,
      7,
      4,
      8,
      1,
      NULL,
      NULL,
      NULL,
      1.413547,
      4.698826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056988,
      3.628688,
      0.646083,
      NULL,
      0,
      0,
      NULL,
      2.822526,
      NULL,
      0.340953,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.484492,
      2,
      0,
      1,
      NULL,
      2,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      2.628722,
      1,
      0.811432,
      2,
      1,
      1.859396,
      1.236665,
      0,
      1,
      1,
      0.091978,
      0.068428,
      1,
      NULL,
      3.299442,
      0.719838,
      11.731583,
      NULL,
      6,
      5,
      2,
      5,
      4.031204,
      1.721878,
      2,
      0.048895,
      3.404033,
      1.174750,
      0.284815,
      1,
      2.923745,
      NULL,
      70,
      53,
      82.380522,
      4,
      0.301185,
      0,
      '',
      '',
      '',
      1.290435,
      NULL,
      NULL,
      NULL,
      NULL,
      '0431',
      '',
      '',
      1,
      43,
      NULL,
      18,
      NULL,
      7,
      2.885495,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181211,
      NULL,
      NULL,
      0.816766,
      NULL,
      NULL,
      3.938707,
      NULL,
      1.097925,
      1,
      NULL,
      NULL,
      0.313366,
      NULL,
      NULL,
      1.015801,
      NULL,
      NULL,
      1.117551,
      NULL,
      NULL,
      1.670909,
      NULL,
      NULL,
      5.719003,
      3.845674,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.139667,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599705,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.985483,
      NULL,
      NULL,
      0.682353,
      NULL,
      NULL,
      1.297063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.003154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.731324,
      NULL,
      NULL,
      1,
      2.025268,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5.604179,
      NULL,
      0,
      NULL,
      NULL,
      1.550677,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.129082,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.842296,
      0,
      NULL,
      NULL,
      2.182397,
      2,
      0,
      4,
      7.810738,
      6.774159,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.722148,
      1,
      1.363518,
      1.172419,
      2,
      3,
      3,
      NULL,
      3.067265,
      3.282519,
      2.419470,
      0,
      3.382989,
      0,
      1.952099,
      0,
      1.711892,
      NULL,
      NULL,
      0,
      3.065855,
      2,
      9.852231,
      0.059008,
      1.079797,
      NULL,
      NULL,
      0.258459,
      NULL,
      NULL,
      1.721723,
      1.484402,
      1.627879,
      NULL,
      1.362941,
      0.850479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941166,
      0.112640,
      NULL,
      1.522875,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.602560,
      NULL,
      NULL,
      3,
      3.859772,
      NULL,
      0,
      NULL,
      NULL,
      0.718868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.448059,
      NULL,
      NULL,
      1,
      NULL,
      1,
      97.129267,
      1,
      NULL,
      0.176088,
      0.266090,
      1.296915,
      1,
      0.585313,
      0,
      NULL,
      0,
      1.800984,
      0.144792,
      0.219482,
      0.778322,
      0.964375,
      NULL,
      0.043070,
      1.319623,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      12.359493,
      1.718951,
      NULL,
      NULL,
      1,
      1.200686,
      1.609836,
      0,
      1.422405,
      0.018852,
      NULL,
      NULL,
      0.786981,
      NULL,
      NULL,
      3.265360,
      NULL,
      NULL,
      1.626909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.213714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.386171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.107435,
      2.469166,
      NULL,
      1.611994,
      NULL,
      1.378720,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.584642,
      NULL,
      3,
      NULL,
      2.139741,
      NULL,
      3.953254,
      NULL,
      1,
      NULL,
      2.629927,
      NULL,
      1,
      NULL,
      10.131553,
      3.373507,
      NULL,
      0.961584,
      NULL,
      0,
      NULL,
      0.667138,
      NULL,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      23,
      5,
      1,
      1,
      '24242',
      '',
      '',
      3.897908,
      '11144',
      NULL,
      '',
      1,
      '1314',
      NULL,
      NULL);
commit;
end;
/


