set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3101013',
      0.310788,
      0,
      3,
      3,
      '3444',
      1.281858,
      1.746977,
      NULL,
      NULL,
      ' 5-10-1974',
      23,
      NULL,
      4,
      1.155739,
      0,
      ' 2-28-1995',
      5,
      0,
      270,
      132.098881,
      3,
      ' 2-25-1981',
      ' 2- 5-1996',
      ' 7-10-1983',
      NULL,
      0,
      0,
      1.787013,
      0.375100,
      0.023230,
      0,
      1,
      0,
      5,
      2,
      9,
      2,
      16,
      26,
      5,
      19,
      3,
      0,
      1.598593,
      NULL,
      3,
      NULL,
      0.698584,
      1,
      1.518813,
      1,
      NULL,
      1.383835,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      4,
      1,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      0,
      0,
      0,
      0,
      1.563707,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.432755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      5,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0.331758,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      2,
      5,
      3,
      0,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      2,
      5,
      4,
      1,
      3,
      2,
      5,
      1,
      3,
      4,
      5.548720,
      0,
      ' 7-24-1974',
      33.797790,
      '10-19-1974',
      106.856133,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      23,
      1.911206,
      2,
      NULL,
      NULL,
      2,
      0.387934,
      0.643837,
      3,
      NULL,
      3.759567,
      0.239340,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.566783,
      4,
      6.129046,
      5.783219,
      1,
      NULL,
      NULL,
      NULL,
      2,
      14,
      NULL,
      NULL,
      4,
      NULL,
      9,
      NULL,
      12.508786,
      NULL,
      24.854544,
      0.575366,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.270091,
      0,
      0.727220,
      3,
      54.048485,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.327800,
      2,
      NULL,
      1,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      2,
      1.989508,
      NULL,
      NULL,
      0.911350,
      NULL,
      1,
      0,
      0.681692,
      1.991682,
      NULL,
      1,
      0,
      0.017056,
      0.366747,
      1.080227,
      0,
      NULL,
      1.142477,
      2.429683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099282,
      NULL,
      15,
      9,
      78.512413,
      5,
      1.057806,
      NULL,
      '33010',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      3.891952,
      NULL,
      NULL,
      NULL,
      NULL,
      21.993720,
      NULL,
      54.046312,
      0,
      55.053049,
      0.927341,
      0,
      4,
      2,
      0.152978,
      NULL,
      1.794210,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.687005,
      NULL,
      NULL,
      0.355905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.387821,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.201418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571410,
      NULL,
      NULL,
      0.703800,
      10,
      3.728319,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.187525,
      1,
      12.533822,
      0.720855,
      NULL,
      NULL,
      1.558339,
      NULL,
      NULL,
      1.023201,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.371383,
      3,
      NULL,
      NULL,
      NULL,
      0.136160,
      2.036055,
      4,
      NULL,
      3.723903,
      0,
      0.867780,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.932563,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.776256,
      NULL,
      NULL,
      0.758329,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.076056,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      6,
      2.546958,
      NULL,
      9.328406,
      5.870402,
      4.640947,
      2,
      NULL,
      NULL,
      3,
      3.968365,
      3.943441,
      3.062236,
      3,
      0,
      2,
      3.810199,
      0,
      0.323505,
      2,
      5.785671,
      NULL,
      2.008943,
      3.900246,
      1,
      2,
      3,
      NULL,
      1.311962,
      0,
      1.980035,
      0.498213,
      1.398861,
      NULL,
      7.526879,
      NULL,
      0.334755,
      7,
      4.381776,
      3.424144,
      3,
      0,
      NULL,
      1,
      1.636792,
      NULL,
      0.740351,
      0.071345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.365185,
      0,
      0.010257,
      NULL,
      1,
      3.725269,
      NULL,
      NULL,
      NULL,
      7.685915,
      NULL,
      10.535626,
      NULL,
      2,
      NULL,
      0.420366,
      NULL,
      2.031763,
      NULL,
      NULL,
      NULL,
      1.396967,
      NULL,
      0.334212,
      NULL,
      1.769957,
      NULL,
      NULL,
      NULL,
      1.274419,
      NULL,
      0.089970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.267841,
      NULL,
      NULL,
      NULL,
      0.237877,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.816338,
      NULL,
      1.857835,
      NULL,
      0.291439,
      NULL,
      1.457363,
      NULL,
      3.556480,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.849277,
      NULL,
      1.207239,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.981707,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.904857,
      NULL,
      NULL,
      0.693606,
      NULL,
      NULL,
      1.630728,
      NULL,
      NULL,
      1.133390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      529,
      0.665066,
      1.948289,
      0.887824,
      NULL,
      1.533460,
      0.474806,
      0.023791,
      1.460423,
      1.592826,
      0,
      1.484987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      5.458503,
      NULL,
      NULL,
      0.091800,
      NULL,
      NULL,
      0,
      2.498701,
      0.440229,
      0,
      0,
      NULL,
      0.539091,
      NULL,
      NULL,
      0.003024,
      3.055678,
      NULL,
      1,
      1.785699,
      NULL,
      0,
      0.966914,
      NULL,
      1.753644,
      3,
      NULL,
      2.666819,
      NULL,
      NULL,
      3,
      2.003584,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.497939,
      NULL,
      NULL,
      0.284856,
      NULL,
      NULL,
      NULL,
      1.727972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.944362,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792507,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.967922,
      NULL,
      1,
      NULL,
      0.598461,
      NULL,
      1,
      NULL,
      1.431166,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458448,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.259029,
      1.270230,
      NULL,
      110.013055,
      2,
      NULL,
      2,
      '30231',
      '',
      '',
      0.616146,
      '',
      NULL,
      NULL,
      NULL,
      '0432',
      '',
      '');
commit;
end;
/


