set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '4324212',
      1.630896,
      1.621187,
      5,
      NULL,
      '1012',
      2,
      1.283102,
      NULL,
      NULL,
      '11-16-1978',
      24.250535,
      NULL,
      5,
      1,
      NULL,
      ' 5- 4-1978',
      42.783402,
      NULL,
      190.927794,
      65.566084,
      NULL,
      ' 4- 1-1981',
      ' 3-17-1978',
      ' 3-10-1975',
      NULL,
      0,
      2.247512,
      NULL,
      1.552425,
      0,
      1,
      0,
      0,
      18.170955,
      NULL,
      15,
      1,
      NULL,
      0,
      0,
      30,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      1.903783,
      0,
      0.353664,
      1.839917,
      2.500275,
      1,
      NULL,
      0,
      1,
      4,
      NULL,
      0.102020,
      3,
      0,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      2,
      NULL,
      6.795952,
      NULL,
      2,
      0,
      1,
      1.601694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      4,
      4,
      2,
      0,
      0,
      1,
      1,
      3,
      5,
      1,
      1.779193,
      NULL,
      1,
      0,
      0,
      1.026279,
      NULL,
      1.178655,
      5,
      0,
      2,
      5,
      0,
      NULL,
      4,
      2,
      5,
      NULL,
      3,
      2,
      4,
      3,
      NULL,
      0,
      3,
      2,
      0,
      1,
      3,
      0,
      4,
      2,
      0,
      1,
      3.663161,
      ' 5- 4-1984',
      41.010843,
      ' 0- 6-2002',
      135.655583,
      0.818479,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      5,
      1,
      0.030972,
      NULL,
      3.800419,
      0.086718,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      5,
      0.611470,
      2.496272,
      NULL,
      0.546042,
      NULL,
      NULL,
      1.493963,
      7,
      0.264899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780457,
      0,
      0.457219,
      1.413071,
      0.590466,
      3.386961,
      25,
      2.349523,
      0.539347,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      3,
      2,
      1.755437,
      NULL,
      1.011069,
      0.811079,
      0,
      0,
      NULL,
      0.489419,
      1,
      NULL,
      1.378500,
      0,
      NULL,
      NULL,
      0,
      0,
      1.345964,
      1,
      3.639109,
      0,
      4,
      1,
      4,
      NULL,
      3,
      2.958289,
      7.473320,
      0,
      3,
      NULL,
      2.127810,
      1,
      1,
      NULL,
      28,
      40,
      58,
      5,
      1.249606,
      0,
      '34313',
      '',
      '',
      1.223931,
      '',
      '',
      '',
      2,
      '0422',
      '',
      '',
      0,
      47.490137,
      36,
      13,
      2.367645,
      23.230374,
      0.377214,
      3,
      NULL,
      NULL,
      0.465005,
      2.123833,
      NULL,
      NULL,
      NULL,
      1,
      3.674333,
      1,
      0.515324,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.037391,
      NULL,
      NULL,
      3.403603,
      2,
      3.973627,
      NULL,
      NULL,
      NULL,
      1.741017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.663861,
      NULL,
      NULL,
      NULL,
      8.945604,
      1.541843,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.900386,
      NULL,
      NULL,
      NULL,
      1.158019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.473884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801333,
      NULL,
      NULL,
      1.291320,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      6.220998,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678474,
      4.970941,
      1.421637,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.633263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.235131,
      NULL,
      NULL,
      7.754205,
      7.465425,
      3,
      3.344730,
      3.459955,
      0.064277,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834910,
      NULL,
      1.878399,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      10.118419,
      5.080994,
      1.870848,
      1,
      0.839416,
      NULL,
      2,
      3.310415,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      11.951171,
      9,
      NULL,
      1.934887,
      NULL,
      2.012878,
      NULL,
      4,
      1.528616,
      0.792474,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.463283,
      NULL,
      NULL,
      1.877211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.363670,
      3.002731,
      0.911974,
      0,
      1,
      0,
      NULL,
      NULL,
      0.379648,
      NULL,
      NULL,
      NULL,
      0.598916,
      NULL,
      NULL,
      NULL,
      3.556494,
      NULL,
      NULL,
      NULL,
      2.473538,
      NULL,
      NULL,
      NULL,
      1.563393,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.938754,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.595953,
      NULL,
      NULL,
      NULL,
      1.957001,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.414332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.547493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741468,
      0.133274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.248203,
      NULL,
      1.751549,
      1.357894,
      NULL,
      1,
      NULL,
      1.578195,
      1.723136,
      0,
      0,
      1.390460,
      0,
      0,
      1.870585,
      NULL,
      1,
      1,
      1.518971,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      6.534262,
      NULL,
      1,
      NULL,
      3,
      1.811386,
      1,
      0.914961,
      1.652556,
      1,
      NULL,
      NULL,
      1.700060,
      0.759811,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      3,
      1.360423,
      NULL,
      3,
      0.689911,
      NULL,
      1.597982,
      NULL,
      NULL,
      1,
      1.424060,
      NULL,
      1.356468,
      0.395711,
      NULL,
      0.932351,
      0.141777,
      NULL,
      1.417910,
      NULL,
      NULL,
      3.275462,
      NULL,
      1.317445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706830,
      NULL,
      NULL,
      2.428452,
      NULL,
      1,
      NULL,
      0.582404,
      NULL,
      1.942570,
      NULL,
      1,
      NULL,
      2.477064,
      NULL,
      NULL,
      NULL,
      3.881829,
      NULL,
      0,
      NULL,
      0.294415,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      15,
      0.153645,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      0.828978,
      NULL,
      NULL,
      19.273748,
      92,
      0,
      0.113742,
      5,
      NULL,
      NULL,
      NULL,
      3,
      '31300',
      '',
      '',
      0,
      '4244',
      '',
      '');
commit;
end;
/


