set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2132232',
      NULL,
      0.128059,
      0,
      0,
      '3102',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1996',
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      6,
      5,
      71.895442,
      119.333862,
      1,
      NULL,
      ' 9- 1-1981',
      NULL,
      0,
      0.490505,
      1.875616,
      3,
      0,
      0,
      0,
      1.243706,
      1,
      3,
      5,
      15,
      1,
      15.982748,
      7.272653,
      3,
      32.157383,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      5,
      0,
      1,
      1,
      0,
      0,
      3,
      3,
      1,
      1,
      NULL,
      4,
      7.374390,
      1,
      1,
      NULL,
      0,
      0.901394,
      NULL,
      NULL,
      1.801681,
      NULL,
      NULL,
      4,
      1,
      1,
      1.049741,
      NULL,
      1.104964,
      0.796726,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1.068758,
      3,
      NULL,
      1.612532,
      1,
      3,
      0,
      3.832985,
      0,
      0,
      NULL,
      0.725298,
      NULL,
      NULL,
      0.636564,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      0.824383,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      5,
      0,
      1,
      5,
      2,
      3,
      5,
      1,
      1,
      0,
      3,
      3,
      3,
      1,
      1,
      3,
      3,
      1,
      NULL,
      0,
      1,
      ' 7-14-1991',
      302.661433,
      ' 9-18-1981',
      249,
      2,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.623748,
      NULL,
      0,
      1.903380,
      1,
      NULL,
      3.901323,
      2,
      5,
      0.371129,
      1,
      3,
      1,
      2.236137,
      0,
      1.528368,
      8,
      0,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.984906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137757,
      1,
      1,
      1.642859,
      0,
      NULL,
      0.845073,
      9.643712,
      1,
      0.980372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1.243025,
      1.971656,
      1,
      0,
      0.933508,
      0.462894,
      1.892851,
      0.852999,
      NULL,
      NULL,
      1.516206,
      1,
      0.453803,
      NULL,
      1.470883,
      0,
      0.289209,
      3.394062,
      11,
      0.761588,
      2,
      10,
      4,
      1.208446,
      2.284049,
      0.284149,
      0.290450,
      3,
      0,
      29,
      2,
      2.033902,
      NULL,
      NULL,
      8,
      5.283135,
      4,
      NULL,
      3.729699,
      '11412',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.735799,
      '1134',
      '',
      '',
      NULL,
      22,
      110,
      40.254459,
      3.620976,
      39.534538,
      NULL,
      0.126131,
      1,
      3.799310,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.470291,
      1,
      1.257378,
      1,
      NULL,
      NULL,
      1.445209,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.006192,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.059043,
      NULL,
      NULL,
      1.449089,
      NULL,
      NULL,
      1.192092,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.789922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.176831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045998,
      NULL,
      NULL,
      0.179167,
      NULL,
      NULL,
      1,
      3.197024,
      NULL,
      0,
      NULL,
      1.195530,
      7,
      1,
      7,
      3.329665,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.300101,
      1.899288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      2.631290,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      5.364786,
      NULL,
      1.549828,
      NULL,
      NULL,
      1.290543,
      2.810288,
      NULL,
      0,
      3.258382,
      3.138152,
      1.102543,
      0,
      0.963366,
      10,
      10,
      NULL,
      0,
      2.718097,
      2.087137,
      1.847180,
      2,
      1.849452,
      0.959553,
      3,
      NULL,
      NULL,
      1.469842,
      3,
      NULL,
      4.382150,
      10,
      0,
      5,
      0.957974,
      NULL,
      3,
      4,
      0.439420,
      0.521127,
      1,
      0.769193,
      1,
      3.257116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.411912,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936607,
      NULL,
      NULL,
      1.063944,
      0.401608,
      2,
      0.589188,
      1.163059,
      NULL,
      1,
      NULL,
      NULL,
      6.860075,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378180,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.170202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.972509,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.330154,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.220008,
      NULL,
      NULL,
      NULL,
      2.814471,
      NULL,
      NULL,
      NULL,
      17.644255,
      NULL,
      NULL,
      NULL,
      0.193792,
      NULL,
      NULL,
      NULL,
      1.620850,
      39,
      8,
      3.078557,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      35.721843,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929556,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575672,
      NULL,
      1.525815,
      0.427718,
      1.362584,
      0,
      0.580370,
      0.479604,
      1.744700,
      0.405689,
      NULL,
      1,
      1,
      1.611900,
      0,
      1.709423,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.617242,
      1.578359,
      3,
      NULL,
      3,
      NULL,
      1,
      2,
      1.051620,
      0.073268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.087552,
      1.337475,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.797437,
      1.689332,
      NULL,
      1.967363,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.779622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.282558,
      NULL,
      3,
      NULL,
      1.686443,
      NULL,
      0.308043,
      NULL,
      2.577581,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.226305,
      NULL,
      3.465708,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      12.103940,
      1.763207,
      NULL,
      0.536274,
      NULL,
      0.377384,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.470200,
      NULL,
      2,
      NULL,
      14.524020,
      3,
      0.723253,
      NULL,
      '00120',
      '02443',
      NULL,
      0,
      '10430',
      '',
      NULL,
      3,
      NULL,
      NULL,
      NULL);
commit;
end;
/


