set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8406340';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0123312',
      0.438853,
      0.651423,
      1,
      0,
      '4214',
      0,
      NULL,
      NULL,
      NULL,
      '10- 3-1995',
      4.456463,
      NULL,
      1,
      1.053646,
      0.088732,
      NULL,
      NULL,
      3.275771,
      238.059473,
      NULL,
      2,
      ' 6- 2-1981',
      ' 8- 6-1986',
      ' 0- 4-2001',
      2,
      2,
      2,
      1,
      1,
      NULL,
      7,
      2.614058,
      NULL,
      NULL,
      NULL,
      8.205094,
      4.073609,
      19.420284,
      0,
      NULL,
      8.812561,
      4,
      NULL,
      4.256910,
      NULL,
      0,
      1,
      1,
      0.885420,
      NULL,
      0,
      1.134425,
      0.278455,
      0.422522,
      1,
      0,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      1,
      2,
      1,
      0,
      0.603141,
      NULL,
      NULL,
      1.884401,
      NULL,
      NULL,
      2,
      NULL,
      4.997678,
      0.820344,
      1,
      1,
      NULL,
      1.926735,
      3.939081,
      2.125078,
      0,
      3,
      2.625705,
      3,
      NULL,
      2.354076,
      NULL,
      1.713127,
      1.670089,
      NULL,
      0,
      0,
      6,
      1,
      NULL,
      0.541348,
      0.071742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1.302611,
      NULL,
      1,
      0,
      3,
      0,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      1,
      0,
      1,
      1,
      3,
      3,
      NULL,
      4,
      5,
      1,
      3,
      NULL,
      3.220770,
      ' 0- 4-1984',
      288,
      ' 8-16-1980',
      376.105756,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.216307,
      1.192639,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.423723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698368,
      0,
      0.469505,
      NULL,
      0,
      1.222561,
      1.395304,
      1.438322,
      NULL,
      NULL,
      0.315072,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      2,
      0,
      1,
      4,
      4,
      NULL,
      1.877103,
      2,
      1,
      1.634665,
      1,
      0.456013,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.646332,
      NULL,
      1.122854,
      1,
      2.045295,
      NULL,
      3,
      9.026208,
      7.219674,
      2,
      2.672700,
      4,
      1,
      NULL,
      NULL,
      27.746076,
      1,
      3.420823,
      NULL,
      58,
      12,
      7.731088,
      4,
      2,
      NULL,
      '14403',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.571393,
      '13244',
      NULL,
      '',
      1.014068,
      NULL,
      190,
      NULL,
      0.894945,
      1.162118,
      1.650597,
      7,
      3,
      NULL,
      1,
      1.000873,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.618139,
      NULL,
      0.052807,
      3,
      2.746839,
      NULL,
      1,
      0.667487,
      3.998310,
      3,
      1,
      3,
      2.781290,
      0.117747,
      NULL,
      16,
      0,
      NULL,
      3,
      6.026125,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473805,
      3.492648,
      0,
      3,
      0.134866,
      3,
      NULL,
      0.970205,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0.090268,
      NULL,
      0,
      1.646793,
      NULL,
      3.856263,
      1.385392,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.786862,
      2,
      0,
      NULL,
      NULL,
      0,
      0.162233,
      1.348814,
      6.959181,
      NULL,
      4,
      1,
      1.083932,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.585245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784298,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0.466708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.996590,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.531371,
      NULL,
      NULL,
      1.882687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427631,
      NULL,
      NULL,
      0.703082,
      NULL,
      NULL,
      4.699223,
      NULL,
      0.747618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.638654,
      0,
      0.741435,
      0.775513,
      1.894661,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.557347,
      2.876698,
      5.785830,
      2.469186,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.798123,
      0.645330,
      1.625746,
      1.005827,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.583057,
      NULL,
      NULL,
      0.113789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.917786,
      NULL,
      0.994109,
      1,
      1.949497,
      2,
      0.072469,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.465337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.113581,
      NULL,
      NULL,
      NULL,
      0.615848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.730509,
      1.484325,
      1,
      0,
      NULL,
      NULL,
      1.682415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      37,
      38.528333,
      0,
      0,
      0.257481,
      NULL,
      NULL,
      0.349021,
      0.520317,
      1.517605,
      NULL,
      NULL,
      0.166308,
      1,
      NULL,
      1.513474,
      1,
      0.005403,
      NULL,
      0.795964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.591984,
      0.846879,
      0,
      2,
      3,
      0.144704,
      3,
      1.306115,
      1.288137,
      1,
      NULL,
      1.668998,
      1,
      NULL,
      1.827756,
      1,
      NULL,
      0,
      1.383285,
      NULL,
      0.533166,
      0,
      NULL,
      0,
      1,
      NULL,
      0.246010,
      0.734838,
      NULL,
      0,
      1,
      NULL,
      1.670610,
      1.154345,
      NULL,
      0,
      1.541766,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      1.642327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      10,
      1,
      NULL,
      1,
      2.987596,
      NULL,
      NULL,
      '',
      0.413248,
      NULL,
      '',
      NULL,
      2,
      '21224',
      '',
      '');
commit;
end;
/


