set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000221';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      2.125996,
      1.242879,
      1,
      3,
      '2142',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-26-1988',
      70,
      NULL,
      NULL,
      2.521910,
      0.842789,
      ' 6- 7-1981',
      10.416811,
      3.338518,
      39.149408,
      20,
      4,
      NULL,
      NULL,
      ' 5-25-1976',
      NULL,
      NULL,
      0,
      1.894181,
      1.958320,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      10,
      NULL,
      NULL,
      NULL,
      3,
      11,
      NULL,
      0,
      2.948805,
      0.670455,
      1,
      0,
      0.862120,
      1.703330,
      1.574690,
      0,
      NULL,
      0.566958,
      NULL,
      2.517056,
      6,
      0,
      6,
      0.175555,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.591559,
      NULL,
      0.685113,
      1,
      1.266835,
      2,
      0.627081,
      1.005691,
      NULL,
      NULL,
      1,
      1.821015,
      1.208506,
      1.603642,
      0,
      0.890499,
      1,
      1,
      1,
      1.048697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      2,
      0,
      5.292636,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      3,
      5,
      0,
      1,
      2,
      NULL,
      5,
      1,
      5,
      2,
      4,
      1,
      NULL,
      0,
      2,
      2,
      1,
      3,
      1,
      3,
      1,
      4,
      2,
      3,
      0.593377,
      0.202384,
      NULL,
      388.328603,
      ' 9-24-1980',
      193,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067689,
      3,
      1.743589,
      1,
      NULL,
      1,
      1.252319,
      NULL,
      NULL,
      NULL,
      0.658735,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.555701,
      1.519708,
      0.948355,
      1.255196,
      1,
      1.756045,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      3,
      0,
      3,
      2,
      2,
      1,
      3,
      0,
      3.412850,
      NULL,
      0.947370,
      3,
      0.274392,
      0.100200,
      0,
      NULL,
      1,
      1.017431,
      1,
      NULL,
      0,
      NULL,
      1.828246,
      1,
      1,
      0,
      NULL,
      4,
      3.123145,
      5,
      9,
      3.200659,
      1,
      5,
      3,
      1.171604,
      2,
      NULL,
      0.193612,
      63,
      1,
      NULL,
      82,
      NULL,
      NULL,
      NULL,
      0,
      1.375097,
      NULL,
      '31304',
      '21132',
      '',
      0,
      NULL,
      '',
      '',
      2,
      '122',
      '',
      '',
      1,
      25,
      190.964419,
      9,
      2,
      29,
      1,
      1,
      4,
      NULL,
      1,
      0.979732,
      1.729031,
      NULL,
      NULL,
      1.694837,
      NULL,
      NULL,
      0.710772,
      2.194148,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.482290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.502408,
      NULL,
      NULL,
      1.067059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.101158,
      NULL,
      0,
      1.875359,
      NULL,
      NULL,
      0.283542,
      0.014291,
      1.772075,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      0,
      NULL,
      1.791703,
      3,
      NULL,
      1,
      NULL,
      0,
      3.716277,
      0.621095,
      2,
      1.953047,
      2.546356,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      3.217590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.856200,
      NULL,
      NULL,
      0.751351,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.056279,
      0.336239,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1.011607,
      1.970873,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.368145,
      NULL,
      NULL,
      1.176030,
      3,
      1.479061,
      2.305148,
      2,
      3.667588,
      6,
      8.321263,
      7.559270,
      7.540917,
      7,
      7,
      NULL,
      5.899882,
      2,
      NULL,
      1.334840,
      1.452058,
      3.752823,
      3.928565,
      2,
      0.504464,
      3,
      1,
      5.931128,
      3,
      2.411353,
      NULL,
      2,
      NULL,
      0.645188,
      0,
      0,
      2.253408,
      0,
      2,
      NULL,
      NULL,
      3.356075,
      NULL,
      10.395000,
      2.029826,
      5,
      NULL,
      4,
      0,
      0,
      1,
      1,
      1.722599,
      1.609296,
      1,
      1.380247,
      1.746991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.515721,
      NULL,
      NULL,
      0.066408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.860203,
      0.351110,
      0,
      NULL,
      NULL,
      NULL,
      3.735150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.943322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.111706,
      1.090494,
      NULL,
      NULL,
      2.615398,
      0.905551,
      NULL,
      NULL,
      1.557826,
      3.420612,
      NULL,
      NULL,
      0.928911,
      0.036732,
      NULL,
      NULL,
      1.335767,
      3.041754,
      NULL,
      NULL,
      0.899360,
      0.937504,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      0.906289,
      NULL,
      NULL,
      NULL,
      0.735879,
      15,
      9,
      1.634142,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.209543,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      2.854338,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2.638119,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.465029,
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      3.888921,
      NULL,
      21.759801,
      NULL,
      NULL,
      2.501376,
      NULL,
      3.788335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.548920,
      NULL,
      NULL,
      NULL,
      1.234952,
      NULL,
      0.601671,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.964819,
      NULL,
      1.325745,
      NULL,
      0,
      2.489043,
      0.401099,
      3.183702,
      NULL,
      1,
      NULL,
      0.264455,
      NULL,
      3.224682,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.652624,
      NULL,
      NULL,
      1,
      1.216638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.575298,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.039189,
      NULL,
      0.090899,
      NULL,
      1.469528,
      NULL,
      1,
      0.630431,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615322,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      163,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.406815,
      29.744547,
      30,
      3,
      1,
      0,
      2.508283,
      0,
      0,
      2,
      8,
      0.704904,
      5,
      1,
      1,
      5,
      2.908155,
      3.826970,
      0.775326,
      1,
      0.362346,
      NULL,
      0,
      3,
      3,
      0.533980,
      0.297343,
      1.280608,
      1,
      1,
      0,
      0,
      3.546002,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.051886,
      0.915351,
      3.952388,
      2,
      2,
      1.230722,
      NULL,
      1.223078,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.604998,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888009,
      0,
      1.832048,
      0.703552,
      1.705418,
      0.897258,
      1,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      57,
      1,
      0.648208,
      3,
      '04332',
      '03132',
      '41334',
      NULL,
      '01110',
      '',
      '',
      NULL,
      NULL,
      '441',
      '411');
commit;
end;
/


