set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      4,
      3.520539,
      NULL,
      7.601453,
      0,
      1,
      1.757195,
      '120',
      '31402411',
      17.025467,
      42.709287,
      '3010330',
      1.783700,
      0,
      1,
      3,
      '1243',
      NULL,
      0,
      NULL,
      NULL,
      ' 1-17-1988',
      30,
      35.190518,
      NULL,
      0,
      0.976196,
      ' 7-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '10-18-1996',
      0.244760,
      0,
      0,
      3.351920,
      NULL,
      0.053854,
      1,
      1.405741,
      1,
      NULL,
      NULL,
      12.161793,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0.797553,
      0.219192,
      1,
      NULL,
      0.550342,
      NULL,
      NULL,
      1.738669,
      3,
      1,
      1,
      NULL,
      0,
      0,
      0,
      4,
      5,
      1,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      8.546941,
      1,
      1,
      2,
      NULL,
      0.706405,
      NULL,
      NULL,
      0.006611,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0.819263,
      1,
      0,
      2,
      NULL,
      3,
      3,
      NULL,
      1,
      3.278807,
      NULL,
      NULL,
      NULL,
      3.239815,
      0.002486,
      0,
      1,
      4,
      NULL,
      1,
      2,
      1,
      0.797457,
      NULL,
      NULL,
      1.112455,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      4,
      2,
      4,
      1,
      1,
      2,
      1,
      NULL,
      1,
      5.415647,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      5,
      3,
      5,
      1,
      1,
      5,
      0,
      2,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      0,
      3,
      3,
      2,
      1,
      0,
      1.039899,
      '10-28-1981',
      75.873158,
      ' 9- 1-1996',
      39,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      0,
      4,
      0.429090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.660073,
      3.479875,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.002811,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.573037,
      NULL,
      1,
      1.125234,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.425888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.151446,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.344865,
      1,
      NULL,
      3,
      NULL,
      3,
      0,
      0,
      1,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.691406,
      NULL,
      NULL,
      0,
      1.332482,
      1.555960,
      1.495873,
      1,
      1,
      2.373575,
      4.392965,
      0,
      8,
      3.073589,
      6,
      8.192280,
      0,
      5.411889,
      NULL,
      0,
      5.483208,
      3,
      0,
      3.111182,
      NULL,
      3,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      2.360824,
      5.183133,
      NULL,
      '20341',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.215058,
      32,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.077455,
      NULL,
      NULL,
      1.241760,
      3,
      2.786091,
      0,
      NULL,
      NULL,
      0.779877,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.946802,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.256828,
      0.124475,
      8.790072,
      1,
      0.268136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.242282,
      3,
      0,
      NULL,
      2,
      1.055821,
      2.611024,
      3.634317,
      NULL,
      NULL,
      2.634435,
      2,
      1,
      0,
      3.625661,
      1,
      1.902434,
      2,
      NULL,
      3.602869,
      0,
      0.809971,
      0,
      1.110269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494814,
      1,
      0,
      3.716072,
      4.734894,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.245108,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4,
      2.530701,
      1.346084,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      4.028970,
      0.359912,
      NULL,
      NULL,
      1.837941,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.078072,
      1,
      3,
      2.898739,
      1.762523,
      1.019096,
      6.293784,
      NULL,
      1,
      2,
      2.662208,
      NULL,
      NULL,
      0.858419,
      3.756506,
      1.071550,
      NULL,
      0,
      1.842385,
      5,
      NULL,
      5,
      2,
      0.735230,
      NULL,
      NULL,
      3.040887,
      0,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      5.090571,
      3.140945,
      4,
      NULL,
      NULL,
      0.959519,
      NULL,
      3,
      0,
      1.047334,
      NULL,
      0.093054,
      0.788392,
      1,
      2,
      NULL,
      NULL,
      1.351782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391789,
      NULL,
      NULL,
      3.713811,
      NULL,
      NULL,
      1.717859,
      NULL,
      NULL,
      2.721730,
      NULL,
      NULL,
      1.532858,
      0.184799,
      0,
      0.454984,
      1.067354,
      1,
      0,
      NULL,
      NULL,
      2.992017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459994,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015935,
      NULL,
      NULL,
      NULL,
      0.990391,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614215,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      3.539849,
      3,
      3,
      1,
      NULL,
      1.375980,
      1,
      1,
      3.239411,
      NULL,
      0.259662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1.553900,
      0.079992,
      0.371623,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.385112,
      1.487080,
      1,
      NULL,
      0,
      0.427954,
      0.637740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.387809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736024,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511494,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641919,
      0.110924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480278,
      1.251106,
      NULL,
      3.668952,
      NULL,
      NULL,
      NULL,
      85,
      NULL,
      3,
      NULL,
      1.703977,
      NULL,
      1,
      NULL,
      3.987819,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      7,
      1,
      1.963520,
      5,
      0,
      13.679657,
      2,
      3.315803,
      0.011654,
      0,
      1,
      NULL,
      1.469378,
      2.643809,
      NULL,
      1.503848,
      3,
      NULL,
      1,
      3,
      NULL,
      1,
      0.536586,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1.026881,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.768579,
      0,
      NULL,
      0.597898,
      0,
      0.229731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.232884,
      NULL,
      1.685336,
      NULL,
      0.578312,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.967796,
      NULL,
      NULL,
      NULL,
      2.173576,
      NULL,
      1,
      NULL,
      NULL,
      2.342826,
      NULL,
      NULL,
      NULL,
      1.894905,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      36.082995,
      112,
      0,
      0,
      0,
      '04211',
      '43033',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


