set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7829517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      NULL,
      NULL,
      '2213224',
      NULL,
      1,
      1,
      2,
      '2320',
      5,
      1,
      NULL,
      NULL,
      ' 9-24-1989',
      7.323873,
      2.510118,
      NULL,
      3,
      1.278791,
      ' 0-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1981',
      ' 8-26-1980',
      ' 9-14-1991',
      NULL,
      NULL,
      0.959346,
      1,
      NULL,
      NULL,
      0,
      0.150415,
      1.413546,
      288.207241,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5,
      3.917841,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      1.475836,
      2,
      0.645354,
      1,
      1.254163,
      2,
      0.147623,
      0.367957,
      2,
      2.965488,
      NULL,
      3.754928,
      2.105262,
      1.334828,
      1,
      1,
      1,
      7.254195,
      0,
      NULL,
      2,
      1.651463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.559660,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      5,
      NULL,
      4,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      2,
      0.717054,
      0.515794,
      '11-18-1986',
      2266.378448,
      ' 8-18-1982',
      556,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.407049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1714.975420,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.701511,
      NULL,
      NULL,
      NULL,
      0,
      0.275648,
      0.919511,
      0.528894,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.785170,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.246909,
      1,
      0.037029,
      0,
      0.351665,
      2.105620,
      NULL,
      NULL,
      0.384031,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.279327,
      1,
      NULL,
      1,
      0,
      0,
      2,
      3,
      0,
      2,
      NULL,
      1,
      0.312250,
      2,
      3,
      0,
      0.097522,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923499,
      NULL,
      1,
      0.725606,
      NULL,
      NULL,
      NULL,
      2.432532,
      2.541186,
      NULL,
      NULL,
      0.068457,
      NULL,
      3.900244,
      0,
      0,
      3.771118,
      41,
      2,
      2,
      17,
      NULL,
      NULL,
      60.661965,
      0,
      NULL,
      1.703107,
      '10244',
      '',
      '',
      1.586827,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      3.328329,
      5,
      656.150478,
      3,
      1,
      2,
      7.394408,
      15,
      4,
      1.867263,
      1.328987,
      1.470853,
      1.618732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      3.931025,
      0,
      NULL,
      0.813421,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      0.601417,
      1.950482,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152176,
      1.861206,
      1.727991,
      NULL,
      NULL,
      NULL,
      1.992266,
      NULL,
      2.042614,
      1,
      1.368916,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.905955,
      3.176588,
      2,
      NULL,
      NULL,
      0,
      0.265133,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.502959,
      1,
      0.003944,
      2.336269,
      1,
      1.221886,
      0.706247,
      2,
      NULL,
      0.965125,
      NULL,
      NULL,
      1,
      0.972261,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.075596,
      1,
      NULL,
      1.102680,
      6.846495,
      NULL,
      1.482578,
      NULL,
      NULL,
      NULL,
      3.858274,
      NULL,
      0.109913,
      1.773333,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.100284,
      1,
      1.285567,
      NULL,
      NULL,
      NULL,
      0.568996,
      3,
      1.512077,
      0.477701,
      0,
      0.186053,
      NULL,
      NULL,
      0.540636,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.388178,
      0.931087,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.049842,
      NULL,
      NULL,
      1.572062,
      NULL,
      NULL,
      0.707395,
      NULL,
      NULL,
      0.970424,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.614169,
      1,
      3,
      3.973515,
      1,
      2.401947,
      2,
      3,
      1.323849,
      7.269655,
      0.233646,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      0,
      6,
      NULL,
      2,
      1,
      2,
      0.948914,
      3,
      2,
      1,
      NULL,
      1,
      0.329686,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.711730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.482343,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.451048,
      3.752765,
      NULL,
      1,
      3.921915,
      NULL,
      NULL,
      6,
      192.258167,
      221.294145,
      NULL,
      0.923073,
      3,
      3.788829,
      NULL,
      1.409623,
      NULL,
      0,
      NULL,
      3.362733,
      1.804080,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.798265,
      NULL,
      NULL,
      3,
      NULL,
      1.923021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.447634,
      NULL,
      NULL,
      NULL,
      1,
      2.161265,
      NULL,
      NULL,
      1.606270,
      1,
      0.632917,
      NULL,
      0,
      1.103594,
      1,
      NULL,
      1.931499,
      2.209941,
      NULL,
      NULL,
      0.921849,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.637890,
      0.911912,
      1,
      NULL,
      0.897772,
      NULL,
      1.437809,
      NULL,
      7,
      13.128862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      66.206834,
      3.204658,
      NULL,
      NULL,
      0.461077,
      NULL,
      NULL,
      0,
      89,
      66.218197,
      2.643468,
      4.559160,
      95,
      2.789154,
      22,
      21,
      0.646300,
      NULL,
      1.422867,
      781.663324,
      0.569415,
      0,
      0.014818,
      1,
      1.770435,
      NULL,
      1.477594,
      1,
      1.729917,
      0.852237,
      NULL,
      0.586378,
      1.059957,
      NULL,
      NULL,
      NULL,
      0,
      1.231002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      1.970199,
      4.231686,
      2.189222,
      2,
      5,
      0,
      2.825311,
      3.660226,
      1.889989,
      0,
      1.089022,
      0.400448,
      NULL,
      NULL,
      NULL,
      0.300022,
      1,
      0.243474,
      1,
      1,
      NULL,
      NULL,
      1,
      0.900306,
      1,
      0,
      0,
      0,
      1.550664,
      0,
      NULL,
      0.276531,
      NULL,
      0.627392,
      0,
      1.145846,
      1,
      1.440989,
      NULL,
      0,
      1,
      3,
      3.959376,
      0.534733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.803856,
      NULL,
      3,
      0.891218,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.149274,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      0.647652,
      1.514148,
      1.092959,
      0.867626,
      NULL,
      0,
      0,
      1,
      1,
      0,
      19,
      2.144668,
      NULL,
      0.380890,
      NULL,
      1,
      0,
      0.508678,
      0.408883,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      3,
      5,
      5.910483,
      '23034',
      '03403',
      NULL,
      0.369734,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


