set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5800019';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1203422',
      2.208395,
      NULL,
      0,
      NULL,
      '1032',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1996',
      4.694715,
      NULL,
      NULL,
      0,
      NULL,
      ' 0-19-1979',
      41,
      NULL,
      245,
      112,
      1,
      ' 7-21-1980',
      ' 2-21-1991',
      ' 8- 7-1976',
      0.972969,
      1.640585,
      0.368633,
      3.377537,
      1,
      NULL,
      0,
      1,
      0.719071,
      92,
      5,
      13,
      3,
      160,
      113,
      5,
      13,
      4,
      0,
      6,
      1,
      0,
      0,
      1.637584,
      NULL,
      1,
      1.270480,
      NULL,
      1,
      0,
      136,
      3,
      2,
      2,
      NULL,
      4,
      1,
      0,
      4,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      3,
      1,
      4.225838,
      1,
      1,
      NULL,
      2,
      0.996684,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1.946796,
      3,
      0.984132,
      NULL,
      NULL,
      1,
      0.972443,
      1,
      0,
      1.987209,
      NULL,
      1,
      0.686186,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.586706,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      3,
      1,
      4,
      5,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      3,
      NULL,
      1,
      4,
      2,
      1,
      1,
      1,
      0,
      0,
      2,
      0,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      4,
      NULL,
      NULL,
      4,
      1,
      '11-19-1989',
      248.597226,
      NULL,
      3.193119,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.167966,
      0,
      NULL,
      1.445141,
      6,
      3,
      NULL,
      1,
      1,
      5,
      0.503695,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444146,
      1.646156,
      1.721995,
      0.882230,
      1.523731,
      NULL,
      1,
      NULL,
      2,
      0,
      126.711107,
      252,
      735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5.925902,
      2.341881,
      8,
      3.545565,
      0.022451,
      NULL,
      2,
      0,
      2,
      0,
      0.290468,
      36,
      3,
      NULL,
      NULL,
      54,
      12,
      7,
      NULL,
      NULL,
      3.268234,
      NULL,
      '',
      '',
      1.640683,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      119.824268,
      22.280048,
      0,
      32,
      0.876368,
      70,
      5,
      0.128148,
      2.252253,
      3.785546,
      0.723216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.884671,
      NULL,
      NULL,
      1.366900,
      0,
      0.182485,
      0.548020,
      NULL,
      NULL,
      0.416076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.322096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.082873,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.144598,
      13.570998,
      NULL,
      NULL,
      7.137625,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0.593528,
      0,
      1,
      1.246861,
      0.285292,
      1.618071,
      1,
      1,
      1,
      1.552859,
      0,
      NULL,
      NULL,
      1.107497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.022486,
      1,
      NULL,
      0.468303,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441906,
      3,
      1.236437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5.728520,
      0.582713,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      8,
      0,
      1,
      1.998664,
      NULL,
      NULL,
      1.266910,
      NULL,
      NULL,
      1.473820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.331736,
      NULL,
      NULL,
      2.181350,
      1,
      0.320257,
      3.546480,
      0,
      1,
      6,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      1,
      2,
      1,
      0.587223,
      0.843841,
      3,
      2.348554,
      0.089160,
      NULL,
      3,
      9.076952,
      8.159055,
      1.866752,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      3,
      3.641029,
      1,
      1,
      11,
      0.360726,
      NULL,
      NULL,
      4,
      2.373042,
      1.137861,
      1,
      3,
      0.301027,
      0,
      1.581191,
      NULL,
      0,
      0.565775,
      NULL,
      NULL,
      0.200046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.739810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.595921,
      NULL,
      NULL,
      0.746324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687628,
      NULL,
      0.982475,
      0,
      NULL,
      1,
      0.270491,
      NULL,
      NULL,
      1.658421,
      2.969120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188221,
      0.748952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401112,
      2,
      NULL,
      NULL,
      3.269939,
      3.483737,
      NULL,
      NULL,
      0,
      0.540191,
      NULL,
      NULL,
      3,
      3.384271,
      NULL,
      NULL,
      NULL,
      1.506785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.058671,
      1.767400,
      NULL,
      NULL,
      1,
      1.872790,
      NULL,
      NULL,
      1,
      0.457835,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.384417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      102,
      79.381673,
      NULL,
      NULL,
      NULL,
      1.608884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      21.483759,
      NULL,
      NULL,
      NULL,
      0.566148,
      NULL,
      1.175860,
      8520.198071,
      1465.763562,
      0.153066,
      NULL,
      1,
      0.147769,
      1.452376,
      1,
      0.322298,
      1.973762,
      NULL,
      1,
      0,
      1,
      1.715037,
      0.248501,
      1.431970,
      1.722441,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      13,
      3.585890,
      4,
      3.011778,
      1,
      15,
      NULL,
      2,
      1.486434,
      9.364953,
      4.494549,
      1,
      11.092094,
      6,
      NULL,
      NULL,
      NULL,
      2,
      17.573547,
      19.089843,
      1.396179,
      2,
      14.315789,
      0.465428,
      NULL,
      17,
      0,
      6,
      14,
      1.284770,
      0,
      NULL,
      1.154944,
      15,
      13.422540,
      1,
      18,
      19.352865,
      1,
      9,
      0,
      0.314004,
      1.972928,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      3,
      2,
      0,
      3,
      20.452016,
      NULL,
      5,
      0,
      0,
      NULL,
      '',
      NULL,
      1.199599,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


