set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3.747862,
      NULL,
      3,
      4.008677,
      2.125585,
      2.237309,
      3.917459,
      '412',
      '41022311',
      52,
      56.050817,
      '0133004',
      1,
      1,
      5,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 4-18-2002',
      107,
      179,
      NULL,
      0.647267,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11- 2-1984',
      NULL,
      0,
      3,
      NULL,
      0.540606,
      0,
      0,
      0.913660,
      NULL,
      NULL,
      NULL,
      10,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.501773,
      NULL,
      0,
      0.552794,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      3.204822,
      4,
      1,
      1,
      3,
      NULL,
      1,
      5,
      5,
      3,
      4,
      3,
      0,
      5,
      NULL,
      2,
      1,
      0,
      1.431487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.357537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2,
      4,
      1,
      1,
      0,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.569004,
      NULL,
      0,
      1,
      4,
      5,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      2,
      NULL,
      3,
      3,
      NULL,
      5,
      1,
      2,
      3,
      0,
      2,
      5,
      3.001203,
      NULL,
      129,
      ' 2-25-1991',
      4,
      0.518051,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      0,
      1,
      1.857088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.670058,
      NULL,
      0,
      1,
      0,
      NULL,
      0.273082,
      1.985183,
      0,
      2.334004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166166,
      1,
      1.284694,
      0.564015,
      NULL,
      1.468809,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.415600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520200,
      3,
      1,
      1.005638,
      0,
      NULL,
      1.322997,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.431707,
      0,
      2,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      2,
      2.152244,
      2.291697,
      0.163659,
      1.146111,
      NULL,
      1.698798,
      NULL,
      1,
      0,
      1.211406,
      0,
      1,
      1,
      0,
      0.567696,
      NULL,
      NULL,
      3,
      0,
      4.161782,
      6,
      0,
      NULL,
      1.891002,
      NULL,
      NULL,
      1,
      5,
      0.013593,
      NULL,
      0,
      30,
      0,
      0.018896,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222496,
      0,
      '04401',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.365776,
      '',
      '',
      '',
      3,
      7.181545,
      37.989956,
      39,
      0,
      NULL,
      2.951749,
      0.675357,
      NULL,
      0.296512,
      1.354933,
      0,
      0.207910,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.391824,
      NULL,
      1,
      1.604729,
      2,
      2.375450,
      0.660705,
      NULL,
      NULL,
      0.102728,
      3.022439,
      3,
      1.508483,
      1.445391,
      0,
      1.128298,
      NULL,
      0,
      0,
      3.721293,
      1,
      0.274336,
      1.302990,
      NULL,
      1,
      1,
      0,
      9.612829,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964723,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669048,
      NULL,
      NULL,
      0.061888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.721904,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.778772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189642,
      NULL,
      NULL,
      2.474424,
      3,
      1.267431,
      1.381782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      3,
      0.694391,
      2.059401,
      0.978648,
      NULL,
      NULL,
      NULL,
      4,
      4,
      1.546580,
      1,
      NULL,
      NULL,
      0.092333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.176891,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      3,
      NULL,
      NULL,
      4.951522,
      NULL,
      0,
      NULL,
      NULL,
      0.153561,
      NULL,
      NULL,
      0,
      2.399616,
      0,
      2,
      2.680623,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959314,
      3.279624,
      NULL,
      NULL,
      1.473333,
      NULL,
      3.129790,
      2,
      2.763537,
      3,
      2,
      1,
      NULL,
      2.176990,
      NULL,
      2,
      0,
      3,
      NULL,
      1,
      0,
      1.701894,
      1.219710,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424238,
      NULL,
      NULL,
      0.711440,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.306270,
      1,
      1,
      NULL,
      0.302615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715951,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.680737,
      NULL,
      NULL,
      NULL,
      1.927600,
      NULL,
      NULL,
      NULL,
      2.770376,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.935202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.715659,
      0.361631,
      2.915267,
      5.237162,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.235919,
      NULL,
      0,
      NULL,
      0,
      1.896490,
      0,
      1.564159,
      1,
      1,
      0,
      1,
      1.709274,
      0,
      1.103345,
      1,
      0.085313,
      NULL,
      NULL,
      0.504614,
      1.312618,
      1,
      0.882929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      2.892070,
      1.166867,
      NULL,
      0,
      1,
      NULL,
      1.107390,
      1.396591,
      1.039115,
      3,
      NULL,
      1,
      2,
      NULL,
      1.777452,
      3.564971,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.898311,
      NULL,
      0,
      1.996381,
      NULL,
      0,
      1.516124,
      NULL,
      2,
      1.214204,
      0.413425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403251,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      0.211152,
      NULL,
      NULL,
      12.839178,
      NULL,
      1,
      NULL,
      2,
      '34044',
      NULL,
      '',
      0.278454,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


