set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7509559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      1.019113,
      NULL,
      NULL,
      1,
      '4313',
      NULL,
      0,
      NULL,
      NULL,
      ' 1-29-1985',
      NULL,
      NULL,
      NULL,
      3.834158,
      0.446240,
      ' 5- 0-1983',
      40.026629,
      0,
      NULL,
      NULL,
      1,
      '11-17-1983',
      ' 2-20-1997',
      ' 7-25-1989',
      3.056307,
      NULL,
      NULL,
      2.167219,
      1.247755,
      2.280829,
      1,
      0,
      1.592299,
      11.358961,
      NULL,
      16.947565,
      2,
      2,
      11,
      5,
      6.934747,
      3,
      0,
      5,
      NULL,
      1,
      0,
      1,
      1.856106,
      0,
      1.091016,
      NULL,
      0.760074,
      NULL,
      0.088382,
      3,
      2,
      NULL,
      0.228977,
      3,
      0,
      2,
      1,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      2,
      1,
      4.975761,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.118130,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1.060737,
      0.203445,
      1.799464,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.752879,
      1,
      NULL,
      1,
      0.422056,
      1,
      1,
      NULL,
      1,
      0,
      2,
      5.780845,
      1.732706,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      3,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      0,
      3,
      0,
      4,
      1,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      2,
      NULL,
      0,
      5,
      0,
      0,
      3,
      1.537769,
      2,
      '10-20-1993',
      1404,
      ' 9-24-2001',
      48.661552,
      0.510492,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      1.805429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7,
      NULL,
      2,
      7.538379,
      NULL,
      3,
      1.222158,
      NULL,
      0.622583,
      3,
      0.831380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.150672,
      NULL,
      0,
      229.159500,
      0.795231,
      0.907405,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.613066,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      3,
      2,
      2,
      0,
      NULL,
      2.356821,
      1,
      NULL,
      NULL,
      2.659631,
      NULL,
      NULL,
      0.916387,
      0.480154,
      NULL,
      0.811376,
      1.366658,
      NULL,
      0,
      0,
      3.857294,
      0.841174,
      NULL,
      NULL,
      6.378916,
      7.101704,
      8.858074,
      2,
      1,
      1.089908,
      5.112503,
      2.739279,
      NULL,
      1,
      3,
      2,
      2.888070,
      NULL,
      30,
      18,
      NULL,
      NULL,
      1.246209,
      NULL,
      '02134',
      '12103',
      NULL,
      1.631967,
      '',
      '',
      '',
      0.712575,
      '',
      '',
      '',
      1,
      3,
      69,
      3.756147,
      3.424553,
      32.069334,
      0.696253,
      NULL,
      NULL,
      NULL,
      1.777255,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.022189,
      3,
      3,
      1.105821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.920135,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      0.888712,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.736293,
      3,
      0,
      0,
      2.490044,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3.663707,
      0.675188,
      3.488540,
      0,
      0,
      0,
      0,
      1,
      0.946456,
      NULL,
      0,
      NULL,
      0.728484,
      1.394966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.977834,
      5.624536,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.217440,
      NULL,
      NULL,
      NULL,
      3,
      1.549097,
      NULL,
      1.116649,
      2.033248,
      NULL,
      NULL,
      NULL,
      1.521506,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504516,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.501044,
      NULL,
      NULL,
      NULL,
      1,
      2.969481,
      0.249789,
      NULL,
      NULL,
      2.292800,
      5,
      NULL,
      2,
      5,
      1.973241,
      NULL,
      NULL,
      NULL,
      2,
      1.242660,
      1,
      2,
      NULL,
      1,
      NULL,
      2,
      2,
      3.415095,
      5.312060,
      6,
      2.725167,
      0,
      NULL,
      2.402875,
      0,
      0.146306,
      2.145528,
      2,
      0,
      NULL,
      0,
      1.943292,
      5,
      NULL,
      NULL,
      2.455998,
      NULL,
      NULL,
      0.131162,
      2,
      4,
      1.493509,
      0,
      NULL,
      NULL,
      0.304655,
      2.361880,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.222622,
      NULL,
      NULL,
      0.645391,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.643770,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.056541,
      1,
      2.257180,
      0.803543,
      NULL,
      NULL,
      0,
      3.989213,
      NULL,
      NULL,
      7.644144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494466,
      NULL,
      NULL,
      NULL,
      1,
      0.838720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.176480,
      0.550062,
      NULL,
      NULL,
      2.267461,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.553445,
      NULL,
      NULL,
      2.523685,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.716312,
      NULL,
      NULL,
      1.068182,
      1,
      NULL,
      NULL,
      NULL,
      0.980952,
      8,
      2,
      1.687606,
      310,
      460,
      0.658828,
      1639,
      1462,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.394705,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      37,
      0.419857,
      NULL,
      1.416273,
      1.948963,
      1,
      1.584750,
      1,
      NULL,
      1.724711,
      0,
      0.646435,
      0.353114,
      1,
      1,
      0.436796,
      1,
      0,
      2.440485,
      NULL,
      0.080493,
      NULL,
      0.439571,
      NULL,
      1.194283,
      NULL,
      1.518251,
      NULL,
      3,
      NULL,
      24.908321,
      NULL,
      1,
      2,
      NULL,
      0.892256,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.848308,
      NULL,
      NULL,
      NULL,
      1.247002,
      NULL,
      1.579450,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.302461,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923797,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194177,
      0.031215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057002,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.250962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.975234,
      NULL,
      3.759229,
      NULL,
      46.831402,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.688392,
      3.182701,
      37,
      5.610614,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      11.169392,
      1,
      1,
      3,
      2,
      10,
      1.403599,
      NULL,
      1,
      0,
      1.483518,
      1,
      NULL,
      0,
      1.647673,
      NULL,
      0,
      0.118224,
      1,
      NULL,
      NULL,
      0.418854,
      0,
      0.717939,
      0.906299,
      0.858108,
      1,
      0.195591,
      0.068197,
      2.093776,
      NULL,
      NULL,
      1.032742,
      NULL,
      1,
      1.706937,
      NULL,
      1,
      NULL,
      NULL,
      0.877609,
      0.715326,
      0.334767,
      NULL,
      1.943507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.962043,
      2.467804,
      NULL,
      0.086799,
      1.224750,
      3.636917,
      1.440949,
      NULL,
      1,
      1.633951,
      0,
      NULL,
      NULL,
      2.635064,
      1.000091,
      0,
      NULL,
      1.459004,
      0.100892,
      1.686043,
      1.140702,
      0.270902,
      0.469902,
      0,
      11.224760,
      0.932992,
      1967.291614,
      1,
      0,
      1,
      NULL,
      1,
      1,
      4,
      6,
      3,
      1.930835,
      0,
      0,
      37.666720,
      NULL,
      5,
      0.826490,
      0,
      '41012',
      '34040',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


