set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      0.094398,
      1.305811,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 6-11-1979',
      NULL,
      NULL,
      2,
      0,
      1.776085,
      ' 4-11-1987',
      37.300628,
      0,
      34,
      242.250059,
      NULL,
      ' 0- 0-1987',
      ' 4-16-1997',
      ' 0-15-2003',
      0.810475,
      3,
      NULL,
      3.351159,
      NULL,
      3,
      2,
      1.537266,
      NULL,
      291.186024,
      0,
      7,
      0.534174,
      23.651752,
      24.246089,
      NULL,
      NULL,
      4,
      4,
      3,
      1.989133,
      0,
      NULL,
      0.094256,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      6,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1.140578,
      2,
      1.075491,
      1,
      2,
      NULL,
      NULL,
      1.494213,
      3.211366,
      0,
      0.296531,
      1,
      1.798169,
      NULL,
      0.818427,
      3,
      NULL,
      1,
      4,
      3,
      7.161166,
      0,
      1,
      NULL,
      0.657874,
      NULL,
      NULL,
      0.695287,
      NULL,
      NULL,
      NULL,
      5,
      5,
      1,
      0,
      1,
      0,
      0,
      0,
      2,
      1,
      1,
      1,
      3,
      1,
      0,
      0,
      NULL,
      1.510585,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      4,
      2,
      2,
      4,
      NULL,
      4,
      2,
      3,
      3,
      5,
      1,
      NULL,
      3,
      5.200991,
      3.180907,
      ' 7-12-1974',
      369.031684,
      NULL,
      827.832800,
      2.376599,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1,
      1,
      1,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1.108435,
      NULL,
      0,
      0.211777,
      NULL,
      1.454758,
      1,
      1,
      5,
      0.547221,
      1.393869,
      3,
      0.308003,
      0,
      NULL,
      0,
      0.043210,
      NULL,
      5.618650,
      0.298862,
      0.191631,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508175,
      0.654338,
      1,
      1.567244,
      1.131921,
      NULL,
      0,
      0,
      30,
      NULL,
      1.267954,
      22,
      33.386906,
      154,
      0,
      1,
      3.766514,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      0,
      0.646795,
      NULL,
      0.572604,
      0.705310,
      1.429517,
      1.550475,
      5.429995,
      1.496983,
      1.202731,
      NULL,
      1.359358,
      0.943687,
      0.264741,
      NULL,
      NULL,
      1,
      10,
      NULL,
      NULL,
      3,
      6.162616,
      2.904173,
      11,
      10,
      5.919601,
      2.793087,
      NULL,
      5,
      2.581003,
      1,
      0,
      19.818205,
      2,
      0,
      NULL,
      59,
      51,
      55,
      0,
      0.271727,
      0,
      '43100',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.590699,
      '33031',
      '3443',
      '02002',
      0.900740,
      0,
      278,
      4.754708,
      3.484557,
      0,
      9.091524,
      44.323296,
      2,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.273396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.384552,
      NULL,
      NULL,
      NULL,
      1,
      1.172213,
      0.884794,
      NULL,
      NULL,
      0.145250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.753372,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.307306,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.753810,
      2.939376,
      0,
      NULL,
      0.471861,
      1,
      NULL,
      NULL,
      0.004819,
      0.516577,
      2.285605,
      3,
      3,
      0.621479,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      0,
      3.959908,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.551251,
      1,
      3,
      1.218608,
      0.029925,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.313037,
      3.923949,
      2.647687,
      3.199928,
      0.496477,
      1.053567,
      3,
      3,
      2.735139,
      0,
      3,
      NULL,
      3,
      1,
      1.646845,
      0,
      1,
      1.421759,
      0,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.879210,
      NULL,
      NULL,
      1.981043,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.557911,
      NULL,
      0,
      4,
      1,
      1,
      3,
      0,
      0.521472,
      1.252396,
      1.353218,
      0.333539,
      3.641493,
      NULL,
      2.677975,
      5.293929,
      0.589122,
      6,
      2,
      1.092280,
      1.830171,
      NULL,
      NULL,
      NULL,
      2.578704,
      0.449649,
      NULL,
      1.615271,
      0.000990,
      NULL,
      8.741751,
      4,
      2.533811,
      1,
      7.599667,
      NULL,
      1,
      3,
      0,
      NULL,
      2,
      1,
      1,
      0.291315,
      2.777736,
      NULL,
      NULL,
      6.145512,
      NULL,
      NULL,
      129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.540725,
      NULL,
      NULL,
      1.287024,
      NULL,
      NULL,
      3.563218,
      NULL,
      NULL,
      0.908665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.248081,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.345481,
      1.480218,
      3,
      2.194945,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      1.865063,
      83,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.672964,
      NULL,
      NULL,
      1,
      0.977833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.163120,
      3.495112,
      NULL,
      NULL,
      0.807888,
      0,
      NULL,
      NULL,
      0,
      1.923823,
      NULL,
      NULL,
      1.597276,
      NULL,
      NULL,
      NULL,
      1.581568,
      0.572682,
      NULL,
      NULL,
      2.553842,
      6,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.218090,
      506,
      236.803109,
      2.160682,
      8.383564,
      2.362352,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.884965,
      0.380843,
      6,
      0,
      1,
      NULL,
      NULL,
      104.320157,
      39.225837,
      0.198781,
      0,
      0,
      0,
      1.958647,
      1.757898,
      0,
      NULL,
      1,
      NULL,
      0.092335,
      1,
      NULL,
      0.566522,
      NULL,
      0,
      0.385301,
      1.558182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      16.522494,
      2,
      0.175466,
      1,
      3,
      1,
      1.077332,
      2,
      1.979456,
      0,
      2.460885,
      2.163290,
      2.339569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.675420,
      0,
      0,
      3,
      1,
      3.856978,
      0.354274,
      NULL,
      2.892970,
      0,
      NULL,
      3.647127,
      0.461289,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.267367,
      NULL,
      1,
      3.982389,
      NULL,
      0.206221,
      2,
      3.362715,
      0.675559,
      1.355269,
      1.895854,
      NULL,
      0.437911,
      1,
      NULL,
      1,
      3.839685,
      0.086328,
      0,
      1,
      0,
      0.269771,
      1.916068,
      2.152537,
      1,
      2.747222,
      2,
      NULL,
      0.062754,
      0,
      1,
      0,
      1.778526,
      0,
      NULL,
      6,
      2,
      NULL,
      1.335903,
      3,
      23,
      49.290396,
      0,
      NULL,
      4,
      '21244',
      '03010',
      NULL,
      NULL,
      '31010',
      NULL,
      '',
      1,
      '34434',
      '4042',
      '42324');
commit;
end;
/


