set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9835448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.886387,
      2,
      1,
      0.392931,
      NULL,
      0,
      0.315563,
      NULL,
      '010',
      NULL,
      13.362126,
      9,
      '2303112',
      3,
      NULL,
      0,
      3,
      '1423',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.070287,
      NULL,
      1,
      NULL,
      ' 6-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1993',
      3.185666,
      1,
      NULL,
      3.968904,
      1.219021,
      1,
      3,
      1,
      1,
      81.048824,
      6,
      14,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      1,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1.397169,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.084605,
      1.710620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      5,
      0,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0.137500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.324026,
      0.328690,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.488654,
      0.017143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.283507,
      0,
      0,
      NULL,
      1.810369,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.725621,
      1.588936,
      1,
      1,
      3,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2,
      0,
      2.614048,
      3.702824,
      1.439424,
      1,
      NULL,
      1,
      0.596318,
      1.576973,
      0,
      0,
      1.298399,
      1,
      NULL,
      0.498689,
      1,
      0.712562,
      0.557126,
      1,
      NULL,
      NULL,
      1.578640,
      3.635549,
      NULL,
      NULL,
      2.708704,
      3.704114,
      3.377083,
      3,
      2.136061,
      1.794199,
      NULL,
      NULL,
      0,
      80,
      NULL,
      NULL,
      NULL,
      NULL,
      2.243418,
      NULL,
      '11410',
      '',
      '',
      0.875931,
      '',
      '',
      NULL,
      0.553967,
      '02412',
      '00000',
      '',
      2.696192,
      54,
      NULL,
      3.897651,
      1.912119,
      21.593174,
      1,
      7,
      0,
      0.371195,
      0.015925,
      2.113572,
      1.966096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.653461,
      0,
      3,
      0,
      NULL,
      NULL,
      0.295534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.915405,
      2.091070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004363,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925015,
      NULL,
      NULL,
      0.415950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.534355,
      0,
      1.380705,
      1.312097,
      NULL,
      NULL,
      0,
      1.154037,
      1,
      0.288881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.044559,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.259600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.006669,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1.953240,
      2.359996,
      NULL,
      3.594206,
      1.273421,
      NULL,
      1,
      1,
      1.518693,
      NULL,
      0,
      0,
      NULL,
      0,
      3.702865,
      3.455321,
      3.917434,
      2.527495,
      1,
      0,
      2.836124,
      1.634509,
      8.670794,
      3.164024,
      5,
      NULL,
      NULL,
      NULL,
      3.197949,
      1,
      1,
      0.649953,
      0,
      0,
      NULL,
      0.229552,
      3,
      NULL,
      NULL,
      1.294722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839685,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.615424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295618,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.757392,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.781930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.968524,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.645793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579885,
      0.865014,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.800849,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566228,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.962793,
      1.788593,
      NULL,
      NULL,
      1.666073,
      1,
      NULL,
      NULL,
      0.873374,
      NULL,
      NULL,
      NULL,
      0,
      0.839984,
      NULL,
      NULL,
      0.932008,
      0,
      NULL,
      NULL,
      1,
      5.325666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      2,
      341.455275,
      32.089081,
      NULL,
      NULL,
      NULL,
      1.162145,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.903587,
      NULL,
      NULL,
      1.252214,
      NULL,
      0,
      251,
      0.299781,
      NULL,
      1.076716,
      0,
      NULL,
      1,
      0.738619,
      0.597885,
      0.994708,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.340153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      3.866603,
      2.506634,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.987659,
      NULL,
      NULL,
      0,
      1,
      2,
      3.577686,
      0,
      1,
      NULL,
      NULL,
      1,
      0.319043,
      0.282397,
      0.473217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245456,
      1.420631,
      0.458494,
      1,
      1,
      NULL,
      1.110394,
      3.348966,
      2,
      0,
      0,
      0,
      2,
      1.261741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746789,
      1,
      0.457084,
      0,
      0.087368,
      1.189132,
      4,
      3,
      2,
      1.568179,
      NULL,
      NULL,
      21,
      45,
      0,
      1.239666,
      1.852330,
      '02113',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.284734,
      '34401',
      '13121',
      '');
commit;
end;
/


