set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3111100',
      0.569789,
      1.891170,
      6,
      3,
      '3231',
      1.704881,
      1.461813,
      NULL,
      NULL,
      ' 1-16-2000',
      10.784627,
      NULL,
      0,
      0.975274,
      2,
      ' 0-25-1988',
      15,
      0,
      NULL,
      70,
      0,
      '10-11-1979',
      NULL,
      ' 9- 3-2003',
      NULL,
      NULL,
      2.001030,
      NULL,
      NULL,
      0.846540,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.161439,
      NULL,
      14.831416,
      23,
      NULL,
      24,
      0,
      1,
      1.607959,
      1.176890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      2.251894,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.184785,
      NULL,
      1.044706,
      1,
      0.023167,
      1,
      0.523835,
      2,
      2,
      0.601667,
      NULL,
      2.642776,
      0,
      3,
      1.452102,
      1,
      0,
      NULL,
      3,
      2,
      0.566242,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      0,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      5,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0.083326,
      0,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      4,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      4,
      1,
      2,
      3,
      2.890709,
      NULL,
      135,
      ' 6- 9-1987',
      158,
      3,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      1,
      1,
      0,
      4,
      1,
      1,
      3,
      NULL,
      0.043791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.836294,
      1,
      1.162515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.051810,
      NULL,
      4,
      3.367580,
      0.706645,
      NULL,
      0.308494,
      1,
      5.453034,
      0.496028,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.172407,
      0,
      0.537931,
      2,
      47.266312,
      2,
      1.929515,
      NULL,
      NULL,
      NULL,
      1,
      1.450605,
      2.306656,
      1,
      2,
      1,
      1,
      0,
      0,
      1,
      3,
      1,
      NULL,
      2,
      0.584189,
      0,
      2.469848,
      0,
      1,
      NULL,
      1.356037,
      NULL,
      5.440142,
      1,
      1,
      0.703925,
      0.745475,
      0,
      3,
      0.148555,
      3.104532,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      17,
      35.845691,
      3,
      1,
      2,
      '34311',
      '',
      '',
      0.790245,
      '',
      '',
      '',
      0.192921,
      '',
      '',
      NULL,
      NULL,
      34,
      17.178319,
      NULL,
      0,
      NULL,
      3.001413,
      1,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.026060,
      1.252720,
      0.280719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.620133,
      3.326332,
      1,
      2,
      1,
      1.848406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.553150,
      1,
      2,
      NULL,
      NULL,
      NULL,
      5.614300,
      NULL,
      1.232404,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.018586,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.419625,
      0,
      NULL,
      3,
      1.732857,
      1,
      3,
      1.921992,
      0.576009,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      1.460017,
      0.117798,
      0,
      1.973070,
      3.708408,
      3,
      0.123898,
      0,
      NULL,
      NULL,
      0.722353,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      0,
      0.037497,
      0.329496,
      1,
      2,
      0,
      NULL,
      NULL,
      6,
      3,
      0,
      2.951956,
      1.297483,
      1.831560,
      1,
      2.739643,
      2.751999,
      8,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.363958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.653867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018850,
      NULL,
      NULL,
      2,
      5.398716,
      3,
      2.165486,
      NULL,
      5,
      3,
      2.697844,
      0,
      2,
      1,
      2.884104,
      3.823243,
      2.346071,
      1.010636,
      3,
      NULL,
      4.506713,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.368642,
      0,
      3.149088,
      3.824491,
      NULL,
      1,
      2,
      4,
      4.115640,
      NULL,
      1.688741,
      0,
      1,
      0,
      0,
      0,
      0,
      0.859575,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.747518,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358529,
      0.387445,
      1.492098,
      NULL,
      2.594272,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574825,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904884,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.024331,
      NULL,
      NULL,
      NULL,
      3.569377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441219,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      11.141257,
      3,
      0.401283,
      NULL,
      NULL,
      0.030471,
      NULL,
      NULL,
      1.639196,
      NULL,
      NULL,
      3.474621,
      3,
      1,
      0,
      NULL,
      NULL,
      0.994159,
      NULL,
      1,
      1.771210,
      0,
      NULL,
      1.789835,
      NULL,
      1,
      NULL,
      0.762615,
      NULL,
      1,
      NULL,
      0.580292,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      5,
      NULL,
      1,
      NULL,
      2,
      5,
      0.642755,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.924179,
      NULL,
      0.216890,
      1.425637,
      NULL,
      1,
      1,
      NULL,
      1.124679,
      0,
      NULL,
      1.453134,
      NULL,
      NULL,
      NULL,
      1.931985,
      NULL,
      1,
      NULL,
      NULL,
      1.568367,
      NULL,
      NULL,
      1.185974,
      NULL,
      NULL,
      1,
      0.036717,
      NULL,
      3,
      1.549552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.021348,
      NULL,
      1,
      NULL,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      76.910178,
      0,
      5,
      5,
      0.841429,
      '12304',
      NULL,
      '',
      0.749351,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


