set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '3142144',
      2,
      NULL,
      4,
      3,
      NULL,
      3,
      1.611598,
      NULL,
      NULL,
      ' 2- 0-2000',
      NULL,
      NULL,
      NULL,
      0.286445,
      2,
      ' 3-29-1980',
      38.434389,
      3,
      229,
      90,
      2,
      ' 0-23-1992',
      ' 4-10-1997',
      ' 5-28-1980',
      1,
      NULL,
      3.280049,
      2.574429,
      1,
      NULL,
      0,
      1,
      0.384369,
      7,
      0,
      NULL,
      6.933592,
      NULL,
      NULL,
      NULL,
      20,
      5,
      2,
      10.923200,
      0.425962,
      0,
      1,
      1,
      1,
      0.257709,
      1,
      NULL,
      1.424610,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      1,
      0,
      2,
      3,
      1,
      0,
      0,
      5,
      1,
      4,
      0,
      0,
      0,
      1,
      0.884163,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      0.482734,
      0,
      1,
      0,
      1.304722,
      1,
      0,
      NULL,
      1.795588,
      1,
      2.886885,
      1.077898,
      1,
      1,
      0,
      NULL,
      0,
      3.456477,
      1,
      1,
      0,
      0.860405,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      1,
      3,
      1,
      5,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      2,
      0,
      2,
      5,
      1,
      1,
      NULL,
      3,
      0,
      5,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      0,
      ' 2-11-1991',
      118,
      ' 2- 6-1994',
      16.142205,
      0.894832,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      0,
      NULL,
      NULL,
      0,
      1.971094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.375337,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.331384,
      1,
      2,
      1,
      3.381442,
      9.658796,
      6.531750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.454581,
      0,
      NULL,
      2,
      NULL,
      NULL,
      8.318928,
      ' 1-11-1996',
      10.994775,
      ' 3-25-1995',
      20.151089,
      0.849847,
      NULL,
      0.567797,
      3.229291,
      0.787659,
      0,
      0.821462,
      0.433025,
      NULL,
      0,
      2.926017,
      94,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      3,
      0,
      1,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      0.303768,
      3,
      2,
      3.702747,
      NULL,
      3.947935,
      3,
      1.043902,
      1.150259,
      0.307149,
      1,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      3.210657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      60,
      1,
      NULL,
      0,
      NULL,
      3.280658,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.845863,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096798,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.170259,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982448,
      NULL,
      0.927073,
      0.817293,
      NULL,
      1,
      0,
      0.125621,
      0.251416,
      NULL,
      1,
      1,
      0,
      0.172696,
      NULL,
      1,
      0,
      0.213870,
      1.219172,
      1.268382,
      1,
      1.306871,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.089384,
      NULL,
      2.858517,
      3,
      1,
      13.157858,
      2,
      2,
      1.947198,
      0.702269,
      NULL,
      NULL,
      3,
      3.095057,
      NULL,
      3.123249,
      0,
      NULL,
      0.463343,
      1.046293,
      NULL,
      0.198584,
      2.581268,
      NULL,
      0,
      0,
      NULL,
      0,
      2.999800,
      NULL,
      3.561241,
      0,
      NULL,
      1,
      1,
      NULL,
      0.742651,
      3,
      NULL,
      0.270398,
      1,
      NULL,
      2,
      0.876833,
      1.687234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.896482,
      2.953078,
      NULL,
      0.418963,
      NULL,
      3.187551,
      NULL,
      1,
      NULL,
      0.272873,
      NULL,
      1.815614,
      NULL,
      3.979911,
      NULL,
      0,
      NULL,
      0.254689,
      NULL,
      0.204435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660111,
      NULL,
      29,
      1.711752,
      1229.531852,
      0.779807,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.769481,
      NULL,
      NULL,
      79.932311,
      118,
      5,
      NULL,
      3.828095,
      '14123',
      '',
      NULL,
      NULL,
      '24303',
      '',
      '',
      0.748816,
      NULL,
      '',
      '');
commit;
end;
/


