set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0422331',
      1.944643,
      1,
      NULL,
      3,
      '1444',
      1,
      1.430018,
      NULL,
      NULL,
      '10- 4-1999',
      2.925662,
      NULL,
      2,
      0.258489,
      1,
      ' 3-12-1994',
      15,
      3.080298,
      NULL,
      87.735204,
      0,
      ' 0-24-1998',
      ' 4-26-1991',
      ' 9-28-1981',
      1.790020,
      1.925691,
      1.488540,
      NULL,
      0,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.576201,
      NULL,
      NULL,
      12.808574,
      5,
      18,
      NULL,
      3,
      7.111953,
      0.410165,
      3,
      NULL,
      1,
      1.567720,
      0,
      1.209618,
      2.756743,
      1.219452,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      3,
      0,
      2,
      0,
      3,
      0,
      5,
      1,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      1,
      2,
      0,
      1.560407,
      NULL,
      NULL,
      2.006373,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      1.428115,
      NULL,
      1.254706,
      NULL,
      1.530293,
      0,
      3.107807,
      NULL,
      0.546224,
      1.773254,
      2,
      0.109468,
      0.728595,
      0.442839,
      0,
      5,
      2,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      0,
      1,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1.978044,
      NULL,
      0,
      NULL,
      0,
      1.646317,
      NULL,
      1.424718,
      5,
      NULL,
      0,
      3,
      0,
      2,
      1,
      2,
      NULL,
      NULL,
      2,
      4,
      1,
      1,
      NULL,
      5,
      3,
      NULL,
      3,
      3,
      1,
      5,
      3,
      2,
      1,
      5,
      NULL,
      ' 9-14-1985',
      153.063684,
      '11-26-1990',
      40.920459,
      1,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      10,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.839885,
      0.730488,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.331323,
      NULL,
      5,
      9,
      3.077101,
      NULL,
      NULL,
      NULL,
      2.872872,
      10.554843,
      2.936081,
      1,
      3,
      NULL,
      1,
      ' 2- 7-1986',
      12.107955,
      NULL,
      24.271166,
      1,
      1,
      0,
      2.725924,
      0,
      1.289556,
      NULL,
      0.311836,
      1.716502,
      1.058687,
      0.371161,
      88,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      3,
      0,
      3,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.857051,
      1,
      0,
      1,
      0.180925,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.811152,
      4,
      1,
      NULL,
      0.659951,
      11.439610,
      0.796603,
      NULL,
      3,
      7.875819,
      NULL,
      0.258340,
      NULL,
      61,
      1,
      0.063214,
      NULL,
      32,
      21,
      17,
      0,
      1,
      NULL,
      '00112',
      '',
      '',
      2.572522,
      NULL,
      NULL,
      '',
      0.058633,
      NULL,
      '',
      NULL,
      1.809126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.709736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.070504,
      NULL,
      1.545653,
      NULL,
      NULL,
      1.129372,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.812862,
      1,
      0,
      1.201234,
      0.972705,
      1,
      1.406532,
      1,
      1,
      0.746998,
      1.321658,
      NULL,
      0,
      NULL,
      0.512804,
      1,
      1.712676,
      1.751388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      6,
      5,
      6,
      3,
      2,
      18,
      1.593253,
      2,
      0.921419,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.908269,
      1.323432,
      NULL,
      1.098721,
      0.721868,
      NULL,
      2,
      1.152781,
      NULL,
      0,
      NULL,
      NULL,
      3.937054,
      NULL,
      NULL,
      NULL,
      2.155416,
      NULL,
      0,
      0.239915,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3.870931,
      1,
      0.718529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.531421,
      NULL,
      2,
      NULL,
      3.957233,
      NULL,
      3.398551,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733716,
      11,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      97.316890,
      111,
      4,
      NULL,
      3,
      '30030',
      NULL,
      '',
      0.966070,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


