set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '1121041',
      0,
      1.737856,
      4,
      1,
      '1134',
      0.115455,
      1.245507,
      NULL,
      NULL,
      ' 3-23-1986',
      NULL,
      NULL,
      0,
      2.850038,
      NULL,
      ' 2- 2-1985',
      14,
      2.703165,
      345.836584,
      156.859519,
      3,
      '11- 5-1994',
      ' 9- 7-1989',
      ' 6-29-1975',
      1,
      0,
      NULL,
      2.213193,
      1,
      3,
      2,
      NULL,
      NULL,
      22,
      1,
      15,
      6,
      14,
      NULL,
      2,
      0.644438,
      1,
      NULL,
      0.490971,
      1,
      1,
      1,
      0,
      NULL,
      1.648493,
      1,
      NULL,
      NULL,
      1,
      1.494159,
      0,
      0,
      3,
      NULL,
      4,
      1,
      NULL,
      5,
      4,
      3,
      4,
      NULL,
      5,
      2,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3.420684,
      0,
      1,
      5,
      1,
      0.838288,
      3,
      0,
      0,
      0,
      1.868698,
      1.069879,
      1.876674,
      NULL,
      1.107922,
      NULL,
      1.359900,
      0,
      3,
      1.044373,
      0.778710,
      1.927751,
      5,
      1,
      0,
      1,
      1,
      2,
      1.400385,
      1,
      NULL,
      NULL,
      3.272700,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      3.780491,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.834247,
      1,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      5,
      NULL,
      0,
      0,
      2,
      1,
      5,
      2,
      5,
      5,
      NULL,
      NULL,
      5,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      '11-27-1984',
      135.192641,
      ' 4-15-1981',
      19,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      15.511834,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.369059,
      0,
      NULL,
      NULL,
      NULL,
      1.055544,
      4,
      4,
      1,
      0.722737,
      1,
      5.543725,
      0.603095,
      NULL,
      NULL,
      3,
      11.021648,
      3.857731,
      0,
      1,
      0,
      5.765869,
      NULL,
      59.463156,
      ' 7-19-1984',
      17.350462,
      1.023985,
      0,
      1.485589,
      2.348159,
      NULL,
      1.772504,
      3,
      0,
      0.983669,
      1.064522,
      0,
      39,
      1.354660,
      0.812436,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      3,
      2,
      0,
      3,
      0,
      0,
      0,
      2,
      2,
      1,
      2,
      2.698786,
      NULL,
      2,
      1,
      NULL,
      3.060699,
      0,
      1.624843,
      1.660433,
      0,
      NULL,
      1.606533,
      0,
      1,
      1.040409,
      4.424476,
      0.986922,
      NULL,
      4,
      NULL,
      2,
      2,
      NULL,
      4,
      3.192365,
      2.115490,
      NULL,
      NULL,
      2.305694,
      NULL,
      3,
      0,
      NULL,
      9,
      59,
      NULL,
      NULL,
      0.038935,
      3.326046,
      '00233',
      '',
      '',
      1,
      '20321',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.209045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.825129,
      0,
      0.936558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.380706,
      0.050245,
      0,
      NULL,
      NULL,
      0.597681,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684349,
      1.475815,
      NULL,
      0.951740,
      1.550565,
      0,
      NULL,
      0.422390,
      1,
      1,
      0,
      0,
      1,
      0.255987,
      0,
      1,
      0.645665,
      0.211676,
      1.100230,
      1,
      0.636071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      5.308504,
      NULL,
      1,
      23,
      NULL,
      2,
      NULL,
      0.146591,
      NULL,
      NULL,
      1.641501,
      3,
      NULL,
      2.181459,
      0,
      NULL,
      2.075290,
      0.483090,
      NULL,
      NULL,
      0.539263,
      NULL,
      1.677167,
      1,
      NULL,
      NULL,
      1.577294,
      NULL,
      2.262364,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.729390,
      3.080148,
      NULL,
      0.215414,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256270,
      1.874179,
      NULL,
      NULL,
      NULL,
      2.265525,
      NULL,
      1.606814,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.145766,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      19,
      1,
      19,
      0,
      NULL,
      NULL,
      NULL,
      1.608784,
      NULL,
      0,
      2,
      4,
      1,
      NULL,
      NULL,
      NULL,
      125,
      0,
      NULL,
      3.591736,
      NULL,
      NULL,
      NULL,
      0.242146,
      '40313',
      '',
      NULL,
      1.771440,
      '',
      '',
      '');
commit;
end;
/


