set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313298';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4244431',
      0,
      0,
      3,
      3,
      '0332',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1980',
      NULL,
      NULL,
      NULL,
      2.858092,
      1,
      ' 6-13-1979',
      44,
      0,
      120.142835,
      111,
      0,
      ' 8-18-1984',
      ' 3-16-1980',
      ' 7-24-2001',
      2.849530,
      1.748381,
      2,
      3.482302,
      1.637240,
      NULL,
      0,
      1,
      0.069328,
      122,
      1,
      NULL,
      11,
      18,
      20,
      3,
      3,
      3,
      0,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      4,
      0,
      4,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      4,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.039020,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      0.560400,
      1,
      1.626677,
      NULL,
      2,
      0.912778,
      1.472411,
      1.367356,
      0.292836,
      1,
      1,
      2,
      2.130922,
      0,
      1,
      0,
      4,
      1,
      NULL,
      1.656838,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      5,
      5,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1.176737,
      1,
      0.444249,
      1,
      5,
      1,
      1,
      0,
      NULL,
      4,
      1,
      0,
      1,
      5,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      4,
      2,
      0,
      2,
      2.507393,
      2,
      ' 2-10-2003',
      174,
      ' 5-14-1993',
      79.705654,
      2.673740,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.851799,
      0.724557,
      0.074636,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.104034,
      1,
      1.716411,
      0,
      3,
      1,
      1,
      5,
      4.156967,
      1,
      5,
      1.345071,
      0.765333,
      2,
      2,
      1,
      7.167390,
      1.995805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373922,
      1.343385,
      1,
      0.628974,
      1.710606,
      3.511482,
      NULL,
      NULL,
      NULL,
      7,
      95.898716,
      117.503950,
      1,
      NULL,
      0,
      1,
      1,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.040067,
      3,
      0.365903,
      1.848855,
      1.905365,
      NULL,
      NULL,
      NULL,
      0,
      0.400884,
      0.116690,
      0,
      1,
      1.669000,
      0.868880,
      0,
      1,
      5,
      NULL,
      5,
      NULL,
      7,
      NULL,
      6,
      1.428418,
      2.920052,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      30.627829,
      NULL,
      1,
      NULL,
      NULL,
      17,
      31.691561,
      2,
      NULL,
      2,
      '31222',
      '02324',
      '',
      1.127313,
      '',
      '',
      '',
      1.828694,
      '11311',
      '',
      '',
      2,
      19,
      186,
      4.188115,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.379978,
      3,
      0.111436,
      NULL,
      NULL,
      0,
      2.617781,
      NULL,
      1.415515,
      2,
      NULL,
      0,
      3.272413,
      0,
      1.835806,
      1,
      1.248514,
      1.640306,
      3.594201,
      0.468930,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      4.213230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.287874,
      NULL,
      2,
      3,
      1.507822,
      NULL,
      NULL,
      1.915211,
      2,
      1,
      NULL,
      3.792688,
      1.183847,
      1.602478,
      2,
      0,
      NULL,
      3,
      3.444981,
      1,
      NULL,
      2.837524,
      2,
      2,
      0.439773,
      NULL,
      NULL,
      0.967072,
      NULL,
      NULL,
      NULL,
      2,
      1.440215,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.746217,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.327894,
      1,
      0,
      NULL,
      0,
      1,
      1.169214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577177,
      3,
      1.916808,
      1,
      3,
      1,
      1,
      3.008869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.194285,
      NULL,
      NULL,
      1,
      NULL,
      0.555205,
      7,
      1,
      0,
      0.784324,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3,
      1.344673,
      6.389181,
      NULL,
      0,
      7.498118,
      0.126994,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.642026,
      NULL,
      NULL,
      7,
      2,
      3.750109,
      3,
      3,
      2,
      2,
      NULL,
      0.546517,
      NULL,
      NULL,
      3.320110,
      NULL,
      1,
      3,
      NULL,
      5,
      0,
      0,
      NULL,
      0,
      1.748916,
      NULL,
      1,
      0,
      2,
      0,
      0,
      0,
      0.559913,
      NULL,
      NULL,
      3.641400,
      NULL,
      NULL,
      1.191785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.472543,
      NULL,
      NULL,
      1.967008,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.420865,
      NULL,
      NULL,
      0.596910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841245,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.397478,
      3.356743,
      1.856519,
      1,
      0.103720,
      1,
      1.036720,
      NULL,
      NULL,
      7.778972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012940,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418283,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.294911,
      NULL,
      NULL,
      NULL,
      3.425875,
      NULL,
      NULL,
      NULL,
      1.172971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.905561,
      NULL,
      NULL,
      NULL,
      3.370590,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.031647,
      NULL,
      NULL,
      NULL,
      3.257204,
      NULL,
      NULL,
      NULL,
      2.893410,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1.020654,
      1,
      9,
      NULL,
      1,
      107,
      92.057671,
      2.325207,
      3.752150,
      NULL,
      1.323546,
      NULL,
      NULL,
      2,
      13,
      NULL,
      NULL,
      1,
      NULL,
      2,
      11.563673,
      2,
      1.154268,
      NULL,
      0,
      1574.721898,
      9,
      0.018132,
      NULL,
      1,
      0,
      1,
      0.050684,
      1,
      0.855123,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1.876031,
      NULL,
      0.757103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.308433,
      0.581930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.850377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366096,
      3.642153,
      NULL,
      0.452130,
      1.694859,
      NULL,
      NULL,
      NULL,
      1.903983,
      0.190440,
      1.419570,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.488810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657707,
      0.775792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.826245,
      NULL,
      1.395045,
      NULL,
      NULL,
      NULL,
      0.435447,
      NULL,
      1.486311,
      NULL,
      1.308089,
      0.796519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.520274,
      0.427003,
      4,
      3,
      3,
      7,
      0.292554,
      0.233389,
      3.722877,
      0,
      3.647835,
      NULL,
      0,
      0.833805,
      0,
      1,
      0.455090,
      1,
      0,
      1.702690,
      0.786129,
      1.265562,
      0.539442,
      NULL,
      1.199008,
      1.745965,
      3.483172,
      1,
      1.916268,
      1,
      0,
      3.098886,
      NULL,
      1,
      NULL,
      0.310640,
      NULL,
      1,
      0,
      1.978487,
      0.476277,
      1.206224,
      0,
      2.643459,
      1.115418,
      NULL,
      3,
      NULL,
      0.476919,
      1,
      3,
      NULL,
      2,
      NULL,
      0,
      1.368798,
      1.680122,
      NULL,
      1.566721,
      0,
      1.279319,
      0,
      3.995973,
      NULL,
      1,
      2.152345,
      2,
      3.577070,
      NULL,
      1,
      1,
      16.567061,
      1,
      3,
      0.698354,
      3,
      0,
      NULL,
      3,
      0.804482,
      NULL,
      2,
      3.351337,
      0,
      3.480244,
      1.292402,
      3,
      3,
      1.410651,
      1,
      3.788020,
      2,
      1,
      0,
      0.275868,
      0.210030,
      1,
      NULL,
      NULL,
      3,
      2,
      11.355631,
      3.053076,
      NULL,
      1.605876,
      0.066110,
      3.426305,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      64.931566,
      3,
      0,
      3,
      NULL,
      '03232',
      '',
      1.834375,
      NULL,
      '',
      '',
      3,
      '04320',
      '',
      '');
commit;
end;
/


