set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603567';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1100121',
      1.367956,
      1.156558,
      0,
      NULL,
      '2000',
      1.095664,
      NULL,
      NULL,
      NULL,
      ' 1-17-1990',
      64,
      NULL,
      0,
      NULL,
      0.641966,
      ' 3- 5-1999',
      38,
      1.484662,
      73,
      10,
      3,
      ' 1- 9-2003',
      '11-21-1988',
      NULL,
      NULL,
      0.805622,
      1,
      NULL,
      NULL,
      2.109932,
      NULL,
      0,
      NULL,
      NULL,
      6,
      12.814370,
      3,
      14,
      12,
      1,
      16,
      1,
      1,
      NULL,
      2.204958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2.317066,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.975391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.348941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      3,
      0,
      0,
      3,
      1,
      1,
      0,
      1,
      0.128477,
      NULL,
      0.046001,
      1,
      3,
      1,
      1,
      1,
      3,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      5,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      5,
      1,
      '10- 0-1986',
      NULL,
      ' 0-29-1979',
      220,
      1.504669,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.441444,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1.775975,
      0.761314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.425793,
      1,
      NULL,
      1,
      0.794434,
      2,
      34.417127,
      1.293249,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1.691344,
      0.387215,
      1.210302,
      1.226993,
      1,
      NULL,
      1.731611,
      NULL,
      NULL,
      1.750095,
      0.047877,
      1,
      0,
      3,
      NULL,
      1.909934,
      5,
      7,
      NULL,
      5.140437,
      10.013166,
      5,
      NULL,
      NULL,
      6,
      2.265840,
      2.055356,
      2.766886,
      NULL,
      1,
      2,
      NULL,
      27,
      1,
      26.531070,
      0,
      3.164637,
      1,
      '10131',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      14,
      217,
      39.045905,
      3.195213,
      14,
      0.276633,
      49.180281,
      3,
      2.875086,
      0.880024,
      3.024459,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817772,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.917915,
      1.099097,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.210176,
      1.497910,
      0.780601,
      NULL,
      NULL,
      8.854209,
      1,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.108160,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.524187,
      NULL,
      NULL,
      1.456878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673691,
      NULL,
      NULL,
      NULL,
      0.941021,
      2,
      0.888589,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.146171,
      5,
      2,
      0.212351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.513772,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.390646,
      NULL,
      NULL,
      1.823508,
      NULL,
      NULL,
      0.050780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911804,
      NULL,
      NULL,
      0,
      1.894792,
      1.829838,
      1.959885,
      NULL,
      NULL,
      2.465868,
      5.449310,
      1.248684,
      1,
      NULL,
      NULL,
      1.561927,
      0.751673,
      1.086000,
      0,
      NULL,
      1,
      0.474941,
      1.335766,
      NULL,
      5.288625,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      2,
      3,
      1.296886,
      1.261245,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.832765,
      NULL,
      NULL,
      3.081484,
      NULL,
      NULL,
      1,
      0,
      0.944168,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.666022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205480,
      NULL,
      NULL,
      NULL,
      1.834981,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.378606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      373,
      3,
      1,
      NULL,
      NULL,
      0.055652,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.125115,
      NULL,
      NULL,
      0.705358,
      NULL,
      NULL,
      0,
      NULL,
      0,
      159.812885,
      2,
      0.504001,
      0,
      0.390938,
      1,
      NULL,
      1,
      0.697975,
      1.276982,
      0.353878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671873,
      0.708482,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.143589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.727914,
      NULL,
      1.764011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.714090,
      NULL,
      0.488323,
      NULL,
      0,
      0,
      1.455660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.337330,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.963918,
      NULL,
      0,
      NULL,
      NULL,
      1.332821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      4.301820,
      NULL,
      0,
      5.807932,
      1,
      NULL,
      NULL,
      0,
      1.552346,
      1.086744,
      1,
      NULL,
      1.426075,
      0.876531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.974265,
      NULL,
      1,
      2.598877,
      NULL,
      1.697493,
      0.772929,
      NULL,
      NULL,
      1.880953,
      NULL,
      0.190341,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.942230,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.230277,
      1.079864,
      1.520619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.531120,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      3.623452,
      2.556265,
      3.089109,
      NULL,
      70,
      4,
      1,
      2.920885,
      '43412',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


