set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.275281,
      NULL,
      3.015181,
      3,
      0.368783,
      NULL,
      1.019074,
      '103',
      '20443114',
      27,
      19,
      '1044432',
      2,
      0.183301,
      5,
      2,
      '4323',
      2,
      0.222418,
      NULL,
      NULL,
      NULL,
      57.359304,
      31,
      NULL,
      2,
      NULL,
      '11- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-14-1988',
      ' 6-11-1997',
      ' 7-26-1986',
      2.374463,
      1,
      2,
      3,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.987680,
      0,
      0,
      1,
      0.488227,
      0,
      1.539292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      5.050187,
      0,
      0,
      2,
      NULL,
      0.154839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      3,
      1.514010,
      NULL,
      1,
      0.746529,
      2,
      NULL,
      0.326710,
      3.679400,
      1.068639,
      NULL,
      NULL,
      0,
      3,
      3.935671,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.242711,
      NULL,
      2,
      0,
      1.160859,
      NULL,
      NULL,
      0.079409,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      2,
      NULL,
      0,
      1,
      0,
      1.289492,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      4,
      0,
      2,
      4,
      5,
      1,
      0,
      NULL,
      0,
      4,
      3,
      2,
      0,
      2,
      2,
      NULL,
      4,
      0.071195,
      1,
      ' 3- 2-1983',
      155,
      ' 6-20-2001',
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      5,
      2,
      0.806154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.982742,
      1.102983,
      NULL,
      1.967246,
      1,
      NULL,
      2.625214,
      NULL,
      5,
      0.022390,
      NULL,
      1.811759,
      NULL,
      0.412202,
      NULL,
      2,
      NULL,
      4,
      1.688667,
      7,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.974222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.847636,
      NULL,
      0.786808,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.258743,
      3.308918,
      2,
      NULL,
      3,
      NULL,
      2,
      2,
      NULL,
      2,
      NULL,
      1,
      1.863211,
      1,
      0.222668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332057,
      NULL,
      0,
      NULL,
      0.168796,
      0,
      0,
      1.326800,
      1,
      1.945499,
      5.610793,
      NULL,
      2.918853,
      4.246758,
      10.798312,
      1.278327,
      5.754622,
      2.890723,
      7,
      NULL,
      3,
      3,
      69,
      2,
      3,
      23,
      NULL,
      26,
      NULL,
      2,
      2,
      2.883331,
      '24424',
      '',
      '',
      1.590149,
      NULL,
      '',
      '',
      0,
      '3144',
      '',
      '',
      2,
      NULL,
      25.681829,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078064,
      NULL,
      NULL,
      1.629038,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.814641,
      NULL,
      NULL,
      0.845850,
      NULL,
      NULL,
      0,
      NULL,
      2.368186,
      0,
      1.962633,
      NULL,
      3,
      2,
      1,
      1.312469,
      NULL,
      NULL,
      0,
      NULL,
      0.831738,
      1.909468,
      NULL,
      NULL,
      0.358147,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.727209,
      1.650144,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.572663,
      0.249086,
      0,
      2.059440,
      NULL,
      0,
      0.612003,
      1,
      1.971808,
      1.257899,
      3,
      1.437075,
      0,
      3.110020,
      3.177085,
      0.331349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.015586,
      1.626419,
      5,
      3.328186,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376781,
      NULL,
      NULL,
      NULL,
      0.515388,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.056759,
      NULL,
      NULL,
      0.107605,
      NULL,
      NULL,
      NULL,
      2,
      0.867122,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.615559,
      NULL,
      NULL,
      0.697688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212594,
      3.979698,
      0,
      0.302533,
      NULL,
      NULL,
      2,
      2.647913,
      3.126542,
      1,
      NULL,
      2,
      0.797417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      7,
      0.384412,
      0.587125,
      NULL,
      1.759343,
      NULL,
      1.733030,
      0.132612,
      1,
      1.016893,
      2.943161,
      3,
      0.571295,
      1,
      NULL,
      1,
      4,
      5.913152,
      2.536184,
      4.939705,
      0.313505,
      NULL,
      NULL,
      0,
      1.707767,
      1,
      0.799806,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.134344,
      NULL,
      NULL,
      0.791933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.015163,
      0,
      0.181733,
      0.339489,
      0.211793,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682060,
      NULL,
      NULL,
      NULL,
      1.727456,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.477156,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.394294,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.673755,
      0.491901,
      1.084970,
      1.606911,
      NULL,
      44,
      0,
      NULL,
      NULL,
      2.332210,
      3.718884,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.449228,
      NULL,
      0,
      NULL,
      0,
      1.917601,
      NULL,
      0.072382,
      0,
      NULL,
      0.128586,
      1.240587,
      1.233407,
      1.170362,
      0.437182,
      1.232583,
      0.309915,
      0,
      NULL,
      0.501502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      6.754903,
      2,
      2,
      1.865648,
      1,
      17,
      3,
      2.322502,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.267222,
      NULL,
      0,
      0,
      NULL,
      1.348062,
      0.774513,
      NULL,
      0.356011,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716237,
      1.563914,
      NULL,
      1.054243,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.282060,
      3.209114,
      NULL,
      1.402708,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.523035,
      NULL,
      2,
      4,
      NULL,
      1.106983,
      NULL,
      NULL,
      78.845086,
      8,
      NULL,
      1.350250,
      NULL,
      '10144',
      '22110',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      '0133',
      NULL,
      NULL);
commit;
end;
/


