set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9834815';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      0,
      0.700635,
      4.994400,
      NULL,
      2,
      0,
      NULL,
      '10230333',
      23.217999,
      58.022305,
      '4134043',
      2.038642,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 8-1989',
      103.299318,
      171.526503,
      NULL,
      3,
      NULL,
      '10- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1-28-1982',
      NULL,
      NULL,
      3,
      2.273983,
      1.635302,
      1,
      NULL,
      3.047874,
      4,
      0.884664,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.992058,
      1.883275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      4,
      0,
      1,
      0,
      0,
      3,
      4,
      4,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0.446247,
      2.888730,
      0.626714,
      1.732294,
      2,
      0.902718,
      1.004120,
      3,
      1.462079,
      0.117051,
      1,
      0.978679,
      NULL,
      1,
      1,
      NULL,
      2,
      2,
      NULL,
      0,
      5.074322,
      0,
      NULL,
      NULL,
      1.231267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      3,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      3,
      2,
      4,
      4,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.969626,
      ' 9-10-1988',
      379.362175,
      ' 3-25-2003',
      506,
      3.761893,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      4,
      0.779194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      0.365919,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.321794,
      7.436842,
      3.441893,
      1.538862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709607,
      1,
      0,
      1,
      0.023257,
      0,
      0.125421,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.401212,
      1,
      1,
      2,
      2,
      0,
      3,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      0.109787,
      1.939297,
      1,
      1,
      0,
      NULL,
      1.806401,
      0.757688,
      5.699892,
      0.909906,
      0.564848,
      NULL,
      NULL,
      0.132450,
      1,
      0,
      0,
      0,
      9,
      0.773849,
      4.449763,
      NULL,
      8.852691,
      7,
      4.276908,
      2.858751,
      4.273162,
      3,
      3.952613,
      NULL,
      55.783739,
      1,
      3,
      25,
      NULL,
      NULL,
      49,
      3,
      2,
      1.356605,
      '43222',
      '',
      '',
      1.949088,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      39.950246,
      73.012828,
      NULL,
      3,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838477,
      NULL,
      NULL,
      3,
      2,
      1.562453,
      NULL,
      2,
      1,
      3,
      0.930562,
      2.660416,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.504561,
      1.176935,
      0.199684,
      1.229908,
      NULL,
      NULL,
      8.810162,
      7,
      7,
      0,
      1.122472,
      NULL,
      NULL,
      NULL,
      1.925931,
      NULL,
      NULL,
      NULL,
      2.079077,
      1.061975,
      2.318974,
      1,
      2.815061,
      1.793751,
      1,
      NULL,
      NULL,
      2.958920,
      1,
      1,
      2.731677,
      1.209360,
      0.034278,
      0.543665,
      2.722096,
      NULL,
      3,
      0.189750,
      NULL,
      3,
      1.924652,
      2.594068,
      0,
      NULL,
      3.617609,
      0.799552,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.239270,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906504,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.478903,
      NULL,
      NULL,
      1.049418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.720851,
      NULL,
      3,
      0.553160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693585,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.358718,
      3.147703,
      1.030505,
      NULL,
      NULL,
      3.634308,
      3,
      4,
      3,
      0.125081,
      2,
      1.373259,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2.740695,
      2,
      2.115076,
      2.461921,
      2.800588,
      1,
      2,
      NULL,
      3,
      0,
      3.131071,
      3,
      8,
      NULL,
      0.836834,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.065443,
      0.898919,
      0,
      1.783698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.809361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.912888,
      0.643398,
      0.270623,
      0.544575,
      1.350168,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      167,
      NULL,
      NULL,
      NULL,
      3.274611,
      NULL,
      NULL,
      NULL,
      0.485820,
      NULL,
      NULL,
      NULL,
      0.063431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.694976,
      NULL,
      NULL,
      NULL,
      0.831943,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.236853,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      16,
      0.902458,
      NULL,
      21,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.983762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478928,
      NULL,
      1,
      0.056583,
      1.329431,
      0.674438,
      1,
      0.886839,
      0,
      1,
      0,
      NULL,
      NULL,
      0.357325,
      NULL,
      1.950451,
      1.476865,
      0.518349,
      NULL,
      1.385628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.850578,
      0,
      1.499455,
      3.459490,
      NULL,
      0.912394,
      1,
      NULL,
      NULL,
      2.871336,
      3,
      NULL,
      0.860937,
      0.525634,
      NULL,
      2.570040,
      3.144496,
      NULL,
      0.053050,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.249502,
      0.551033,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.999356,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      1,
      NULL,
      NULL,
      18.030166,
      68,
      4,
      0.687754,
      NULL,
      '10210',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


