set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '1400342',
      1,
      1.097861,
      NULL,
      2,
      '1222',
      2,
      1.015732,
      NULL,
      NULL,
      ' 5-10-1975',
      69,
      NULL,
      4,
      3.398880,
      NULL,
      ' 2-24-1976',
      77,
      2,
      96.955205,
      173,
      1,
      ' 2-18-1985',
      '11-26-1997',
      ' 3-14-1990',
      1,
      3.540960,
      1,
      1.921485,
      1,
      2,
      0,
      1,
      1,
      181.257178,
      2,
      8.111957,
      11,
      15.261981,
      NULL,
      3,
      25.562921,
      4,
      NULL,
      7,
      1.869121,
      0,
      NULL,
      NULL,
      0,
      0.174768,
      0.734326,
      1,
      0,
      0.609330,
      154,
      3,
      5,
      NULL,
      2.181062,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      2,
      0,
      6,
      1,
      NULL,
      1,
      0,
      1.564144,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      1,
      NULL,
      3,
      2,
      1,
      3,
      3.294818,
      0,
      3,
      0.944413,
      1,
      0.580822,
      1.632587,
      2.452325,
      3,
      0,
      0,
      2,
      0,
      1,
      1.479120,
      0,
      1,
      0.818649,
      1.174758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.566617,
      5,
      0,
      5,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      5,
      NULL,
      3,
      1,
      1,
      3,
      0,
      3,
      4,
      5,
      0,
      0,
      3,
      NULL,
      NULL,
      5,
      3.584537,
      NULL,
      ' 2-27-1997',
      597.024880,
      ' 8-23-1983',
      1744.751746,
      2.977503,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932146,
      0.882243,
      NULL,
      0.153907,
      NULL,
      1.615876,
      0.121071,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.105938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.329551,
      NULL,
      NULL,
      NULL,
      1.753467,
      0.081979,
      3.539234,
      NULL,
      1.650077,
      0.467163,
      143.620529,
      398.468147,
      NULL,
      3,
      0.488866,
      2.491390,
      0,
      1,
      2,
      1,
      3,
      1,
      3,
      1,
      0,
      1,
      1,
      0,
      NULL,
      82,
      54.050807,
      1,
      163,
      68.897252,
      35,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      2.196963,
      0.449455,
      3,
      6,
      0,
      0,
      1.883317,
      NULL,
      2,
      0.074813,
      5.469737,
      2.387622,
      0,
      1.802232,
      25.294346,
      1,
      3.524062,
      NULL,
      11,
      25,
      5,
      3,
      1,
      NULL,
      '14011',
      NULL,
      '',
      0.069534,
      '',
      '',
      '',
      3.992436,
      '2233',
      '13123',
      '',
      1,
      44,
      131,
      17.392826,
      1.828227,
      41.300471,
      NULL,
      NULL,
      0,
      0,
      2.364358,
      1.277417,
      0.961840,
      NULL,
      NULL,
      1.558987,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.158094,
      NULL,
      NULL,
      1.946674,
      NULL,
      NULL,
      2,
      0,
      0.895484,
      0.027211,
      NULL,
      NULL,
      1.466709,
      1,
      3.776945,
      0,
      0.388422,
      0.505743,
      0,
      0.686370,
      0,
      NULL,
      NULL,
      NULL,
      7,
      3.406375,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857374,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.408737,
      0,
      2.367160,
      2.843418,
      1.290653,
      NULL,
      NULL,
      2,
      0.257240,
      1.919225,
      0.887266,
      NULL,
      0,
      NULL,
      2,
      0,
      2.901916,
      2,
      1,
      3,
      2,
      2.892210,
      2.755260,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.960533,
      NULL,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.152292,
      0.804879,
      3,
      1.981372,
      1,
      3.555683,
      3.968583,
      NULL,
      2.161207,
      1.328783,
      NULL,
      NULL,
      1.161214,
      2.642578,
      5,
      3,
      0,
      1.968691,
      0,
      NULL,
      NULL,
      4,
      2.415293,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.584873,
      0,
      0.180785,
      2.943756,
      NULL,
      3,
      0.341392,
      2,
      2,
      2,
      1.949916,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      1.833991,
      0,
      3.222142,
      2.571472,
      1.464287,
      3,
      2.833764,
      1,
      2,
      2,
      1,
      0.793310,
      0.988589,
      2.167246,
      0,
      NULL,
      NULL,
      2.293021,
      2.011134,
      NULL,
      8.871745,
      1,
      1,
      9,
      5,
      NULL,
      2.980524,
      4,
      4,
      0.281526,
      0.335196,
      1.511636,
      1.222103,
      0,
      3.008814,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.775618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819989,
      NULL,
      NULL,
      1.929006,
      NULL,
      NULL,
      0.702726,
      NULL,
      NULL,
      1.331538,
      NULL,
      NULL,
      1.039517,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.554201,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      79.917204,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.884770,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.321339,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      6.300527,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      425.279179,
      NULL,
      1,
      NULL,
      NULL,
      0.336373,
      NULL,
      NULL,
      NULL,
      16,
      42.637748,
      0,
      NULL,
      NULL,
      0.825053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      72,
      1,
      1.444421,
      1.401419,
      1.163963,
      NULL,
      1.113126,
      0,
      1.674859,
      0.180759,
      0,
      1.641732,
      0.357160,
      0.897949,
      0.066015,
      1,
      1,
      1.676454,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.766936,
      2,
      1,
      0.571045,
      0,
      2.178551,
      0.899026,
      1,
      1,
      NULL,
      2.405511,
      2.590454,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662791,
      NULL,
      1,
      0.798634,
      NULL,
      0.655922,
      0.396634,
      NULL,
      1.729939,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.978657,
      0,
      NULL,
      3.310214,
      1.756382,
      1.244018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067946,
      NULL,
      NULL,
      NULL,
      0.500600,
      NULL,
      1,
      4,
      NULL,
      NULL,
      1,
      NULL,
      50,
      44,
      1,
      1.397625,
      2.223907,
      '03214',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0.440799,
      '3411',
      '03322',
      NULL);
commit;
end;
/


