set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7913233';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3110243',
      1,
      0.338311,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      ' 7-28-2000',
      1.162148,
      NULL,
      1,
      NULL,
      NULL,
      ' 8- 3-2000',
      15,
      0,
      29,
      NULL,
      1,
      '10- 9-1996',
      NULL,
      ' 4-19-1981',
      1.970310,
      0,
      2.389218,
      0,
      1,
      0,
      NULL,
      0.592725,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      18.719661,
      20.700753,
      2,
      NULL,
      4,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.280944,
      1,
      1.798120,
      1.430355,
      0,
      0,
      4,
      0.991430,
      1,
      2,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      1,
      0,
      NULL,
      0.355516,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      2.140633,
      0.004109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.259882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1.072287,
      NULL,
      1,
      0,
      NULL,
      0.859393,
      NULL,
      0.146211,
      5,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      2,
      0,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4,
      2,
      1,
      1,
      4,
      NULL,
      3,
      NULL,
      5,
      NULL,
      0.434433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0.960001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685771,
      1,
      NULL,
      3,
      1,
      2.945570,
      0.527226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362909,
      1,
      NULL,
      0,
      0,
      NULL,
      2.132054,
      2132.436130,
      1.327949,
      0.630862,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      3,
      3,
      1,
      3,
      3,
      3,
      3.132883,
      3.154476,
      1,
      0.609676,
      NULL,
      NULL,
      0.044002,
      NULL,
      1,
      NULL,
      1,
      1,
      1.971623,
      1,
      0,
      1,
      0.627235,
      NULL,
      1,
      3,
      2,
      NULL,
      2.928894,
      NULL,
      5.619794,
      NULL,
      NULL,
      5,
      NULL,
      2,
      2.943164,
      55,
      2,
      0.341351,
      NULL,
      66,
      8,
      46.590706,
      0,
      0,
      2.674939,
      '10400',
      '',
      '',
      1.222064,
      '',
      '',
      '',
      1.304042,
      '',
      '',
      NULL,
      3,
      NULL,
      104.036030,
      28,
      NULL,
      33.729513,
      9.325289,
      NULL,
      3,
      0.842228,
      2.313446,
      1,
      0.689922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.263379,
      0.293132,
      NULL,
      NULL,
      NULL,
      3.143597,
      2,
      0,
      NULL,
      1.747666,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.018962,
      0.057317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      4.987400,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.099927,
      NULL,
      NULL,
      NULL,
      0.846369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.275740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.125595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.354499,
      0.371679,
      1.947344,
      NULL,
      NULL,
      0,
      2,
      1.443216,
      0.963716,
      1.791299,
      0.871428,
      0.801097,
      NULL,
      2,
      1.070996,
      3,
      0.022873,
      8,
      3,
      NULL,
      0.638556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.572715,
      NULL,
      NULL,
      0.677863,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.273736,
      NULL,
      NULL,
      2,
      0.625113,
      2.644027,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      2.597933,
      7,
      NULL,
      1,
      0.740827,
      3.412107,
      1.366414,
      NULL,
      1,
      3.351606,
      1.707324,
      3.178367,
      NULL,
      1.679999,
      NULL,
      3,
      7,
      2,
      NULL,
      1,
      3.208509,
      NULL,
      1.509704,
      3,
      1,
      3,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      5,
      0.522309,
      1,
      0.592102,
      2,
      NULL,
      1.253022,
      0.193116,
      0.373338,
      1,
      1.499363,
      3.017567,
      NULL,
      NULL,
      0.912890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.922127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522557,
      NULL,
      NULL,
      0.799791,
      NULL,
      NULL,
      0.663326,
      1.741429,
      1.520407,
      1,
      1,
      2.040575,
      3,
      NULL,
      NULL,
      4,
      4.863203,
      NULL,
      NULL,
      0.366327,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.273503,
      1,
      NULL,
      NULL,
      0.281050,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931731,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.792372,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.145052,
      NULL,
      NULL,
      2.476301,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.282985,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.574997,
      123.954707,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1322.250833,
      40,
      0,
      0.312418,
      0.017327,
      1.736217,
      NULL,
      0,
      0.029816,
      1.345233,
      0.170517,
      1.599268,
      0.074209,
      1.131285,
      3,
      3.388728,
      0.166312,
      1.784752,
      2.284792,
      0.125123,
      0.621618,
      NULL,
      0,
      2,
      0.772361,
      0,
      3.867777,
      0,
      0,
      1,
      NULL,
      326.947618,
      2.257932,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017476,
      0.264212,
      NULL,
      0.438021,
      0,
      1.829387,
      1,
      1,
      1,
      0.574151,
      1.314528,
      1,
      0,
      0,
      2,
      2.406244,
      NULL,
      0.092032,
      1,
      0,
      1,
      0.074528,
      1.971809,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.496395,
      1.804921,
      0.785818,
      NULL,
      NULL,
      NULL,
      3.971163,
      NULL,
      NULL,
      NULL,
      8.016684,
      NULL,
      2,
      NULL,
      1.047749,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.007366,
      NULL,
      1.085211,
      NULL,
      1,
      NULL,
      7,
      NULL,
      1.997983,
      NULL,
      0.047474,
      NULL,
      NULL,
      1.957520,
      NULL,
      NULL,
      NULL,
      NULL,
      3.547976,
      NULL,
      171.032177,
      NULL,
      12.615632,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      1.285813,
      NULL,
      NULL,
      3.636415,
      NULL,
      3.651696,
      NULL,
      63.899076,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1.536896,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.457055,
      NULL,
      0,
      NULL,
      1,
      NULL,
      10.743697,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.535807,
      NULL,
      1191.478712,
      NULL,
      39.720016,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      16.062889,
      NULL,
      0.688245,
      NULL,
      NULL,
      6,
      0,
      NULL,
      0,
      1.327716,
      NULL,
      1.942862,
      NULL,
      0,
      7.903715,
      0.729671,
      2.113518,
      1,
      1,
      3.849362,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706901,
      1.977868,
      3,
      0,
      0,
      NULL,
      2,
      NULL,
      3.876927,
      0,
      1.673898,
      0.554391,
      3.047762,
      1,
      3.006222,
      1,
      0.154240,
      NULL,
      0.572799,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.761830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764435,
      0.130299,
      3.082380,
      NULL,
      0.470685,
      NULL,
      1.640175,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.634223,
      NULL,
      1.372183,
      NULL,
      2.475975,
      NULL,
      3,
      NULL,
      3.490586,
      NULL,
      0,
      NULL,
      1.283267,
      NULL,
      1,
      10,
      1.676384,
      NULL,
      0.911257,
      0.502646,
      0.545305,
      NULL,
      NULL,
      1.119022,
      4,
      0,
      6,
      1,
      2.963088,
      2.297995,
      101,
      52,
      NULL,
      1.268158,
      6,
      NULL,
      '13032',
      '01320',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


