set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '0434412',
      0.659664,
      1,
      1,
      0,
      NULL,
      NULL,
      1.776177,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      4,
      3.082792,
      0.745415,
      ' 0- 3-1978',
      4,
      NULL,
      45.152526,
      11.973815,
      0,
      ' 1-29-2002',
      ' 4-12-1994',
      '11-10-1992',
      NULL,
      NULL,
      0,
      1.123842,
      1,
      1.887000,
      7,
      1.954661,
      0.508168,
      5.605350,
      3,
      12.103345,
      NULL,
      NULL,
      7.622535,
      0,
      11.743826,
      0,
      NULL,
      1,
      0,
      3,
      0,
      1,
      1,
      0.561410,
      1.575211,
      0.799459,
      1.751148,
      0.088260,
      0,
      0,
      1,
      0,
      3,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      5.181777,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2.879049,
      3,
      0,
      1,
      0,
      NULL,
      2.779409,
      0.777264,
      NULL,
      0,
      1,
      3,
      1,
      0,
      0.488089,
      1,
      NULL,
      NULL,
      0,
      1,
      7.233739,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1.863096,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.535489,
      0,
      1,
      0,
      NULL,
      0,
      0,
      3,
      5,
      5,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      5,
      1,
      0,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      5,
      ' 1- 7-1974',
      25.901063,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3.972807,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      1.762335,
      3,
      0.885190,
      1.763084,
      2.859142,
      0,
      1,
      1.898016,
      3,
      NULL,
      4.953796,
      0,
      NULL,
      3.370756,
      NULL,
      NULL,
      NULL,
      0,
      6.451840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.006622,
      0.423892,
      1.113151,
      1,
      0.311891,
      1.624500,
      NULL,
      2,
      NULL,
      3.553986,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      1.400522,
      NULL,
      0.754283,
      1.308798,
      1,
      0,
      0.864006,
      1.067264,
      NULL,
      1.287997,
      1.603713,
      NULL,
      0,
      3.648300,
      0,
      7,
      4,
      7.158836,
      7,
      6.986162,
      7.650906,
      3.657321,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2.591595,
      NULL,
      5,
      25,
      26.499040,
      1,
      1,
      1,
      '01304',
      '00011',
      '',
      0,
      '',
      '',
      NULL,
      1.197631,
      '',
      '',
      '',
      2.046167,
      20.213994,
      7.606506,
      0.522017,
      2,
      7.839142,
      1,
      2,
      4,
      1,
      0.947601,
      1.526019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627726,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.012113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      9.572039,
      5,
      0,
      1.882019,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.680037,
      2,
      2.651293,
      0,
      NULL,
      NULL,
      0.126640,
      0,
      1,
      NULL,
      0,
      0,
      0,
      2,
      1,
      3,
      2,
      NULL,
      0,
      NULL,
      0.935473,
      NULL,
      1.060379,
      0,
      0,
      0,
      NULL,
      NULL,
      0.999637,
      0.733962,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.562052,
      0,
      0.074588,
      0,
      NULL,
      NULL,
      3.792171,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.726563,
      NULL,
      NULL,
      0.373727,
      NULL,
      NULL,
      3,
      1.599520,
      NULL,
      1.742184,
      NULL,
      NULL,
      2.057694,
      NULL,
      NULL,
      0,
      5,
      3.062695,
      0,
      NULL,
      NULL,
      1.512209,
      3.399820,
      0,
      2.134429,
      0,
      2.230494,
      0,
      1,
      0.709652,
      7,
      1.486677,
      2,
      3,
      NULL,
      0,
      0,
      2,
      NULL,
      3,
      1,
      1.812112,
      2,
      2.456726,
      2.910995,
      8.501058,
      1.024504,
      NULL,
      1,
      0.475535,
      1,
      1.692540,
      2,
      4,
      NULL,
      0.868259,
      0.538765,
      1.593917,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704143,
      NULL,
      NULL,
      0.805500,
      NULL,
      NULL,
      1.483703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503020,
      NULL,
      NULL,
      1.460193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.450000,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.594173,
      1,
      2.558552,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      17,
      NULL,
      NULL,
      1.531830,
      3,
      NULL,
      NULL,
      2.064373,
      0.965848,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.883909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.524633,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.411917,
      NULL,
      NULL,
      NULL,
      3.031497,
      NULL,
      NULL,
      0,
      1.918728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460553,
      NULL,
      NULL,
      NULL,
      1.573868,
      1.544192,
      NULL,
      NULL,
      NULL,
      0.222645,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.949764,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.968284,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.040700,
      NULL,
      0.740936,
      560.933381,
      NULL,
      1,
      0.772342,
      0,
      1.489618,
      0.012712,
      0,
      0,
      NULL,
      1,
      1.801562,
      0,
      2,
      0.760005,
      NULL,
      0,
      1,
      1.923543,
      2,
      NULL,
      0.688364,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.747421,
      NULL,
      3,
      NULL,
      138.689703,
      NULL,
      2.272461,
      30.108389,
      0.214563,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.748161,
      NULL,
      2.506664,
      NULL,
      0.313799,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.656776,
      NULL,
      2,
      NULL,
      1.573610,
      NULL,
      1.620506,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.653125,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847987,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056447,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014220,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382472,
      3,
      NULL,
      1,
      NULL,
      1.317167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070805,
      NULL,
      0,
      1,
      1.414619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      2,
      NULL,
      3,
      3,
      0,
      3,
      1,
      3.775377,
      NULL,
      0.486615,
      1,
      1,
      0.707246,
      NULL,
      1.955618,
      1,
      1.153139,
      NULL,
      0.177995,
      0.969635,
      1,
      NULL,
      1,
      1.082629,
      NULL,
      2,
      1.173742,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      3.799000,
      1.669181,
      1.239916,
      NULL,
      NULL,
      0.495669,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223365,
      1.634481,
      0.146833,
      1.756603,
      0,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      0,
      2,
      '01123',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.661653,
      NULL,
      '',
      '');
commit;
end;
/


