set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8603761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3321003',
      1,
      1,
      3,
      3,
      '2201',
      1.583859,
      1.134411,
      NULL,
      NULL,
      NULL,
      6.856679,
      NULL,
      0,
      NULL,
      1,
      ' 3-14-1992',
      39,
      0,
      192,
      47,
      NULL,
      ' 6- 7-1981',
      '10-26-1985',
      ' 9- 7-2000',
      2.516898,
      1.978308,
      NULL,
      3,
      1,
      1.104200,
      NULL,
      1.730089,
      1,
      34.768598,
      5,
      5,
      NULL,
      136.339917,
      143,
      NULL,
      1.826879,
      0,
      2,
      2.686569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4,
      0.563526,
      1,
      NULL,
      0,
      1,
      3,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      7.699814,
      1,
      0,
      0,
      1,
      1.040623,
      NULL,
      NULL,
      1.594658,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1.062465,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      2,
      1,
      0,
      5,
      3,
      NULL,
      0,
      1.725151,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.460229,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      4,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      0,
      1,
      NULL,
      1,
      2,
      ' 3-27-1985',
      103.809652,
      ' 8- 9-1997',
      477.501847,
      3.315696,
      1,
      0,
      1,
      3,
      NULL,
      1,
      1,
      3,
      1,
      2,
      3,
      4,
      5,
      3,
      NULL,
      0,
      1.159081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.644144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.798398,
      0.327452,
      3,
      NULL,
      NULL,
      0.449447,
      19.990134,
      3.800716,
      0.696294,
      NULL,
      NULL,
      NULL,
      1,
      0.219156,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      1.465004,
      NULL,
      0,
      1.662537,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.323438,
      1,
      NULL,
      1.939022,
      NULL,
      10.365715,
      9,
      7.700171,
      1.663837,
      9.565816,
      2,
      5,
      3.514644,
      NULL,
      1,
      2.055775,
      3,
      7,
      NULL,
      NULL,
      NULL,
      14,
      10,
      36.562079,
      1,
      0,
      1,
      '41040',
      '',
      '',
      1.674642,
      NULL,
      '',
      '',
      0.659618,
      '',
      '',
      '',
      3,
      5.720458,
      290,
      NULL,
      0,
      25,
      3.202387,
      4,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.468287,
      1.016132,
      NULL,
      2.068903,
      3.396279,
      1.498715,
      0.111037,
      0.365306,
      0.495311,
      0.721537,
      NULL,
      1,
      3,
      1,
      0,
      2.618624,
      2,
      1,
      3.488850,
      NULL,
      1.107261,
      2,
      2,
      NULL,
      0.059474,
      NULL,
      NULL,
      1,
      3.195161,
      NULL,
      6,
      NULL,
      4,
      1,
      1.809966,
      NULL,
      NULL,
      NULL,
      0.849802,
      NULL,
      NULL,
      NULL,
      3,
      3.697677,
      3,
      NULL,
      3,
      1.425276,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601544,
      NULL,
      2,
      1.798186,
      3.982649,
      2,
      3.572377,
      NULL,
      0,
      3,
      1.979858,
      NULL,
      0.044477,
      NULL,
      0.097059,
      1,
      2.701439,
      0.159263,
      0.338677,
      NULL,
      NULL,
      2.293146,
      3.390570,
      0,
      4.162806,
      7,
      3.605971,
      1,
      0.368676,
      NULL,
      NULL,
      NULL,
      0.903115,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      7,
      3.949955,
      0.292129,
      1,
      0.962770,
      NULL,
      2,
      0.261989,
      0.844998,
      5.498817,
      9.675283,
      2.967965,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.676966,
      NULL,
      NULL,
      1.668156,
      NULL,
      NULL,
      1.550877,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.154105,
      NULL,
      3.033125,
      2,
      0,
      0,
      6.863415,
      6.399374,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.923670,
      1.355681,
      3.205089,
      1,
      3.435809,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0.751504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      4.312910,
      2.710586,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.758655,
      0.807829,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.170942,
      NULL,
      NULL,
      7.462445,
      NULL,
      NULL,
      0.040222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.791901,
      NULL,
      NULL,
      1.119588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.050213,
      NULL,
      NULL,
      1.360480,
      NULL,
      NULL,
      3.852153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098937,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      0.918530,
      0.296579,
      0,
      1,
      1.439660,
      NULL,
      NULL,
      0.462534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751293,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      86,
      NULL,
      17,
      3.114188,
      0.762967,
      NULL,
      NULL,
      1,
      101.942728,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.093538,
      1,
      NULL,
      NULL,
      1508,
      NULL,
      3,
      1,
      0,
      NULL,
      0.083766,
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      1.189998,
      1.078344,
      1,
      1,
      0.287982,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071111,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670358,
      NULL,
      NULL,
      0,
      NULL,
      0.399137,
      NULL,
      NULL,
      1,
      0.916844,
      NULL,
      1,
      0.728016,
      NULL,
      1.421508,
      0,
      NULL,
      1.902415,
      0.890622,
      NULL,
      0,
      NULL,
      NULL,
      1.270995,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.173307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604485,
      NULL,
      0.670788,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.189738,
      0.017465,
      0,
      8.367708,
      NULL,
      0,
      1,
      1,
      NULL,
      '',
      NULL,
      1.073795,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


