set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8622293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.397844,
      1,
      3,
      NULL,
      2,
      1.878876,
      NULL,
      NULL,
      ' 7- 4-1986',
      NULL,
      NULL,
      NULL,
      3.882679,
      NULL,
      '10- 7-1997',
      25.907677,
      2.918838,
      320.617506,
      63,
      1,
      ' 7- 8-1988',
      ' 4-10-1980',
      NULL,
      0.482524,
      NULL,
      2,
      0.970497,
      NULL,
      3,
      0,
      0.529682,
      0,
      87,
      2,
      4.434569,
      6,
      188.863389,
      4,
      NULL,
      NULL,
      5,
      3,
      1.433411,
      0.576599,
      NULL,
      0,
      1.739206,
      NULL,
      NULL,
      1,
      1.954306,
      1,
      0,
      1.403841,
      2,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      4,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      4.438964,
      3.309848,
      1,
      1,
      3.607006,
      2.617021,
      0.373628,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      3.123380,
      1,
      3.414031,
      NULL,
      0,
      1,
      0,
      6.356774,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.497685,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      3,
      5,
      1,
      1,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.333117,
      NULL,
      1.232826,
      3,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      5,
      3,
      0,
      2,
      5,
      2,
      1,
      4,
      4,
      5,
      NULL,
      1,
      NULL,
      0,
      5,
      4,
      2,
      3.932341,
      2.067661,
      ' 0-22-1977',
      142.849398,
      ' 3-13-1982',
      7,
      1.132730,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.858262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.101403,
      2,
      NULL,
      NULL,
      5,
      0.440422,
      0,
      1.772507,
      1,
      5.881918,
      1.194991,
      0.168597,
      NULL,
      NULL,
      0.081516,
      9,
      1.818789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.047958,
      0.320670,
      111.958542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.933649,
      0,
      1,
      1,
      2,
      3,
      1,
      1,
      2,
      2,
      0,
      0,
      1,
      3,
      3,
      3.637938,
      0.809838,
      0,
      7,
      0,
      1.960312,
      0.821861,
      0,
      NULL,
      0,
      NULL,
      1.232972,
      1,
      0,
      2.805204,
      0,
      NULL,
      8,
      6,
      2,
      6,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      23.972162,
      3,
      0,
      NULL,
      1,
      37,
      14,
      4,
      0,
      0.327738,
      '31011',
      '20420',
      '',
      0.152823,
      '33323',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      14,
      4.687018,
      30,
      NULL,
      NULL,
      10,
      7.964825,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.956153,
      0,
      1.422514,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.727226,
      3.174731,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.830284,
      NULL,
      NULL,
      5,
      8,
      10,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.890826,
      0,
      1.247906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824031,
      NULL,
      0.786102,
      NULL,
      NULL,
      1,
      NULL,
      1.344387,
      0,
      1.318327,
      3,
      0.270355,
      0.471162,
      3,
      1,
      3.151720,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.686796,
      NULL,
      0.220597,
      4,
      0,
      8,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.761724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.971068,
      NULL,
      0.551600,
      0.498767,
      0.663205,
      1.480052,
      NULL,
      NULL,
      4,
      5,
      2,
      NULL,
      2,
      1,
      1.685823,
      NULL,
      NULL,
      1,
      5.209223,
      0.339428,
      0.530752,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.864197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386569,
      2.566673,
      1,
      0.568949,
      6,
      8.221697,
      NULL,
      4.945310,
      1,
      NULL,
      3.154719,
      3.211145,
      1.010085,
      0,
      NULL,
      NULL,
      3.508534,
      0,
      NULL,
      2.427257,
      3,
      0.504185,
      0.288254,
      4.318869,
      7.667279,
      2,
      NULL,
      2.523727,
      2.725951,
      0,
      1.626735,
      0,
      0.707163,
      0.523294,
      1,
      1.937825,
      1,
      11,
      10.681722,
      8,
      0,
      6.875362,
      2.325302,
      3.136288,
      1,
      1,
      NULL,
      1.784645,
      1,
      0,
      1.057356,
      3.754343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.693472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.860653,
      NULL,
      NULL,
      0.767730,
      NULL,
      NULL,
      0.876859,
      NULL,
      NULL,
      1,
      1.627321,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.613217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.031235,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.676485,
      NULL,
      NULL,
      NULL,
      2.417045,
      NULL,
      NULL,
      NULL,
      0.351797,
      NULL,
      NULL,
      NULL,
      3.343970,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.258454,
      73,
      59,
      1.611997,
      11.808249,
      2.156611,
      NULL,
      NULL,
      NULL,
      0.264807,
      1,
      1.408904,
      1,
      0.711379,
      2.564506,
      NULL,
      11,
      0,
      1.997593,
      NULL,
      1,
      300,
      4.197636,
      NULL,
      0.154756,
      1,
      1.183748,
      1,
      0.575729,
      0.859108,
      NULL,
      0,
      0.366566,
      0.784363,
      NULL,
      1,
      1,
      0.996644,
      1.560842,
      0.905658,
      1,
      NULL,
      2.910968,
      NULL,
      NULL,
      NULL,
      0.222476,
      NULL,
      2.686294,
      NULL,
      0.385557,
      NULL,
      21.772034,
      NULL,
      3,
      7,
      13.764548,
      1.231551,
      1,
      NULL,
      NULL,
      1.456454,
      NULL,
      1.421388,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.061340,
      NULL,
      NULL,
      NULL,
      3.066573,
      NULL,
      1.274569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132947,
      NULL,
      0,
      NULL,
      0.771392,
      NULL,
      1,
      3,
      0.989968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190485,
      0.152817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.269656,
      NULL,
      0.572696,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.640829,
      NULL,
      1,
      NULL,
      0,
      1.799705,
      3.417423,
      NULL,
      0,
      NULL,
      0.684159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447758,
      NULL,
      1,
      NULL,
      0.574270,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934567,
      NULL,
      1.429350,
      NULL,
      0.411547,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.370583,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.849194,
      NULL,
      1,
      0.719503,
      NULL,
      15,
      4.553581,
      1.751445,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      6,
      1,
      2,
      NULL,
      2,
      11,
      2.113244,
      2.463082,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.116801,
      NULL,
      1.638127,
      0.108284,
      NULL,
      0.391705,
      0,
      NULL,
      1.693300,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.486070,
      NULL,
      0,
      NULL,
      NULL,
      1.652209,
      0.176801,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704506,
      NULL,
      0.789263,
      NULL,
      NULL,
      NULL,
      1,
      6,
      2,
      0,
      0,
      3.217836,
      NULL,
      NULL,
      5,
      1,
      4,
      '14344',
      '00442',
      '',
      NULL,
      '24302',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


