set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2223102',
      1.910183,
      0,
      2,
      2,
      '4203',
      3,
      2.518524,
      3,
      59,
      ' 7-27-1989',
      113.930873,
      NULL,
      0,
      NULL,
      0.341863,
      '10-29-1994',
      37.113460,
      5.935025,
      145.003076,
      114,
      1,
      NULL,
      NULL,
      ' 1-11-1996',
      1.776512,
      0,
      NULL,
      3,
      2.951949,
      2,
      0,
      0.982449,
      0,
      1131,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3,
      15,
      NULL,
      5,
      0,
      1,
      1,
      1,
      1,
      1,
      0.917318,
      NULL,
      0.698071,
      NULL,
      NULL,
      3.019571,
      7,
      NULL,
      2,
      3.045849,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.892100,
      0,
      0.064071,
      0.655405,
      3.289233,
      2.114716,
      0.761870,
      1.244298,
      1.863806,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.849286,
      0,
      0,
      1.978587,
      1,
      NULL,
      NULL,
      1.569851,
      NULL,
      NULL,
      0,
      2,
      5,
      2,
      4,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      1,
      0,
      1.471878,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      0,
      4,
      1,
      2,
      NULL,
      0,
      1,
      3,
      4,
      4,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      8.452962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.515284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477488,
      1.449483,
      0.521352,
      0.428338,
      0.960594,
      0,
      NULL,
      NULL,
      NULL,
      1.272731,
      0.807537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994319,
      1.165261,
      0,
      1.570123,
      1.880183,
      0.915473,
      3.456795,
      752,
      2.313219,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.704413,
      2,
      3,
      2,
      2,
      2,
      2,
      0,
      3,
      2,
      0,
      3,
      0.625036,
      7.637060,
      2.052141,
      1.507538,
      2,
      7,
      1.849363,
      2.580711,
      1,
      0.911276,
      0,
      0,
      1,
      0.539294,
      3,
      NULL,
      7,
      1,
      1,
      2,
      3.601527,
      1.129265,
      NULL,
      0.930927,
      NULL,
      1,
      4,
      NULL,
      2.479136,
      NULL,
      7,
      0,
      1.386939,
      49,
      NULL,
      NULL,
      NULL,
      1,
      0.684143,
      2,
      '42234',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      '3422',
      NULL,
      '',
      0,
      48,
      751.871396,
      30.494157,
      0.115129,
      52.374700,
      NULL,
      838.214474,
      NULL,
      1,
      0,
      NULL,
      0.447293,
      NULL,
      NULL,
      0,
      3.395216,
      1,
      0.163915,
      1,
      0,
      0.520596,
      NULL,
      NULL,
      NULL,
      0.541159,
      1.576043,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.824138,
      7.395173,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.328596,
      NULL,
      NULL,
      NULL,
      3.993894,
      NULL,
      NULL,
      3.111526,
      3,
      1.013136,
      1,
      1,
      0,
      3.624752,
      1,
      1,
      3.383084,
      NULL,
      2.381936,
      2.614964,
      1,
      1,
      NULL,
      NULL,
      1.314752,
      0.633880,
      1.797272,
      1.866843,
      0.614650,
      1.690094,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.084977,
      3,
      1,
      8,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.922955,
      4.851634,
      1.956195,
      NULL,
      NULL,
      0.822408,
      0,
      NULL,
      NULL,
      1.461892,
      7.300190,
      1,
      0.729130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898804,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.323613,
      NULL,
      NULL,
      0.020225,
      NULL,
      1.719094,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031155,
      1.965086,
      11,
      4,
      3,
      NULL,
      1.740927,
      0.684586,
      0,
      NULL,
      NULL,
      1,
      0,
      3.610554,
      2,
      3.256249,
      NULL,
      4.884595,
      3,
      5,
      1,
      NULL,
      0,
      0,
      0,
      2,
      3.097503,
      NULL,
      1.436156,
      3,
      3,
      2,
      1.495618,
      NULL,
      0,
      7,
      1.702251,
      1.782526,
      0.407924,
      1,
      3,
      1.852470,
      NULL,
      0,
      0.462217,
      0.857214,
      0.615827,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.103116,
      1,
      0.163379,
      0,
      3.486907,
      NULL,
      NULL,
      NULL,
      0.353040,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591939,
      0.507141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.675697,
      NULL,
      NULL,
      NULL,
      17.023251,
      0,
      NULL,
      NULL,
      10.173329,
      8,
      NULL,
      NULL,
      NULL,
      0.976013,
      NULL,
      NULL,
      1.937133,
      3.353823,
      NULL,
      NULL,
      2.686309,
      0.847301,
      NULL,
      NULL,
      5.743613,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.495004,
      197,
      32.306515,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      30,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.606281,
      0.079263,
      1.202942,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0.474170,
      1,
      1.364701,
      1,
      0.434162,
      1,
      0,
      NULL,
      1.434350,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.467345,
      3.887293,
      2,
      NULL,
      1,
      1.690422,
      3,
      1,
      NULL,
      12,
      NULL,
      5.780447,
      3,
      1,
      13.112328,
      1.342022,
      NULL,
      0.634726,
      12,
      12,
      NULL,
      2.531467,
      2.528915,
      0.876735,
      1.502808,
      3,
      1,
      1,
      3,
      2,
      0,
      0,
      2,
      2,
      2.062320,
      0.896933,
      1,
      NULL,
      3.133432,
      1,
      NULL,
      1,
      3,
      1.465076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.987139,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      6,
      NULL,
      NULL,
      3,
      NULL,
      5.522130,
      0,
      1,
      2,
      '34410',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '2113',
      '1130',
      '0340');
commit;
end;
/


