set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0.987145,
      NULL,
      NULL,
      '11- 1-1988',
      47.087644,
      NULL,
      2,
      1.767295,
      1.640425,
      ' 4- 7-1975',
      18.906610,
      3,
      296.412779,
      60,
      0,
      NULL,
      ' 6-28-1977',
      '10-16-1986',
      2,
      0.861184,
      1.003008,
      1,
      0.041272,
      1,
      NULL,
      0.562383,
      NULL,
      NULL,
      NULL,
      6,
      5.449027,
      3.818428,
      NULL,
      NULL,
      2,
      0,
      1,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      1,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3.631819,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      2,
      0,
      NULL,
      0.689726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      4,
      2,
      3,
      1,
      1,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0.927575,
      NULL,
      0,
      1,
      0,
      2,
      1,
      3,
      NULL,
      3,
      3,
      5,
      1,
      NULL,
      0,
      1,
      4,
      5,
      5,
      2,
      2,
      4,
      4,
      NULL,
      NULL,
      3,
      2.588117,
      1,
      '11- 6-1981',
      NULL,
      ' 4-27-1975',
      7,
      0,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0.312059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      20.152151,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      3.272587,
      3,
      7.045784,
      3.307409,
      7.002556,
      0,
      6.445351,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.836168,
      2,
      2,
      NULL,
      NULL,
      1.010367,
      NULL,
      NULL,
      ' 6-14-1983',
      1.640494,
      1.668802,
      NULL,
      1.605883,
      1.896049,
      1,
      1.992558,
      1.562635,
      NULL,
      NULL,
      1,
      0,
      76.488314,
      1,
      0.397383,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      NULL,
      NULL,
      0.861948,
      1,
      4,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.183672,
      1,
      2.584589,
      2,
      1.162862,
      NULL,
      5,
      NULL,
      1,
      0.429321,
      2,
      2.975347,
      3,
      1.249352,
      1.659067,
      0,
      2,
      20.392386,
      NULL,
      3,
      NULL,
      NULL,
      63,
      0,
      NULL,
      1,
      3.422373,
      '40142',
      '',
      '',
      2.781021,
      '23144',
      '42312',
      '',
      NULL,
      '22204',
      '41232',
      '',
      0,
      44.715118,
      17.188692,
      10,
      NULL,
      NULL,
      NULL,
      1.879187,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.196861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.711422,
      0.199336,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.390090,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.149546,
      1.753450,
      NULL,
      1,
      0.373618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590652,
      NULL,
      NULL,
      0.403799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074502,
      NULL,
      NULL,
      0.454109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196472,
      NULL,
      NULL,
      2.632618,
      0.038397,
      0,
      1.776991,
      NULL,
      NULL,
      4,
      2.073451,
      3,
      0.685541,
      NULL,
      NULL,
      1.678015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.001435,
      NULL,
      NULL,
      0.570964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.881309,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0.664736,
      NULL,
      NULL,
      2,
      1.009675,
      0.223291,
      1,
      NULL,
      0.815015,
      NULL,
      2.831131,
      0.541194,
      5.286445,
      NULL,
      0.962100,
      1,
      0.095090,
      0,
      1.705072,
      0.792206,
      NULL,
      3.366177,
      1,
      1,
      NULL,
      3,
      2,
      8,
      9.335283,
      NULL,
      5,
      2.805885,
      NULL,
      3.114756,
      NULL,
      0,
      1.402399,
      1.542208,
      1.978727,
      0.815190,
      1,
      1.896688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.154666,
      3,
      0.301751,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.361952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720600,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637750,
      NULL,
      NULL,
      NULL,
      2.246822,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.331444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.819741,
      NULL,
      NULL,
      NULL,
      2.314396,
      1,
      NULL,
      3.230306,
      27.101446,
      NULL,
      1.980529,
      NULL,
      NULL,
      2.217576,
      2.658652,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.740115,
      NULL,
      1,
      8.871223,
      0,
      1,
      0.247139,
      NULL,
      0,
      1.936866,
      1.541884,
      0.052834,
      0.986130,
      1.572026,
      NULL,
      0.371543,
      1,
      1,
      NULL,
      0.100701,
      1,
      1.569958,
      0.907392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      1,
      NULL,
      3.471659,
      1,
      9,
      1,
      0.086308,
      3,
      NULL,
      0,
      0,
      1.944564,
      1.064334,
      0.558597,
      0,
      1.293753,
      1.906854,
      1.862054,
      NULL,
      0,
      2,
      2,
      1.838905,
      2,
      2.224461,
      0,
      0,
      0.202866,
      0,
      1,
      NULL,
      2.987085,
      0,
      NULL,
      0,
      1,
      2.687639,
      2.804920,
      1,
      1.677476,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696579,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.463248,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2.066854,
      NULL,
      0,
      NULL,
      0.474799,
      NULL,
      1.111088,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      16.310652,
      NULL,
      NULL,
      0,
      NULL,
      0.977051,
      NULL,
      NULL,
      1,
      3,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.787477,
      NULL,
      '',
      NULL,
      2.857567,
      '12101',
      '20343',
      '',
      4.506041,
      '34234',
      '44003',
      '');
commit;
end;
/


