set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4124131',
      3,
      NULL,
      NULL,
      0,
      '4420',
      3.874868,
      0,
      NULL,
      NULL,
      ' 3-19-1979',
      18,
      NULL,
      1,
      NULL,
      3,
      ' 2-27-1992',
      0,
      2,
      285.880995,
      45.612055,
      3,
      ' 8-19-1995',
      '10-28-1995',
      ' 4-14-1982',
      1.027789,
      1,
      1,
      NULL,
      NULL,
      1.152151,
      3,
      0.522294,
      NULL,
      NULL,
      NULL,
      8,
      1.265500,
      3,
      33,
      0,
      11.216777,
      1,
      0,
      3,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0.235606,
      0,
      2,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.406452,
      NULL,
      2,
      NULL,
      0,
      0.000695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3.603178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1.315842,
      2,
      3,
      0,
      5,
      3,
      NULL,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      3,
      2,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      4,
      0,
      NULL,
      3,
      ' 5-14-1989',
      NULL,
      NULL,
      15,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      3,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8.562312,
      1.198770,
      NULL,
      NULL,
      0.679737,
      0.204744,
      3.018064,
      0,
      1430,
      0,
      0,
      NULL,
      1.459892,
      1,
      NULL,
      10.315982,
      0,
      NULL,
      0,
      6,
      1,
      4.994296,
      0,
      NULL,
      NULL,
      2.392968,
      NULL,
      1.202219,
      2,
      0,
      3,
      9,
      ' 3- 5-1980',
      NULL,
      ' 3-11-1998',
      153,
      1.524682,
      2,
      0.438468,
      3,
      3,
      NULL,
      0.648050,
      NULL,
      1.860211,
      0.919898,
      NULL,
      146.974436,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      1.580418,
      1.965172,
      3.114997,
      0,
      0.139477,
      1.306077,
      1.546102,
      NULL,
      0,
      1.875970,
      NULL,
      1,
      1,
      1.827869,
      1,
      NULL,
      2,
      NULL,
      2.416232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594657,
      NULL,
      13,
      13,
      52,
      5,
      NULL,
      2.407294,
      '42421',
      '',
      NULL,
      4.265428,
      '02001',
      '21342',
      '',
      NULL,
      NULL,
      '',
      '',
      3.024317,
      3.789732,
      NULL,
      27.366974,
      2,
      NULL,
      3,
      0.280458,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.980339,
      NULL,
      NULL,
      1.468691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.116261,
      NULL,
      NULL,
      0.143946,
      NULL,
      NULL,
      0.082738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.341706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118394,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365458,
      NULL,
      NULL,
      0.887855,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.050567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.245546,
      NULL,
      NULL,
      0.098287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728859,
      NULL,
      NULL,
      1.425838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.351436,
      2.753317,
      0.182412,
      NULL,
      NULL,
      0.113104,
      6,
      5,
      0,
      5,
      2,
      1.450393,
      NULL,
      NULL,
      1.382143,
      NULL,
      NULL,
      3,
      1.787411,
      0,
      2,
      3,
      0.048341,
      NULL,
      2,
      1.043055,
      1.807418,
      2,
      0,
      3,
      1,
      0.477247,
      3.830369,
      3,
      0,
      2.794746,
      2,
      1,
      5,
      8,
      NULL,
      5.128050,
      1.364459,
      0,
      0,
      NULL,
      NULL,
      1.780787,
      0.569937,
      1.243491,
      1.736529,
      0.950241,
      1.646644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.899653,
      NULL,
      NULL,
      NULL,
      85.202992,
      NULL,
      NULL,
      NULL,
      2.913978,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.677129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.447267,
      NULL,
      NULL,
      NULL,
      1.420188,
      NULL,
      NULL,
      NULL,
      1.587343,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.759782,
      NULL,
      NULL,
      NULL,
      0.315257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.676760,
      NULL,
      NULL,
      NULL,
      6.795292,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      13.712334,
      NULL,
      1.771183,
      NULL,
      NULL,
      2,
      10,
      NULL,
      3,
      1.128968,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      7401,
      1,
      0,
      0.850401,
      0,
      NULL,
      0.395362,
      0.421186,
      1,
      0.441695,
      0,
      NULL,
      1.109261,
      1.946578,
      0,
      0,
      0,
      0,
      0,
      1.626666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      2,
      0,
      3,
      NULL,
      2,
      9.453778,
      3.971664,
      0.046472,
      0.878538,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.616361,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.203667,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.827818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.144923,
      0,
      NULL,
      0.672546,
      NULL,
      0.899625,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.218548,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.823967,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.044555,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.557316,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      103,
      NULL,
      0,
      1,
      1.831436,
      '02100',
      '',
      '',
      0.245233,
      '44312',
      '13200',
      '',
      3.267297,
      NULL,
      '30244',
      '');
commit;
end;
/


