set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      '4213',
      3,
      1,
      NULL,
      NULL,
      '10- 6-1999',
      51.230016,
      NULL,
      2,
      2,
      3.973081,
      ' 0-20-1996',
      32,
      0.391543,
      167,
      66,
      3,
      ' 4-19-1988',
      ' 3-29-2001',
      ' 4-18-1981',
      2,
      0.088861,
      3.158213,
      NULL,
      0,
      2.375305,
      0,
      0,
      NULL,
      NULL,
      NULL,
      11.858056,
      5,
      5,
      NULL,
      4,
      NULL,
      5,
      2,
      7.308884,
      1.494632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      5,
      NULL,
      5,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      7.967118,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      0,
      0,
      0.465249,
      1.316933,
      0.012020,
      NULL,
      NULL,
      NULL,
      0.086993,
      1,
      0.040300,
      NULL,
      NULL,
      1.883808,
      0,
      1,
      1,
      0.155303,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3,
      1.624148,
      NULL,
      NULL,
      1.204377,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      4,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0,
      6,
      2,
      0,
      0,
      1,
      1,
      NULL,
      0.542260,
      2,
      3,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      4,
      3.996436,
      ' 1-23-1977',
      43.838387,
      ' 7-11-1987',
      21,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1.248467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.958909,
      0.105242,
      0,
      0.454195,
      1.969099,
      3,
      3,
      4.313502,
      1,
      NULL,
      NULL,
      0,
      0.784344,
      3,
      1,
      2.052019,
      2.119117,
      NULL,
      9.990444,
      0.221459,
      1,
      NULL,
      NULL,
      NULL,
      0.258445,
      1.064818,
      1.455568,
      1,
      NULL,
      2,
      3.068118,
      ' 6-15-1996',
      235,
      ' 9-29-1976',
      47.332327,
      1.305454,
      1,
      NULL,
      0.078481,
      1,
      NULL,
      3,
      3,
      1,
      NULL,
      3.324251,
      190.097419,
      3,
      0.757810,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.035505,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      1.852255,
      1,
      0,
      0,
      1,
      0,
      0.318538,
      1,
      1,
      0.484879,
      NULL,
      1.810457,
      0.466408,
      0,
      0.309708,
      0,
      NULL,
      3,
      0.452950,
      9,
      4.483831,
      5.258162,
      1,
      1.177870,
      NULL,
      NULL,
      0.698136,
      4,
      2.119626,
      0.083548,
      2.941670,
      25.653187,
      NULL,
      1,
      NULL,
      NULL,
      4,
      27,
      3,
      0,
      0,
      '43312',
      '',
      '',
      2,
      NULL,
      '03322',
      '',
      1.502498,
      '21203',
      '03033',
      '',
      NULL,
      29,
      NULL,
      38.788780,
      3,
      34,
      1,
      0.727710,
      5,
      NULL,
      1.223768,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.748832,
      NULL,
      NULL,
      2.921809,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776921,
      NULL,
      NULL,
      2,
      0.162448,
      0.842334,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926967,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634180,
      NULL,
      NULL,
      1.399057,
      NULL,
      NULL,
      1.361919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.529759,
      NULL,
      NULL,
      0.268594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.449205,
      NULL,
      NULL,
      1.232928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425032,
      NULL,
      NULL,
      1.903100,
      NULL,
      NULL,
      0.866032,
      NULL,
      NULL,
      2,
      NULL,
      2.453469,
      3,
      1.428627,
      0.238966,
      7.152071,
      3,
      2.911120,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.241077,
      NULL,
      NULL,
      0,
      0.948889,
      1.874962,
      0.024388,
      2.053638,
      NULL,
      0,
      0.688356,
      0.201770,
      0,
      2.331843,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.843379,
      3.290361,
      2.247839,
      4.313672,
      3,
      4,
      5.236847,
      4,
      NULL,
      1.507328,
      NULL,
      NULL,
      0,
      0,
      0.308308,
      0.349855,
      NULL,
      0.119011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.641723,
      9,
      NULL,
      NULL,
      NULL,
      42.330260,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.589927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.492559,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.558624,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.954999,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.504278,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      0.188253,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      3.764294,
      0.301252,
      2.238307,
      0.055936,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      0.105507,
      0.319462,
      NULL,
      NULL,
      0.235129,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.256672,
      1.253806,
      NULL,
      1,
      1,
      0.524322,
      0,
      NULL,
      NULL,
      1.476045,
      0,
      1,
      1.886577,
      1.082891,
      1,
      0,
      1.382041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      4,
      3,
      2.270754,
      2,
      NULL,
      3,
      2,
      0.996008,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.652613,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.543662,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1.646723,
      NULL,
      0.988480,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.557400,
      NULL,
      1.488909,
      NULL,
      1.423156,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.048071,
      NULL,
      1,
      NULL,
      1.269093,
      NULL,
      1.981335,
      NULL,
      1.743923,
      NULL,
      0,
      NULL,
      36,
      0,
      NULL,
      1,
      NULL,
      2.914861,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      19,
      4,
      1.921923,
      NULL,
      '32113',
      '00440',
      '',
      0.358713,
      '21334',
      '32012',
      '',
      4,
      '44300',
      '13314',
      '');
commit;
end;
/


