set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7007504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2041200',
      3,
      NULL,
      0,
      2,
      NULL,
      3,
      1.037101,
      NULL,
      NULL,
      ' 4-20-1986',
      17.433466,
      NULL,
      2,
      1.626098,
      0,
      ' 9-17-1984',
      38,
      0.016710,
      213,
      763.006126,
      1,
      NULL,
      ' 9-18-1990',
      ' 4- 1-1986',
      NULL,
      NULL,
      1,
      1.480698,
      0.659068,
      2,
      2,
      1,
      NULL,
      136,
      1,
      13,
      17.751119,
      119,
      105,
      2,
      NULL,
      3,
      1,
      1,
      0.092488,
      NULL,
      1,
      1,
      1.072935,
      0.155162,
      0,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      5,
      0,
      1,
      1,
      1,
      0,
      5,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.603453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      3,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      4.070168,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.340971,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      2,
      3,
      4,
      1,
      3,
      0,
      1,
      1.461077,
      1.434537,
      ' 4- 9-1993',
      1793,
      ' 7- 0-1983',
      NULL,
      3,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1.066378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.583600,
      NULL,
      0,
      NULL,
      0.226157,
      0.953013,
      0.626937,
      NULL,
      NULL,
      NULL,
      1.383299,
      0,
      0.256579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.002781,
      0.960565,
      0.565432,
      0,
      1,
      NULL,
      21.061116,
      1.060422,
      0.590026,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.741873,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      1.939099,
      199,
      149,
      NULL,
      179,
      55,
      163.346303,
      1,
      1,
      1.003712,
      1.636647,
      1,
      NULL,
      NULL,
      11.895016,
      1.583543,
      1.112988,
      NULL,
      0,
      5,
      0,
      7,
      3.704191,
      4.196081,
      1,
      5,
      NULL,
      1.375301,
      NULL,
      15.348711,
      0,
      3.496625,
      NULL,
      32,
      46,
      3,
      4,
      1,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.378000,
      '',
      NULL,
      '',
      0,
      17,
      NULL,
      27,
      3.033184,
      NULL,
      21,
      4,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.253633,
      2.912415,
      1.975571,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.243184,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.694589,
      NULL,
      NULL,
      7,
      NULL,
      0.031555,
      NULL,
      0.891488,
      NULL,
      NULL,
      NULL,
      0.959317,
      NULL,
      NULL,
      NULL,
      2,
      6.577960,
      14.439251,
      0.064481,
      NULL,
      NULL,
      1.498030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.036958,
      NULL,
      2,
      0,
      1.998314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0.378579,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.851340,
      1,
      2,
      0.118034,
      0,
      NULL,
      NULL,
      4.365965,
      2,
      1,
      1,
      NULL,
      NULL,
      0.977407,
      NULL,
      NULL,
      1.931811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.791932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1.003313,
      NULL,
      NULL,
      0.358857,
      1,
      2.328497,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.300003,
      3,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      8,
      0.323488,
      7.595334,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.590002,
      0,
      1,
      NULL,
      0,
      1.023758,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.110658,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.178896,
      0.676880,
      NULL,
      NULL,
      1.030335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.667800,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384219,
      NULL,
      NULL,
      NULL,
      1,
      123.497000,
      132.684128,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.927574,
      NULL,
      NULL,
      0.618827,
      NULL,
      NULL,
      2.558713,
      1723.587832,
      NULL,
      8925.340514,
      1,
      0.842051,
      NULL,
      1.235164,
      0.279660,
      0.302001,
      NULL,
      0,
      0,
      0.007351,
      1,
      1.181903,
      0,
      NULL,
      1.240225,
      1.514934,
      0,
      NULL,
      1.437373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.766869,
      2,
      1,
      0.476420,
      0.893407,
      NULL,
      0,
      1.021491,
      NULL,
      0.291869,
      0,
      NULL,
      1,
      0.622937,
      NULL,
      3.397758,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.424506,
      1.052267,
      NULL,
      1.959126,
      0,
      NULL,
      0,
      NULL,
      0.781200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.691237,
      NULL,
      1.108824,
      NULL,
      1,
      3,
      2,
      3,
      NULL,
      2,
      71.638875,
      NULL,
      NULL,
      0.758585,
      0,
      '11414',
      '',
      '',
      0.518180,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


