set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2132340',
      NULL,
      1.517700,
      0,
      NULL,
      '4022',
      0.982394,
      1,
      NULL,
      NULL,
      NULL,
      24.767318,
      NULL,
      4,
      1.612230,
      0,
      ' 6-26-1974',
      23.172718,
      0,
      293,
      NULL,
      1,
      ' 2-13-1981',
      ' 8- 7-1994',
      ' 8-11-1994',
      NULL,
      3.312707,
      0.729975,
      NULL,
      0,
      1.889851,
      0,
      2.378478,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      20,
      11,
      3,
      21,
      1,
      3,
      4,
      1,
      1,
      1,
      1.524856,
      NULL,
      NULL,
      1,
      0,
      1.366075,
      NULL,
      1.829721,
      1,
      2,
      0,
      2,
      3,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      4,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.207382,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      5,
      NULL,
      2,
      0,
      5,
      0,
      NULL,
      4,
      5,
      4,
      3,
      1,
      1,
      5,
      NULL,
      0,
      2,
      3,
      4,
      1.694531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.436423,
      NULL,
      1.429738,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.436026,
      0.759158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.423616,
      3.814020,
      6,
      4.304157,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.346674,
      0.027461,
      1.547254,
      NULL,
      3,
      NULL,
      0.950410,
      NULL,
      11.201872,
      3.472720,
      0.627754,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      2,
      3,
      NULL,
      3,
      3,
      0.045458,
      1,
      0,
      1.839204,
      1,
      1.800455,
      1,
      0,
      0.914843,
      0,
      NULL,
      0,
      1,
      0,
      1,
      2.033834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      58,
      NULL,
      3,
      0.289009,
      2,
      NULL,
      '',
      '',
      0.970899,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      37,
      30.888617,
      7,
      2.627159,
      40,
      3.193570,
      3.622656,
      3,
      2,
      0,
      1,
      0.028691,
      NULL,
      NULL,
      0.848211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.933523,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.860529,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.540866,
      NULL,
      NULL,
      1.023455,
      NULL,
      NULL,
      0.324328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.241419,
      6,
      NULL,
      0,
      3.796825,
      0,
      3.486997,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723358,
      NULL,
      NULL,
      1.901802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134557,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      2.360621,
      0.508075,
      1.370650,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      0.737806,
      0.652126,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.721820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.114031,
      NULL,
      NULL,
      0.305793,
      2.159820,
      1,
      0.942822,
      NULL,
      NULL,
      7,
      7.249744,
      1,
      6.033786,
      NULL,
      0.104917,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.508853,
      NULL,
      2,
      1.778203,
      NULL,
      4,
      5.968319,
      1,
      2,
      2.320267,
      1,
      0.837482,
      NULL,
      NULL,
      0.804611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702173,
      3.429937,
      0,
      7.165506,
      6,
      1.677121,
      0,
      1,
      2,
      1.334250,
      0.895932,
      NULL,
      1.505044,
      NULL,
      3,
      NULL,
      2.729320,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.202516,
      NULL,
      NULL,
      0.345045,
      NULL,
      NULL,
      0.092919,
      NULL,
      NULL,
      1.968323,
      1,
      NULL,
      2,
      0,
      NULL,
      2.531263,
      0,
      NULL,
      3.468677,
      NULL,
      NULL,
      NULL,
      1.466755,
      NULL,
      NULL,
      1.829692,
      NULL,
      1.451689,
      1,
      NULL,
      12,
      2,
      NULL,
      3.876980,
      1.678824,
      NULL,
      NULL,
      1.245192,
      0.657157,
      0,
      2.065834,
      NULL,
      NULL,
      5.607258,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.080032,
      NULL,
      NULL,
      NULL,
      0,
      0.385455,
      NULL,
      NULL,
      1.424308,
      NULL,
      NULL,
      NULL,
      0.723656,
      NULL,
      NULL,
      NULL,
      2,
      3.337518,
      NULL,
      NULL,
      1.897227,
      1.625804,
      NULL,
      NULL,
      2,
      1.045764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.447384,
      1,
      NULL,
      NULL,
      0,
      0.155018,
      NULL,
      NULL,
      1.038735,
      0.651055,
      NULL,
      NULL,
      3,
      0.813045,
      NULL,
      NULL,
      NULL,
      0.123739,
      NULL,
      NULL,
      0.722914,
      0.360965,
      NULL,
      NULL,
      0.943221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.849809,
      1.239674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.930311,
      NULL,
      1,
      0.709357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      32.682179,
      1.512017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      274.698746,
      0.429915,
      NULL,
      2.291815,
      NULL,
      NULL,
      NULL,
      0,
      1.233204,
      2.401200,
      0.490295,
      1.148622,
      NULL,
      0,
      0,
      0.713115,
      0.509653,
      0,
      1,
      2.383035,
      NULL,
      2.511089,
      NULL,
      0.971958,
      NULL,
      1,
      NULL,
      1.113184,
      NULL,
      3,
      NULL,
      87.879716,
      NULL,
      2,
      32,
      12.602401,
      NULL,
      1.907184,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.118867,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.078191,
      NULL,
      1.573723,
      NULL,
      0.702345,
      NULL,
      0.273219,
      NULL,
      1.884054,
      NULL,
      0.537916,
      1.526864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      0.296022,
      3.487406,
      0,
      1.796240,
      1,
      NULL,
      0,
      NULL,
      0.413500,
      0.291633,
      0,
      0.813079,
      NULL,
      1,
      1.168020,
      0.251731,
      0,
      0.070040,
      NULL,
      0,
      1.167488,
      0,
      0.402640,
      0,
      0.348996,
      0,
      NULL,
      0.935318,
      1,
      0,
      0.447313,
      1.204435,
      1,
      1.958483,
      0,
      0,
      1,
      0,
      0.217756,
      1,
      0.050091,
      2.539055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.775470,
      0,
      0,
      NULL,
      0,
      4,
      5,
      1,
      NULL,
      NULL,
      NULL,
      81.930350,
      NULL,
      NULL,
      NULL,
      '30043',
      '42110',
      '30301',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


