set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      2.163393,
      1,
      3,
      2,
      '0012',
      0,
      0,
      NULL,
      NULL,
      ' 6- 6-1992',
      46,
      NULL,
      5,
      2,
      0.668070,
      '11- 1-2003',
      22.570812,
      0.702097,
      235,
      61.315347,
      2,
      ' 7- 7-1982',
      NULL,
      ' 1-23-1977',
      0.396803,
      1,
      1,
      1.140932,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      7.035973,
      0.751800,
      10.152051,
      4,
      10.206358,
      3,
      2,
      NULL,
      0.170911,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.295051,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2.321862,
      2,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0.126662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.393131,
      0.095316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      3,
      4,
      2,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      4,
      NULL,
      5,
      3,
      0,
      2,
      NULL,
      0,
      1,
      2,
      5,
      3,
      NULL,
      ' 4- 7-1999',
      45,
      ' 8- 1-1979',
      17,
      1.359108,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.560116,
      1,
      NULL,
      0,
      1,
      1.925000,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.785694,
      2,
      0.402524,
      2.819700,
      7.534462,
      4,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.098139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.375695,
      0,
      20,
      2.881914,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.778467,
      2,
      1,
      3,
      0,
      NULL,
      0,
      2,
      1,
      0,
      0,
      3.024837,
      NULL,
      NULL,
      NULL,
      1.106705,
      0,
      4,
      0.323781,
      0.243525,
      0.629715,
      0,
      0.126868,
      0.288991,
      1.102867,
      1,
      0,
      1.476210,
      1,
      0.328378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      69,
      31,
      3,
      1.042213,
      0.005373,
      '14021',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1.878810,
      33.892238,
      NULL,
      35,
      2.899470,
      2,
      0.064717,
      2.231605,
      NULL,
      0,
      2.794121,
      NULL,
      0,
      NULL,
      NULL,
      0.117300,
      NULL,
      NULL,
      3,
      1.740585,
      0,
      0.166415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.172776,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.930777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.081926,
      NULL,
      NULL,
      6,
      5,
      NULL,
      1,
      0.141951,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.327998,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.708599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213026,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.258789,
      2,
      1.246633,
      1,
      NULL,
      NULL,
      5,
      1.781365,
      0,
      2.782556,
      NULL,
      0.331745,
      NULL,
      1,
      0,
      2.899127,
      7,
      0.468985,
      NULL,
      NULL,
      NULL,
      0.478713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.895262,
      3.152934,
      1,
      0,
      NULL,
      NULL,
      5,
      3.999317,
      0,
      1.472252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262871,
      NULL,
      NULL,
      1.491438,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.765464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.789884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      0.037838,
      1.115451,
      3,
      4,
      2,
      0,
      NULL,
      0.667069,
      1.986537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      1.743469,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.931611,
      NULL,
      NULL,
      0.274799,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.063281,
      NULL,
      NULL,
      0.853824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.871498,
      NULL,
      NULL,
      0.787120,
      NULL,
      NULL,
      0.906783,
      NULL,
      NULL,
      9.320181,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      2.378328,
      3.761015,
      NULL,
      NULL,
      2.857097,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.115828,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.131521,
      NULL,
      NULL,
      NULL,
      0.622513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889449,
      NULL,
      NULL,
      NULL,
      3,
      0.766293,
      NULL,
      NULL,
      0,
      1.936442,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.243722,
      1,
      NULL,
      NULL,
      2,
      0.659023,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7.403040,
      0.347144,
      NULL,
      NULL,
      0.908236,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      17.899514,
      5.249710,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      38,
      0,
      1.133015,
      NULL,
      0,
      0,
      NULL,
      1.703125,
      NULL,
      NULL,
      NULL,
      3.996278,
      0,
      0,
      1.843759,
      NULL,
      1.941392,
      1.392737,
      0,
      1,
      NULL,
      0.420087,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.076202,
      NULL,
      0.058089,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3.439375,
      2,
      2.452418,
      2,
      7,
      NULL,
      0,
      2.901311,
      1.967038,
      0,
      1.760314,
      0.803712,
      NULL,
      0.478344,
      1,
      0,
      2,
      0.849431,
      1.024888,
      NULL,
      1.805471,
      3,
      2,
      NULL,
      1,
      1,
      0.304849,
      0.131557,
      2,
      0,
      0.202578,
      NULL,
      0,
      0.316577,
      NULL,
      0,
      1.519246,
      0,
      0,
      1,
      0.573906,
      NULL,
      NULL,
      0.652040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967369,
      NULL,
      NULL,
      0,
      3.149076,
      0.730355,
      0.833934,
      NULL,
      3,
      1.824550,
      0.494485,
      0,
      2,
      1,
      0,
      0.576726,
      2.124981,
      1,
      0.496123,
      0.275991,
      1.025577,
      1.279179,
      1,
      NULL,
      1,
      0,
      0,
      18.112308,
      NULL,
      5.646406,
      NULL,
      0,
      0,
      0,
      0.480894,
      NULL,
      1,
      NULL,
      NULL,
      1.622819,
      NULL,
      NULL,
      100.661629,
      75,
      NULL,
      1.207961,
      4.853105,
      '44421',
      '22333',
      '',
      1,
      '',
      '',
      '',
      0.881805,
      '',
      '',
      NULL);
commit;
end;
/


