set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1440300',
      2.670638,
      1.413291,
      5,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 7-14-1998',
      10.056285,
      NULL,
      4,
      0.644183,
      0.868412,
      ' 7-13-1980',
      5.848421,
      NULL,
      248,
      119,
      0,
      ' 4-11-1980',
      ' 6-27-1987',
      ' 7-12-1982',
      3,
      2.214103,
      1.557445,
      1.685085,
      1.465141,
      0.554561,
      1,
      0,
      NULL,
      NULL,
      NULL,
      9.992182,
      NULL,
      21.637811,
      3.453697,
      5,
      2.830819,
      2,
      NULL,
      8.619238,
      0.449355,
      2,
      0,
      0,
      NULL,
      1.581274,
      0.555228,
      1,
      1.562001,
      0,
      0.977046,
      3,
      1,
      2,
      3.824795,
      5,
      0,
      1,
      1,
      0,
      1,
      3,
      0,
      0,
      1,
      0,
      NULL,
      6.526881,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.801053,
      NULL,
      NULL,
      1,
      1,
      0,
      1.094412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.463429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      4,
      5,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.566453,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5,
      0,
      0,
      NULL,
      5,
      1,
      5,
      2,
      NULL,
      NULL,
      2,
      7.635033,
      0,
      ' 5-12-2001',
      39,
      NULL,
      22.681431,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      1,
      NULL,
      0,
      0.607804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.729554,
      NULL,
      NULL,
      1,
      5,
      1.218448,
      1,
      3.579827,
      1,
      0.478788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.264493,
      1,
      3.987272,
      3,
      1.157904,
      5,
      3,
      1.277450,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.517665,
      NULL,
      NULL,
      0.828685,
      NULL,
      NULL,
      9,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      2,
      2,
      2,
      0,
      2,
      3,
      1,
      0,
      0,
      2.513411,
      1.241033,
      2.358130,
      0,
      1.924342,
      0,
      1.599487,
      1,
      0,
      NULL,
      1.258918,
      0.188812,
      NULL,
      0,
      1,
      1.677137,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      48,
      13,
      33,
      3,
      1.282420,
      3,
      '10123',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.760920,
      4.282860,
      NULL,
      27,
      3.079808,
      NULL,
      5.665571,
      2,
      0,
      2,
      3.979136,
      1,
      0.699373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.531793,
      1,
      NULL,
      NULL,
      1.958855,
      NULL,
      NULL,
      0,
      2,
      1.747208,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.107107,
      NULL,
      NULL,
      9.531726,
      7,
      NULL,
      1,
      3,
      0.985699,
      1,
      1.739239,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.749209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.465365,
      NULL,
      NULL,
      1.969053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107336,
      NULL,
      NULL,
      0.981607,
      1,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.245923,
      1,
      2.073182,
      3.009198,
      1,
      0.453197,
      3.703696,
      1,
      2.987539,
      4,
      1.268008,
      1.805089,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870843,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      1.680942,
      0,
      2,
      4.675451,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.066281,
      NULL,
      1.751064,
      3,
      NULL,
      2,
      4.107128,
      1,
      3,
      NULL,
      1.051167,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.708426,
      NULL,
      NULL,
      7.576662,
      0,
      0,
      5,
      3,
      3,
      3.082338,
      0,
      3,
      1.892016,
      2.494873,
      0.205082,
      NULL,
      0,
      0,
      NULL,
      2.773799,
      1,
      NULL,
      27.350989,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.761271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.895370,
      NULL,
      0.277120,
      1,
      NULL,
      2.707885,
      1.145672,
      NULL,
      2.953804,
      NULL,
      NULL,
      0,
      1.224735,
      NULL,
      3.937276,
      0.174273,
      NULL,
      2.801928,
      NULL,
      NULL,
      6.580275,
      2,
      NULL,
      3,
      0.484124,
      0.959971,
      NULL,
      0.538958,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      4.462418,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.682209,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.572921,
      1.725872,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.148317,
      NULL,
      NULL,
      1.498254,
      0.063723,
      NULL,
      NULL,
      3,
      0.831016,
      NULL,
      NULL,
      0.935552,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291266,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.221219,
      NULL,
      NULL,
      2.503882,
      0.201788,
      NULL,
      NULL,
      4.823949,
      0.854923,
      NULL,
      NULL,
      0.146680,
      NULL,
      NULL,
      NULL,
      2.205296,
      1.035820,
      1,
      0,
      NULL,
      NULL,
      1.364951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      8,
      NULL,
      NULL,
      NULL,
      0.157203,
      NULL,
      1.778327,
      NULL,
      0.758959,
      1.716938,
      1,
      1.388526,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      3.491802,
      NULL,
      0,
      1.681306,
      1.856757,
      0,
      1,
      0,
      1.968895,
      NULL,
      0.408959,
      NULL,
      0.065473,
      NULL,
      3.887002,
      NULL,
      2.804700,
      NULL,
      2.021366,
      NULL,
      84.892919,
      NULL,
      3.598849,
      23,
      0.177452,
      1.587899,
      0.279713,
      NULL,
      NULL,
      1.535785,
      NULL,
      1,
      NULL,
      0.162389,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.614856,
      NULL,
      1,
      NULL,
      0.717544,
      NULL,
      1.624321,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      2.598496,
      1,
      3,
      5,
      NULL,
      3.987146,
      0,
      1.545548,
      0.367394,
      NULL,
      1.561055,
      0,
      0.002689,
      0,
      0.910533,
      3.803368,
      0.349003,
      NULL,
      NULL,
      0.159706,
      0.914767,
      NULL,
      0.429258,
      NULL,
      0.454701,
      0.453699,
      NULL,
      1,
      2.614911,
      3,
      3.325915,
      0,
      NULL,
      NULL,
      0.447246,
      1,
      1.156427,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.965352,
      0.788416,
      0,
      0,
      2,
      5,
      6,
      0.404549,
      NULL,
      NULL,
      10,
      68.027635,
      1,
      1.805546,
      7.543963,
      NULL,
      '00400',
      '04231',
      1,
      '',
      '',
      '',
      0.947542,
      '',
      '',
      NULL);
commit;
end;
/


