set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5205713';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1012412',
      2,
      0,
      1,
      3,
      '4402',
      0.517091,
      1.398991,
      NULL,
      NULL,
      '11- 9-1984',
      68.278746,
      NULL,
      0,
      1,
      1,
      ' 6- 7-1982',
      2.141766,
      NULL,
      157.359150,
      119.799165,
      1,
      ' 6-29-1994',
      ' 3-27-1974',
      NULL,
      1.435551,
      0,
      NULL,
      3,
      NULL,
      1.054115,
      2,
      1.045827,
      NULL,
      344.579730,
      8,
      16,
      3.142331,
      21,
      0,
      0,
      NULL,
      4,
      0,
      3.330645,
      1.909236,
      1,
      0,
      1,
      1.307808,
      1,
      NULL,
      0,
      0.716927,
      NULL,
      108,
      7,
      3,
      1,
      2.761226,
      3,
      1,
      0,
      1,
      0,
      3,
      4,
      NULL,
      NULL,
      1,
      NULL,
      2,
      5,
      1,
      2,
      2,
      2,
      0.764914,
      NULL,
      NULL,
      0.639576,
      NULL,
      NULL,
      NULL,
      0,
      0.564908,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.740388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      1,
      NULL,
      1,
      4,
      3,
      0,
      1,
      0,
      0,
      1,
      5,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.803936,
      0,
      5,
      0,
      5,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      2,
      2,
      4,
      NULL,
      0,
      3,
      3,
      4,
      0,
      NULL,
      2,
      0,
      3,
      0,
      '11-21-1987',
      619,
      ' 6- 1-1988',
      1573,
      3.569082,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700510,
      1.973817,
      1.756302,
      1,
      1,
      0.088170,
      0,
      NULL,
      NULL,
      NULL,
      1.439633,
      0,
      0.831345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.914460,
      NULL,
      0.721670,
      NULL,
      1.548827,
      NULL,
      0.712184,
      1,
      9970,
      1,
      3,
      144.409180,
      1288.715213,
      537.839727,
      1,
      NULL,
      1.987613,
      3,
      NULL,
      1,
      2,
      3,
      2,
      3,
      NULL,
      3,
      3,
      2,
      2,
      1,
      1.667646,
      0.239104,
      0,
      2,
      1.529284,
      0.822363,
      0,
      1,
      0,
      NULL,
      0.713943,
      0.994270,
      1,
      NULL,
      3.451609,
      0.640745,
      7,
      7,
      2.715637,
      11,
      4.775375,
      3,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.869174,
      29,
      NULL,
      2.648018,
      NULL,
      46,
      NULL,
      3,
      NULL,
      1.115214,
      2,
      '41014',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      7.048550,
      '31323',
      '34002',
      '33401',
      3.769090,
      10,
      589.184146,
      26,
      NULL,
      21.061535,
      0,
      499.437256,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.683223,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2.077099,
      3,
      0.130045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      7,
      NULL,
      NULL,
      0.143894,
      NULL,
      NULL,
      NULL,
      0.651038,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889626,
      1.548999,
      1.127010,
      NULL,
      NULL,
      0.317208,
      NULL,
      NULL,
      NULL,
      1.019563,
      1.594431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.700795,
      NULL,
      0.151287,
      0,
      1.306274,
      1,
      2.583275,
      3,
      0.084827,
      1.553676,
      NULL,
      1,
      1.073156,
      NULL,
      NULL,
      1.633155,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.587964,
      0.526342,
      NULL,
      NULL,
      NULL,
      8,
      0.405900,
      2,
      0,
      3.642271,
      NULL,
      NULL,
      NULL,
      1.283829,
      4.705323,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.659259,
      2,
      4.574027,
      1.056622,
      1.796363,
      0.671333,
      2.583343,
      3.824977,
      NULL,
      2,
      3.875123,
      NULL,
      1.796672,
      NULL,
      1.726588,
      NULL,
      0,
      3,
      NULL,
      9,
      NULL,
      7,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.331525,
      NULL,
      1.266084,
      NULL,
      7,
      4.165391,
      2,
      NULL,
      5.663103,
      1.643263,
      3.551092,
      2,
      1,
      NULL,
      1.075376,
      1,
      0,
      1.896425,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161739,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1.648977,
      0,
      NULL,
      0,
      1.990851,
      1.909203,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.722196,
      NULL,
      NULL,
      NULL,
      1.707097,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299349,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.137522,
      197,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580542,
      NULL,
      NULL,
      NULL,
      72,
      26.818374,
      NULL,
      NULL,
      NULL,
      2,
      33,
      NULL,
      1.571147,
      NULL,
      NULL,
      454.574603,
      NULL,
      0.047732,
      NULL,
      0,
      1.079753,
      1,
      1.229913,
      0,
      NULL,
      0.339467,
      NULL,
      0.228680,
      0.975208,
      0,
      0,
      0.940789,
      1.548088,
      NULL,
      0.633137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      3.571462,
      3.932050,
      3,
      1,
      0,
      2,
      0.098846,
      0,
      1.905100,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536347,
      1,
      NULL,
      1.996506,
      1,
      NULL,
      1.676870,
      0.781310,
      NULL,
      0.413888,
      0,
      NULL,
      2.639671,
      0.750482,
      NULL,
      0,
      NULL,
      NULL,
      1.028360,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.876074,
      0,
      NULL,
      0.820109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675833,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5,
      6,
      3,
      1,
      3,
      46.418584,
      13.028722,
      0,
      1.334428,
      3,
      '10020',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5.145440,
      NULL,
      '00322',
      '42433');
commit;
end;
/


