set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0000333',
      3.355158,
      0.133951,
      NULL,
      3,
      '1311',
      1,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1.720525,
      5.106531,
      ' 0- 6-1989',
      45,
      1.056330,
      6.425385,
      120,
      1,
      '10-20-1988',
      ' 9-12-1991',
      '10-16-1989',
      0.497563,
      1.835921,
      2.820529,
      2,
      1,
      NULL,
      1,
      3.995787,
      NULL,
      NULL,
      NULL,
      8,
      1,
      29,
      4.876102,
      3,
      21,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      1.632471,
      1,
      1,
      0.883280,
      NULL,
      0,
      6.605673,
      1,
      2,
      1,
      3,
      0.655168,
      NULL,
      1,
      1,
      1,
      1,
      0,
      2,
      0,
      2,
      0,
      1,
      0,
      6,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.280230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      2,
      2,
      NULL,
      0,
      0,
      2,
      0,
      1,
      0,
      7.820689,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      4,
      4,
      0,
      2,
      5,
      NULL,
      4,
      NULL,
      4,
      3,
      5,
      2,
      5,
      5,
      0.270084,
      ' 6-16-1988',
      409.531579,
      NULL,
      NULL,
      1.448009,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0.969942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.120254,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.183509,
      0.690288,
      NULL,
      2,
      1,
      NULL,
      NULL,
      5,
      1.268972,
      3.932960,
      2.627777,
      3.062239,
      0.959951,
      NULL,
      NULL,
      0,
      1.961928,
      0.805499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.550049,
      2.242983,
      1.242810,
      0.144590,
      0,
      0,
      NULL,
      80,
      1.800877,
      0.129284,
      NULL,
      NULL,
      NULL,
      3,
      1.399250,
      2,
      1,
      3,
      1,
      1,
      1,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      6.618432,
      0.557618,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      67,
      42,
      25,
      4,
      NULL,
      NULL,
      NULL,
      '03433',
      '',
      0,
      '',
      NULL,
      '',
      0.810819,
      NULL,
      '',
      '',
      0.559995,
      22.345733,
      6,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.811261,
      1.071922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.671710,
      NULL,
      NULL,
      0.191778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.555161,
      NULL,
      NULL,
      2,
      1,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.402778,
      NULL,
      NULL,
      NULL,
      1,
      3.310446,
      0.339543,
      1.612264,
      NULL,
      NULL,
      1.159074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.975584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325812,
      NULL,
      NULL,
      2.084432,
      2.428569,
      0.284195,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      1.808831,
      1,
      NULL,
      NULL,
      1,
      4,
      0.990163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.734643,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.638535,
      1.363443,
      NULL,
      3,
      NULL,
      NULL,
      0.863553,
      NULL,
      NULL,
      0.610949,
      3,
      0.601755,
      1.550715,
      NULL,
      NULL,
      5.724502,
      0,
      3.319540,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.871609,
      2.082692,
      2.207344,
      0,
      3,
      0,
      6.143613,
      5.695403,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.475796,
      1,
      1.337633,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028312,
      NULL,
      NULL,
      1.484702,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.170709,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.208880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467948,
      NULL,
      NULL,
      1.606426,
      1,
      1.173187,
      0,
      1.412909,
      1.319942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547138,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840667,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.620893,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.235342,
      NULL,
      NULL,
      NULL,
      1,
      7.291841,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2.967015,
      3,
      NULL,
      3,
      5.704038,
      NULL,
      1.464383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.652963,
      NULL,
      NULL,
      0,
      NULL,
      0,
      20,
      NULL,
      1,
      1.344094,
      0,
      1.953994,
      0,
      1,
      1,
      0,
      1,
      1.166022,
      NULL,
      NULL,
      1,
      0.006636,
      0,
      0.599097,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.812913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396249,
      0.728732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.235844,
      NULL,
      1,
      NULL,
      1.930677,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.177316,
      NULL,
      0,
      NULL,
      1,
      1.829133,
      1.263611,
      NULL,
      1,
      NULL,
      1.349636,
      NULL,
      NULL,
      NULL,
      0.569875,
      NULL,
      1,
      NULL,
      0.694755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915223,
      3,
      NULL,
      1.221692,
      NULL,
      0.268916,
      NULL,
      NULL,
      NULL,
      1,
      1.053190,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      346.707605,
      NULL,
      1,
      NULL,
      1.518594,
      NULL,
      3.374587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319309,
      NULL,
      2.854537,
      2,
      2,
      3,
      5.009515,
      2.405940,
      6,
      0.929127,
      2,
      4.074725,
      2.255331,
      3.335363,
      1.095825,
      1.794924,
      1.887842,
      NULL,
      3.645716,
      3,
      NULL,
      0,
      2.923986,
      NULL,
      0,
      0,
      NULL,
      0.746454,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.995547,
      0.509653,
      NULL,
      1.195371,
      NULL,
      NULL,
      0,
      0.580987,
      NULL,
      1.014115,
      0.060486,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.329472,
      0.157739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996298,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      1,
      117.101995,
      119.315489,
      3,
      0,
      NULL,
      '42314',
      '03003',
      '',
      NULL,
      '12003',
      '',
      '',
      2.034529,
      NULL,
      '',
      '');
commit;
end;
/


