set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3413123',
      3,
      1.501603,
      NULL,
      NULL,
      '1234',
      1.648670,
      3.699775,
      NULL,
      40,
      ' 5- 1-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      1.392964,
      ' 5-17-1979',
      33,
      0,
      NULL,
      45,
      0,
      ' 2- 2-1986',
      '11-12-2001',
      ' 1- 2-1976',
      0.501563,
      NULL,
      3,
      1.888206,
      1.545996,
      1.951253,
      1,
      0.718113,
      NULL,
      NULL,
      NULL,
      4.389740,
      1.107296,
      19,
      9.658934,
      NULL,
      16,
      0,
      1,
      8.714397,
      NULL,
      NULL,
      NULL,
      0.126963,
      0.459294,
      0.405352,
      0,
      0.776704,
      0.205578,
      NULL,
      0.315951,
      5,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      2.511513,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.601105,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.304984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      2,
      2,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      2.409740,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1.902504,
      NULL,
      2,
      0,
      NULL,
      0,
      4,
      1,
      2,
      1,
      3,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      3,
      0,
      3,
      2,
      4,
      3,
      1,
      NULL,
      3,
      3,
      NULL,
      17.659028,
      NULL,
      7,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      0.043250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.235288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.056952,
      2.280694,
      3,
      NULL,
      NULL,
      4,
      1.151623,
      NULL,
      NULL,
      1,
      NULL,
      1.234793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657197,
      2.007516,
      1,
      1.720865,
      1,
      1,
      0,
      2.338203,
      16,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      3,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      2,
      2,
      0.099335,
      1.093651,
      3.238709,
      NULL,
      NULL,
      0.515207,
      3,
      1.012964,
      1.332748,
      0,
      1,
      0,
      1.703256,
      0,
      0,
      0,
      1,
      1.488280,
      NULL,
      2.903379,
      4.858073,
      4,
      8,
      11,
      6.401860,
      3,
      0.278026,
      NULL,
      0,
      NULL,
      1.333391,
      30,
      3,
      0,
      NULL,
      65,
      8,
      NULL,
      3,
      0,
      2.320161,
      '31341',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '33104',
      '',
      '',
      0,
      38,
      1,
      0,
      3.521113,
      30,
      NULL,
      5,
      NULL,
      3,
      3.461978,
      NULL,
      0.596893,
      NULL,
      NULL,
      1.125273,
      NULL,
      NULL,
      3,
      2.654336,
      0,
      1.934950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.691090,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      5.011898,
      2.272101,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.060882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.153643,
      NULL,
      NULL,
      1.241910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164523,
      NULL,
      NULL,
      NULL,
      NULL,
      3.111180,
      1,
      0.919980,
      1.525081,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972582,
      NULL,
      NULL,
      1.009940,
      NULL,
      NULL,
      1.720377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.150779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      3.681596,
      3.735326,
      0.354012,
      NULL,
      2.682242,
      3.855449,
      NULL,
      1,
      0,
      1.740746,
      NULL,
      NULL,
      NULL,
      0,
      2.919325,
      0.046681,
      NULL,
      0,
      4.929565,
      1.015143,
      2,
      2,
      10.759187,
      4,
      4,
      NULL,
      NULL,
      1.296864,
      3,
      3,
      0.471836,
      3.550362,
      3.860191,
      NULL,
      NULL,
      6,
      3.001638,
      NULL,
      3.076965,
      NULL,
      2,
      4,
      0,
      0,
      NULL,
      1.024156,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.814325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.184807,
      NULL,
      NULL,
      2.275646,
      NULL,
      NULL,
      1.924001,
      NULL,
      0,
      1.972420,
      1.942750,
      2.119713,
      2.499281,
      NULL,
      NULL,
      5.125810,
      NULL,
      NULL,
      NULL,
      NULL,
      142,
      NULL,
      NULL,
      3.142449,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.952786,
      NULL,
      NULL,
      1,
      0.248721,
      NULL,
      NULL,
      0.006861,
      0.865855,
      NULL,
      NULL,
      1.188082,
      0.212181,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.649732,
      NULL,
      NULL,
      NULL,
      1.413312,
      2,
      NULL,
      NULL,
      2.145840,
      NULL,
      NULL,
      NULL,
      1,
      0.511383,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.386936,
      3.420603,
      NULL,
      NULL,
      3.361612,
      NULL,
      NULL,
      NULL,
      NULL,
      4.203670,
      NULL,
      NULL,
      1.330373,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.754927,
      1,
      NULL,
      0.712468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683312,
      150.037423,
      1.190613,
      0.898692,
      NULL,
      1.342091,
      NULL,
      1,
      NULL,
      0.200625,
      0.850768,
      1,
      0,
      0,
      3.179822,
      1,
      1,
      NULL,
      1,
      1.167269,
      0.123228,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.209740,
      NULL,
      1.341729,
      NULL,
      1.050325,
      NULL,
      0,
      NULL,
      0.502448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070382,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009235,
      1.358624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411788,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797720,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.174351,
      NULL,
      3.682276,
      NULL,
      0,
      NULL,
      464.502919,
      NULL,
      2.560516,
      NULL,
      NULL,
      NULL,
      1,
      1.982351,
      2,
      0.219192,
      6.699724,
      2,
      2,
      0.377818,
      0.845941,
      NULL,
      4,
      NULL,
      7.594735,
      0.810033,
      4.269862,
      3,
      2,
      14,
      3,
      3,
      0.040578,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3.246658,
      0,
      3,
      NULL,
      1.371736,
      0,
      19.514096,
      2.059431,
      2,
      2.174875,
      0,
      0,
      0,
      3.630133,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.850633,
      3,
      0.561747,
      1.623050,
      1,
      0,
      2,
      3,
      NULL,
      1.916860,
      1.479227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.276212,
      NULL,
      0.266071,
      NULL,
      0.961784,
      NULL,
      NULL,
      NULL,
      2.390750,
      NULL,
      1.083967,
      NULL,
      1,
      NULL,
      1,
      NULL,
      18.443120,
      NULL,
      NULL,
      2,
      0.307990,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.912585,
      NULL,
      NULL,
      2.036977,
      0,
      NULL,
      3.059997,
      NULL,
      NULL,
      0.757257,
      0.019094,
      NULL,
      2.189027,
      1.386753,
      3,
      0,
      1,
      1.041329,
      NULL,
      12.129170,
      0,
      NULL,
      0.169494,
      1,
      NULL,
      0.502412,
      NULL,
      1,
      NULL,
      5,
      4,
      3.447478,
      NULL,
      0,
      48.785174,
      117.037555,
      5,
      1.660849,
      3.964010,
      '01403',
      '22111',
      '',
      3.879007,
      '30024',
      '',
      '',
      2.493839,
      NULL,
      NULL,
      '');
commit;
end;
/


