set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3202314',
      1,
      0,
      6,
      0,
      '0040',
      0,
      1.213418,
      2,
      NULL,
      ' 9-23-1982',
      33.176047,
      NULL,
      4,
      0.243403,
      3,
      ' 0-29-1988',
      40.291468,
      1.447448,
      NULL,
      88.952011,
      0,
      '11- 0-1981',
      ' 4-14-1984',
      ' 6- 4-1978',
      3,
      0.656169,
      3.092656,
      3.894272,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.131373,
      21,
      13.376692,
      NULL,
      22.361644,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.463726,
      NULL,
      1.523490,
      1.374178,
      0,
      2,
      NULL,
      0,
      1,
      1,
      1,
      4,
      NULL,
      0,
      3,
      3,
      2,
      4,
      0,
      2,
      NULL,
      NULL,
      1,
      5.877070,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.105872,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0.913938,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0.919348,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      4,
      0,
      0,
      4,
      5,
      4,
      4,
      5,
      7.047060,
      NULL,
      NULL,
      413.666923,
      NULL,
      26.810655,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      2,
      0,
      1,
      NULL,
      2.230549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      21.911497,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      0.441794,
      1,
      0,
      NULL,
      NULL,
      2.642044,
      0.920617,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.096590,
      NULL,
      NULL,
      1,
      1.049056,
      2,
      150,
      0,
      1.298723,
      NULL,
      NULL,
      NULL,
      3,
      0.589039,
      1,
      2,
      2,
      1,
      0,
      3,
      2,
      1,
      2,
      0,
      0,
      1,
      3.232880,
      2.557544,
      0,
      0.952918,
      0.767222,
      1,
      NULL,
      1,
      1.265593,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      6.840955,
      0,
      4,
      3,
      4.335562,
      NULL,
      7,
      0,
      0,
      1,
      31.469462,
      NULL,
      NULL,
      NULL,
      5,
      58,
      NULL,
      4,
      NULL,
      2,
      '10004',
      '',
      '',
      0.323796,
      '',
      NULL,
      '',
      2.145818,
      '31311',
      '',
      '',
      1,
      35.840406,
      184,
      27.352138,
      NULL,
      38.476641,
      3.324881,
      7.942030,
      3,
      1.123838,
      2.608197,
      2.952096,
      0,
      NULL,
      NULL,
      1.848174,
      NULL,
      NULL,
      1,
      2,
      0,
      0.181075,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.693277,
      NULL,
      NULL,
      1.003175,
      NULL,
      NULL,
      0.357495,
      NULL,
      NULL,
      0.929430,
      2.994841,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.225803,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      0.428587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675139,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860425,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      2,
      NULL,
      0.758903,
      NULL,
      NULL,
      6,
      1.950217,
      0,
      2,
      0,
      NULL,
      1.812181,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.485091,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.473289,
      NULL,
      NULL,
      1.246894,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297220,
      2,
      NULL,
      1,
      0.072805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954052,
      1.779982,
      0.142812,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.623592,
      NULL,
      NULL,
      3.570139,
      NULL,
      NULL,
      NULL,
      1,
      2,
      9.678846,
      NULL,
      4.481281,
      3,
      3.231868,
      5.494342,
      3.294284,
      4,
      1,
      0,
      0.515905,
      0,
      1.071413,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.706260,
      NULL,
      NULL,
      9.917995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294973,
      0.176236,
      NULL,
      2,
      NULL,
      NULL,
      2.206138,
      NULL,
      NULL,
      NULL,
      23,
      1721,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.531464,
      NULL,
      NULL,
      NULL,
      0.780564,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.700910,
      0.964308,
      NULL,
      NULL,
      0,
      0.642077,
      NULL,
      NULL,
      3.446952,
      0.287866,
      NULL,
      NULL,
      0,
      1.957272,
      NULL,
      NULL,
      0.797006,
      1.582765,
      NULL,
      NULL,
      1,
      2.577956,
      NULL,
      NULL,
      2.633081,
      1.095077,
      NULL,
      NULL,
      3,
      3.778917,
      NULL,
      NULL,
      1.071242,
      3.210663,
      NULL,
      NULL,
      2,
      2.053929,
      NULL,
      NULL,
      3.806414,
      NULL,
      NULL,
      NULL,
      3,
      8,
      NULL,
      NULL,
      0.314115,
      5.237953,
      7,
      5,
      0,
      5.449225,
      1.477875,
      0,
      0.270266,
      NULL,
      3,
      27,
      1.573588,
      0,
      NULL,
      NULL,
      0.869252,
      NULL,
      NULL,
      1.943497,
      NULL,
      NULL,
      0,
      NULL,
      0,
      234,
      0,
      0.833673,
      1,
      0.020672,
      0,
      NULL,
      2,
      1.938243,
      0.493464,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.300914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254660,
      NULL,
      NULL,
      NULL,
      1.205637,
      NULL,
      1.725505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.924721,
      1.940897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.092962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.126782,
      NULL,
      0.594602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987380,
      NULL,
      NULL,
      NULL,
      0.624613,
      NULL,
      1.733619,
      1,
      0.205227,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.208189,
      NULL,
      NULL,
      NULL,
      1.158447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790112,
      NULL,
      NULL,
      0,
      NULL,
      1.509623,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108552,
      3,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.361152,
      NULL,
      0,
      NULL,
      1.120026,
      1,
      3.093287,
      24.559134,
      34,
      NULL,
      3,
      2.450226,
      1.799144,
      1,
      1,
      0,
      1,
      2,
      0,
      0,
      1,
      12,
      1.664841,
      2.942575,
      1.269305,
      3,
      3,
      1,
      0,
      2.449149,
      NULL,
      1,
      1.518592,
      2,
      0.640858,
      1.491414,
      8,
      3,
      2,
      3,
      0.028588,
      0.664827,
      NULL,
      2.936307,
      NULL,
      0.561970,
      0,
      2,
      0,
      2,
      1.033564,
      0.999714,
      1,
      3,
      3.731635,
      1.390603,
      1.021830,
      0,
      0.418930,
      3,
      NULL,
      2.940774,
      1.116314,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.394581,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.618971,
      NULL,
      2.687742,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.024543,
      NULL,
      2,
      1,
      0.832854,
      0,
      3.385262,
      2.618647,
      2,
      0,
      NULL,
      NULL,
      1.438225,
      0.745266,
      3,
      0,
      2,
      NULL,
      NULL,
      0.363431,
      NULL,
      0,
      3.127807,
      0.019857,
      0,
      0.163598,
      2,
      2,
      0,
      13.098730,
      0,
      NULL,
      1,
      1,
      1.351643,
      NULL,
      1,
      0.682394,
      NULL,
      6,
      1,
      3,
      0,
      1.814991,
      0.512289,
      NULL,
      5,
      1.317429,
      1,
      '43033',
      '11400',
      NULL,
      NULL,
      '22002',
      '',
      '',
      3,
      '34000',
      NULL,
      '');
commit;
end;
/


