set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '2431242',
      0,
      0.461127,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      ' 4-26-1985',
      33.925207,
      NULL,
      1,
      1.017384,
      NULL,
      NULL,
      36,
      NULL,
      13.951754,
      99.871750,
      NULL,
      ' 9- 3-1986',
      NULL,
      ' 3- 8-1980',
      0.305961,
      0,
      2,
      1,
      0.660113,
      NULL,
      2,
      0.915349,
      0,
      NULL,
      NULL,
      4.587707,
      3.165827,
      NULL,
      6.936269,
      3,
      23,
      1,
      NULL,
      NULL,
      1.711102,
      1,
      3,
      1,
      NULL,
      0,
      0.839973,
      1.068344,
      0,
      1.140012,
      1.820905,
      1,
      NULL,
      1,
      3,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.216884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.563983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.437635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      0,
      1,
      NULL,
      3,
      0,
      0,
      0,
      0,
      3,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.947061,
      NULL,
      0,
      0,
      4,
      0,
      0,
      1,
      0,
      NULL,
      3,
      4,
      3,
      0,
      0,
      2,
      NULL,
      1,
      4,
      1,
      1,
      5,
      2,
      0,
      3,
      2,
      5.215992,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0.367416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.087141,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      3,
      2,
      0.505995,
      8.324127,
      NULL,
      0.181374,
      2.639634,
      0.696169,
      3.812693,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.192210,
      NULL,
      0,
      0,
      1.792923,
      NULL,
      1.681486,
      2,
      49,
      2,
      2.526209,
      70,
      34.327155,
      16.108963,
      3,
      NULL,
      0.104572,
      3,
      1,
      2,
      3,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0.606941,
      0.855953,
      1,
      1.849424,
      1,
      0.758819,
      1,
      1.517483,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.157661,
      1.433077,
      9,
      4.995698,
      5.411532,
      0.056771,
      1,
      5.126303,
      0,
      1,
      NULL,
      3,
      2.677711,
      0.239641,
      54,
      3,
      1.544326,
      NULL,
      59,
      23,
      88,
      4,
      1,
      3,
      '40233',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.357070,
      '',
      '',
      '',
      NULL,
      52.724282,
      528.751175,
      NULL,
      2,
      11,
      2.009346,
      4.800747,
      NULL,
      0.855496,
      3.837839,
      0,
      3.626827,
      0.528021,
      1.159234,
      NULL,
      1.691889,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.565771,
      NULL,
      NULL,
      0.393127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419481,
      0.230377,
      0.743060,
      1.587428,
      0.996701,
      NULL,
      NULL,
      1.318533,
      NULL,
      NULL,
      0.838719,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.036641,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.565528,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1.406957,
      0,
      NULL,
      NULL,
      2.194789,
      1,
      0,
      0,
      NULL,
      NULL,
      2.063579,
      1.499975,
      1.980900,
      5,
      0.223536,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.157633,
      NULL,
      NULL,
      0.299479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772841,
      NULL,
      NULL,
      1.935277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.788694,
      0,
      2.664218,
      0,
      0,
      5.765566,
      0,
      0,
      NULL,
      1,
      1.047217,
      NULL,
      NULL,
      NULL,
      0.003416,
      1,
      0.918670,
      0.797113,
      NULL,
      0,
      0,
      1,
      NULL,
      6.645945,
      NULL,
      1.780975,
      2,
      NULL,
      1,
      0.505241,
      1.427460,
      1,
      1,
      1.973011,
      0.116427,
      2.268817,
      0,
      0.198604,
      1.267718,
      1.135840,
      1,
      0.543442,
      NULL,
      NULL,
      2.437825,
      0,
      NULL,
      0.203917,
      1.230517,
      1.855670,
      0,
      NULL,
      0.091762,
      NULL,
      NULL,
      0.821392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.859529,
      NULL,
      NULL,
      0.630130,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676981,
      NULL,
      NULL,
      1.297738,
      2.731470,
      3.524129,
      NULL,
      NULL,
      0.986352,
      3.440908,
      NULL,
      2.534306,
      4,
      2.276737,
      NULL,
      5.750858,
      25,
      20,
      NULL,
      2.623666,
      1,
      NULL,
      NULL,
      3.192765,
      3,
      NULL,
      NULL,
      1.453419,
      NULL,
      0.146257,
      NULL,
      0.199580,
      0.204466,
      0.053938,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1.883138,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.289290,
      0,
      0,
      NULL,
      0.534744,
      NULL,
      1,
      NULL,
      1,
      0.682719,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.616511,
      0,
      NULL,
      2,
      NULL,
      1.919560,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.442679,
      NULL,
      0.663726,
      NULL,
      1.266192,
      0.859137,
      1.102231,
      NULL,
      0.723812,
      1,
      NULL,
      NULL,
      1.216451,
      2.455951,
      4,
      NULL,
      2.723798,
      1.061602,
      NULL,
      NULL,
      NULL,
      0,
      3.298844,
      NULL,
      1.034040,
      20,
      0.640721,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.739920,
      NULL,
      NULL,
      0.940807,
      NULL,
      0.514548,
      192.596985,
      0,
      NULL,
      1,
      0,
      0,
      0.827705,
      1,
      0.740995,
      0,
      0.165330,
      1.039380,
      1,
      NULL,
      1,
      0.762646,
      1.561561,
      1,
      0.963715,
      0.945495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      7.821802,
      2,
      2.289025,
      1.832455,
      2,
      11.291869,
      0.376003,
      2.924882,
      NULL,
      0.688258,
      0,
      0,
      1.957404,
      0.119478,
      0.140550,
      1,
      0.912634,
      3,
      1,
      1,
      0,
      1,
      2,
      0.553078,
      1.830785,
      0,
      0.333050,
      0,
      3,
      NULL,
      1,
      NULL,
      3,
      1.227994,
      3,
      3,
      NULL,
      2,
      3.408487,
      1.532667,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360599,
      2,
      1.814127,
      0.762986,
      NULL,
      0,
      2,
      0.319473,
      2.439645,
      1.102432,
      2.245657,
      0,
      2,
      2,
      0,
      1.893395,
      1,
      2,
      2.832206,
      1.158311,
      0,
      1.785635,
      NULL,
      1,
      0,
      NULL,
      0.296949,
      0,
      1,
      NULL,
      1,
      1.732574,
      NULL,
      0.997819,
      1,
      0.962140,
      4,
      2,
      5,
      3,
      1.607549,
      2.055345,
      12.208595,
      96.831026,
      3,
      1,
      3.870140,
      '43244',
      '24121',
      '',
      NULL,
      '',
      '',
      NULL,
      0.135491,
      '10123',
      NULL,
      NULL);
commit;
end;
/


