set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '3333424',
      1.688681,
      0,
      5,
      1,
      '4102',
      0.586405,
      0,
      NULL,
      NULL,
      ' 9-17-1993',
      NULL,
      NULL,
      NULL,
      0.574722,
      2,
      ' 1-24-1992',
      39,
      5.613939,
      118.481112,
      94,
      2,
      NULL,
      NULL,
      ' 8-23-2000',
      3,
      1,
      2,
      3.646019,
      NULL,
      1.064500,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      15,
      2,
      2,
      3.407629,
      1,
      0,
      1,
      1,
      0.179782,
      0,
      0.829304,
      NULL,
      NULL,
      5,
      0,
      1,
      5,
      2,
      3,
      4,
      0,
      1,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      2.703011,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.758291,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      0.349310,
      1,
      0.175353,
      NULL,
      0,
      0.190094,
      NULL,
      1.827583,
      1,
      0,
      3,
      1.166805,
      0,
      NULL,
      0.769820,
      2,
      2,
      0,
      0.928053,
      1,
      1,
      2.059802,
      1.481301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      0,
      NULL,
      0,
      2,
      0,
      1,
      5,
      1,
      2,
      NULL,
      NULL,
      5,
      3,
      3,
      3,
      1,
      1,
      0.667645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      4,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      1.623271,
      0,
      NULL,
      1,
      0.085624,
      NULL,
      0.214413,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.442707,
      NULL,
      0,
      0.763332,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745290,
      NULL,
      0,
      1,
      1,
      2,
      3,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      0.752421,
      NULL,
      NULL,
      0.312279,
      1.375897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.082205,
      1,
      1.791495,
      0,
      0,
      1,
      3,
      0,
      8.195178,
      6.380318,
      3,
      2,
      1.164737,
      NULL,
      NULL,
      0.484319,
      NULL,
      NULL,
      3,
      1.680844,
      61,
      2,
      0.312944,
      31,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '14134',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.177881,
      '',
      NULL,
      '',
      2,
      4,
      32.200483,
      12.427237,
      2.737769,
      30,
      7,
      1.569307,
      3,
      0.200869,
      3.371385,
      0,
      0.844187,
      NULL,
      NULL,
      1.204324,
      NULL,
      NULL,
      1.372133,
      NULL,
      NULL,
      1.413744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.242578,
      NULL,
      NULL,
      NULL,
      0.405535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.929746,
      NULL,
      NULL,
      0.436233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461344,
      0.337320,
      1,
      3,
      0.864471,
      1,
      0,
      NULL,
      NULL,
      3.090810,
      5,
      7.655706,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.763408,
      3,
      1.341225,
      NULL,
      NULL,
      1.322937,
      NULL,
      NULL,
      0.596791,
      2.217728,
      1.184562,
      0.681401,
      NULL,
      NULL,
      2,
      NULL,
      0.479536,
      3.217096,
      3.307334,
      3,
      1.460439,
      NULL,
      1.840614,
      0.097321,
      1.150568,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.927405,
      1.678549,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      2,
      1,
      0,
      3,
      NULL,
      7.481500,
      7.485284,
      0.742815,
      3,
      3.788967,
      1,
      0,
      3.140410,
      1.252535,
      1,
      NULL,
      NULL,
      2,
      1.146637,
      1,
      3,
      2,
      2,
      7,
      NULL,
      1,
      0.088233,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240755,
      NULL,
      NULL,
      1.052817,
      NULL,
      NULL,
      0.559562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.884277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.163404,
      NULL,
      1.217292,
      2,
      0.468736,
      0.550617,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.013219,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.337160,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.379117,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.226743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.240607,
      NULL,
      1,
      NULL,
      1.460162,
      NULL,
      0.130573,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      5,
      NULL,
      3.017329,
      1,
      0.662938,
      4,
      1,
      3,
      26,
      2.481419,
      NULL,
      0.294535,
      1.790301,
      0.826929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177478,
      34,
      9.261721,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      50,
      3.004537,
      NULL,
      1.731551,
      1,
      0,
      0.838309,
      0.357701,
      NULL,
      0.519916,
      1.985728,
      0.194979,
      NULL,
      3,
      NULL,
      1.500862,
      1,
      1.108252,
      2,
      NULL,
      0,
      0.345937,
      0,
      1.044218,
      0.508770,
      0,
      0.726237,
      NULL,
      0,
      1.395853,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.162071,
      1.616295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476102,
      0.531689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920918,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.969386,
      NULL,
      1.806331,
      0.968271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.438750,
      0,
      1.991654,
      0,
      NULL,
      1,
      1,
      2.445067,
      2,
      0,
      0.900816,
      0.057736,
      0,
      0,
      2.291102,
      0,
      NULL,
      1.426668,
      1,
      0.050713,
      1.784656,
      1,
      3.370231,
      0.184480,
      0.012285,
      0.652824,
      2,
      1,
      0,
      NULL,
      1,
      0.415853,
      2.216693,
      NULL,
      NULL,
      1.236115,
      0.720112,
      1.063137,
      0.092599,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.579787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920516,
      NULL,
      1,
      NULL,
      0.278407,
      1,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      19.933743,
      28.402619,
      0,
      NULL,
      NULL,
      '31323',
      NULL,
      '',
      1.429516,
      '',
      '',
      '',
      1.443942,
      '',
      '',
      '');
commit;
end;
/


