set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7526922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1982-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      2.964787,
      1.045838,
      2,
      3,
      '3423',
      0,
      0,
      NULL,
      NULL,
      '10- 7-1989',
      34.138121,
      NULL,
      5,
      NULL,
      2,
      ' 8-14-1991',
      39.982450,
      0,
      170,
      834.851452,
      2,
      ' 7- 5-2003',
      NULL,
      ' 2-27-2001',
      0.508154,
      1.135581,
      0.999941,
      1.205870,
      NULL,
      2,
      2,
      1,
      1.255329,
      25.164485,
      5,
      16,
      NULL,
      NULL,
      NULL,
      3,
      25,
      3,
      2,
      6,
      NULL,
      3,
      1,
      0,
      NULL,
      0.192944,
      0.672989,
      0.494817,
      0.781105,
      0,
      1,
      NULL,
      0,
      4,
      0.992341,
      4,
      0,
      1,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      6,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      2,
      5,
      0,
      1,
      3,
      2,
      1,
      0,
      0,
      5.182854,
      1,
      1,
      0,
      0,
      1.024182,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      3,
      5,
      0,
      1,
      0,
      1,
      0,
      4,
      0,
      3,
      0,
      NULL,
      0,
      1,
      2,
      3,
      0,
      2,
      NULL,
      NULL,
      1.812726,
      1,
      ' 6-23-1974',
      147.006234,
      ' 5- 8-1982',
      350.130825,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      1,
      1,
      0.656947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.801556,
      3,
      1.061752,
      7,
      1.296918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.771670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.391768,
      NULL,
      0.797353,
      1.258204,
      18.644339,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      2,
      0,
      1,
      2,
      1,
      1,
      2,
      2,
      1.154739,
      2.463975,
      2.976375,
      2.115152,
      0.244588,
      NULL,
      8.484026,
      0,
      0,
      0,
      0.042019,
      1.466999,
      1,
      1,
      1.061998,
      1,
      1.420633,
      NULL,
      0.962994,
      NULL,
      NULL,
      NULL,
      8.259772,
      7.702165,
      NULL,
      1.277980,
      NULL,
      4.332316,
      0.218722,
      0.755314,
      3,
      NULL,
      1,
      3.923353,
      NULL,
      60,
      17,
      NULL,
      0,
      NULL,
      NULL,
      '31203',
      '',
      '',
      1,
      '',
      '',
      '',
      0.292959,
      '',
      '',
      '',
      0,
      23,
      25.341849,
      25,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.793821,
      0.370989,
      NULL,
      NULL,
      3.531004,
      2.556045,
      0,
      1.355547,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.036769,
      0,
      17,
      3.255917,
      2,
      0,
      2.040193,
      NULL,
      4,
      0.405572,
      3,
      18,
      3.770256,
      2,
      3.693345,
      8.959884,
      0,
      6.862249,
      NULL,
      0.177472,
      NULL,
      NULL,
      NULL,
      1.752055,
      NULL,
      NULL,
      NULL,
      NULL,
      2.818801,
      14,
      NULL,
      NULL,
      NULL,
      0.202733,
      NULL,
      NULL,
      0.987818,
      NULL,
      1.668053,
      NULL,
      0,
      0.510503,
      1,
      1,
      0,
      1,
      1.285619,
      0.554755,
      NULL,
      1,
      0,
      1.156923,
      1,
      NULL,
      NULL,
      1.174514,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816571,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.788081,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.583408,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.783242,
      NULL,
      1.415518,
      3,
      NULL,
      4,
      3,
      6.072125,
      1,
      5,
      4.306280,
      0.371250,
      0.616888,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.144026,
      3,
      2,
      3.300294,
      0,
      0,
      NULL,
      2.041371,
      0,
      NULL,
      2.525418,
      3.310959,
      NULL,
      3,
      3.834558,
      NULL,
      2,
      8.931907,
      NULL,
      NULL,
      0.573406,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      1,
      NULL,
      0.083015,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.125390,
      NULL,
      NULL,
      0.673695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.675416,
      0,
      1,
      1,
      NULL,
      1.266544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.577653,
      NULL,
      NULL,
      NULL,
      0.085142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.030129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.462291,
      NULL,
      NULL,
      NULL,
      1.432085,
      2.979767,
      3,
      NULL,
      NULL,
      13,
      5.183278,
      1.519978,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      16543,
      1334,
      0.409832,
      1,
      0.596181,
      0.037241,
      1,
      1,
      1.349748,
      NULL,
      1,
      0,
      1,
      1,
      1.364191,
      1,
      1.667074,
      0.539396,
      1.746377,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.669288,
      NULL,
      0,
      NULL,
      1.584413,
      NULL,
      NULL,
      NULL,
      0.086913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.941214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.477054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832624,
      NULL,
      1.072972,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.783756,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.802637,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      10,
      2,
      5.045089,
      NULL,
      3,
      NULL,
      3,
      0.804834,
      NULL,
      0.956617,
      0,
      NULL,
      0.322468,
      0.167716,
      NULL,
      3.733523,
      1.700991,
      NULL,
      1.682128,
      NULL,
      NULL,
      0.608582,
      0.174705,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.026951,
      NULL,
      NULL,
      0.441573,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.128174,
      0,
      NULL,
      NULL,
      0.036898,
      3,
      NULL,
      NULL,
      1.518767,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      11,
      1.933104,
      NULL,
      NULL,
      0.958236,
      NULL,
      2.610828,
      NULL,
      2.823342,
      NULL,
      2.715917,
      NULL,
      1.688841,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.205731,
      NULL,
      1.096296,
      NULL,
      0,
      NULL,
      0.536553,
      NULL,
      2.786116,
      NULL,
      NULL,
      NULL,
      149.559035,
      0,
      NULL,
      1.327191,
      NULL,
      NULL,
      NULL,
      1.573169,
      NULL,
      3,
      3,
      NULL,
      0.248973,
      NULL,
      NULL,
      61,
      115,
      5,
      NULL,
      3.254409,
      '21431',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.939572,
      '',
      '',
      '');
commit;
end;
/


