set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7526922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1011244',
      0.251790,
      0.559773,
      1,
      NULL,
      NULL,
      2.548192,
      1.512239,
      NULL,
      NULL,
      ' 6-26-1994',
      NULL,
      NULL,
      NULL,
      1,
      0,
      '11-26-1991',
      11,
      3.878402,
      304,
      NULL,
      2,
      ' 5-16-2002',
      NULL,
      ' 4-12-1985',
      NULL,
      0,
      3,
      0,
      1,
      1.179426,
      1,
      NULL,
      0.030468,
      97,
      4,
      3,
      4.768790,
      18.527895,
      NULL,
      2,
      20.617329,
      1,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.744300,
      21.877691,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      4,
      0,
      1,
      1,
      1,
      4,
      3,
      0,
      2,
      1,
      3.836933,
      1,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      2,
      NULL,
      3,
      1,
      0,
      0,
      3,
      1,
      NULL,
      0,
      0,
      5,
      5,
      3,
      3,
      NULL,
      3,
      3,
      3,
      0,
      0,
      2.946831,
      NULL,
      ' 3-19-1995',
      589.046848,
      ' 1-26-1987',
      382,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.820988,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772184,
      0,
      2.773908,
      1,
      1.731837,
      3.599164,
      7,
      2,
      1.078317,
      NULL,
      1,
      2.031162,
      0,
      0,
      3,
      3,
      NULL,
      ' 9-18-1974',
      165.693360,
      ' 2- 7-1983',
      17,
      2.085382,
      NULL,
      1.351127,
      3.902878,
      0,
      1.209869,
      1.182295,
      1,
      NULL,
      1,
      2.742150,
      32,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.676407,
      2,
      1,
      NULL,
      0,
      0,
      0,
      2,
      2,
      2,
      1,
      0,
      3.562628,
      0,
      1,
      3.744719,
      1,
      0.220052,
      7.575305,
      1,
      1,
      1,
      0.072612,
      0,
      0.917189,
      0,
      1,
      NULL,
      0.262577,
      1,
      0.877680,
      NULL,
      4.715757,
      6,
      5,
      5,
      4.144796,
      0.360524,
      2.055294,
      NULL,
      1,
      2,
      0,
      5.115959,
      0,
      NULL,
      NULL,
      11,
      38,
      NULL,
      0,
      1,
      3.371261,
      '04304',
      '',
      '',
      0,
      '14420',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      25,
      135.624368,
      13.784227,
      3,
      32.155483,
      NULL,
      19,
      2,
      0.478541,
      3.838583,
      2.321245,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.364086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.960570,
      NULL,
      1,
      1,
      2,
      1.334599,
      1.065314,
      NULL,
      NULL,
      3,
      0,
      0,
      2.385520,
      0.791069,
      0,
      NULL,
      NULL,
      NULL,
      8,
      1.816856,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.383550,
      2.144764,
      2,
      0.729219,
      1,
      1.567806,
      NULL,
      NULL,
      0.283101,
      NULL,
      NULL,
      1,
      0.460841,
      1.774806,
      0,
      1,
      0.317682,
      1,
      1,
      0,
      NULL,
      NULL,
      0.524878,
      0,
      1.817423,
      1,
      0,
      1.985971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238852,
      NULL,
      NULL,
      1.850752,
      2,
      0.985995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.440335,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.095898,
      1,
      3.485811,
      0.779471,
      1.567004,
      1.014023,
      NULL,
      NULL,
      3.495107,
      2,
      2,
      1.642797,
      NULL,
      NULL,
      0.130564,
      NULL,
      NULL,
      1.693988,
      NULL,
      NULL,
      1.343107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.556316,
      1,
      NULL,
      NULL,
      1,
      1,
      5.253949,
      5.227011,
      4.630303,
      1,
      1,
      NULL,
      NULL,
      0,
      1.328171,
      0,
      1,
      NULL,
      2,
      0.774844,
      1,
      0.906504,
      1.196217,
      7.362723,
      4.100948,
      0,
      1.202873,
      NULL,
      NULL,
      2.531451,
      1.225099,
      1.256975,
      1,
      0.327780,
      1.380339,
      3,
      3.369765,
      NULL,
      3.254309,
      8,
      1,
      NULL,
      NULL,
      1.917149,
      2,
      0,
      0.729404,
      1,
      1.534007,
      0.603509,
      1.577904,
      1.396944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.197540,
      NULL,
      NULL,
      1.178074,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730380,
      NULL,
      NULL,
      1.217598,
      NULL,
      NULL,
      2.567370,
      3,
      3.935678,
      1.991313,
      NULL,
      3,
      1,
      2.322952,
      NULL,
      2,
      0,
      232.868959,
      NULL,
      NULL,
      NULL,
      2.393630,
      NULL,
      2.805759,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991196,
      NULL,
      0.758090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.382483,
      1.349502,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      2.278813,
      1.201025,
      NULL,
      1,
      0,
      0.611467,
      NULL,
      1,
      0,
      0.355549,
      NULL,
      NULL,
      0,
      0.600425,
      NULL,
      3,
      1.570165,
      NULL,
      NULL,
      3.656834,
      3.797152,
      2,
      NULL,
      NULL,
      1.145842,
      8,
      5,
      2.094286,
      21.993764,
      NULL,
      NULL,
      11.435167,
      0,
      0,
      NULL,
      NULL,
      0.924340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675592,
      2.165304,
      2.313912,
      1,
      NULL,
      0,
      17270,
      0,
      1,
      1,
      1.660635,
      1.679314,
      NULL,
      0.029730,
      0,
      NULL,
      0.269002,
      0,
      NULL,
      NULL,
      0.373292,
      1,
      0,
      NULL,
      NULL,
      1.767003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114789,
      1.733215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098087,
      0.160182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.261634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551008,
      1.875243,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.336127,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.076629,
      5.803075,
      NULL,
      4,
      1,
      NULL,
      0,
      0.519449,
      2,
      NULL,
      1,
      1.625032,
      1.595742,
      0,
      0,
      1.827893,
      0.621752,
      NULL,
      0,
      1.569494,
      1.179031,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3.229852,
      0,
      0.611631,
      0.399097,
      0.170824,
      NULL,
      1.474704,
      1.539631,
      0.080204,
      1.919909,
      2,
      3,
      0.590220,
      0,
      0.171880,
      1.731066,
      2.985142,
      1.681092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.574537,
      1.859389,
      1.669129,
      0,
      0,
      0,
      NULL,
      3.583082,
      3.330133,
      1,
      0.818625,
      1.169478,
      2,
      0,
      3.201036,
      NULL,
      NULL,
      NULL,
      0.005315,
      NULL,
      1,
      0.980520,
      1,
      1,
      0,
      NULL,
      4.975162,
      0,
      NULL,
      0,
      0,
      NULL,
      0.717762,
      NULL,
      0.235839,
      1,
      NULL,
      NULL,
      0.524821,
      NULL,
      1,
      64.341364,
      66,
      3,
      1.408777,
      1,
      '31332',
      '',
      '',
      0,
      '04311',
      '',
      '',
      1.997731,
      '',
      '',
      '');
commit;
end;
/


