set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0401234',
      2,
      0.877734,
      0,
      2,
      '4422',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      19.138535,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-2003',
      54,
      NULL,
      323,
      14,
      0,
      ' 0- 6-1980',
      ' 8- 0-1986',
      NULL,
      2.713874,
      1,
      2.859817,
      2.732253,
      NULL,
      1.315950,
      2,
      1,
      0,
      98,
      0,
      NULL,
      5,
      22,
      19,
      2,
      8.034646,
      3,
      3,
      2.817923,
      0.922842,
      NULL,
      NULL,
      1.438150,
      0,
      1.060978,
      NULL,
      1.875663,
      1.399282,
      NULL,
      105.724002,
      6,
      2,
      2,
      1,
      NULL,
      0,
      0,
      1,
      1,
      5,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      10,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      5,
      1,
      NULL,
      1.853379,
      NULL,
      3,
      NULL,
      3.364707,
      2.573535,
      0.106456,
      0,
      1,
      0.558205,
      0,
      NULL,
      0.506530,
      1,
      5,
      0,
      0,
      8,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      4.692396,
      1,
      0,
      0,
      1,
      2.785341,
      1,
      2.502907,
      NULL,
      3,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      3,
      3,
      0,
      0,
      2,
      2,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      ' 3-13-1982',
      NULL,
      ' 8-11-1995',
      836.011001,
      3.210218,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.566492,
      1,
      1.400146,
      1.222658,
      0,
      0,
      1.483723,
      1.473008,
      6.742130,
      0.674049,
      1.683108,
      1.767898,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.802433,
      1,
      0.593714,
      0.145667,
      1.796037,
      1,
      0.358616,
      0.226725,
      249.615110,
      3.026989,
      0.484819,
      NULL,
      144.539572,
      25,
      3,
      0.363215,
      0.376526,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      3.802421,
      NULL,
      NULL,
      1,
      0,
      0,
      1.691918,
      1.623185,
      1.332086,
      0.003194,
      0,
      1,
      0,
      NULL,
      0.294610,
      1,
      0,
      1,
      0.546849,
      NULL,
      NULL,
      3,
      5,
      2.545503,
      1,
      NULL,
      NULL,
      NULL,
      3.185806,
      3.581099,
      1.087736,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      5,
      0.363050,
      2.451283,
      '21141',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.778480,
      1.976773,
      77.908130,
      NULL,
      1.701966,
      NULL,
      NULL,
      NULL,
      NULL,
      3.627931,
      2,
      3,
      1,
      NULL,
      NULL,
      1.897759,
      NULL,
      NULL,
      1.872510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.699545,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.031296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      2,
      3,
      1,
      0.830587,
      NULL,
      NULL,
      NULL,
      0.895282,
      NULL,
      NULL,
      NULL,
      3.239935,
      2.394673,
      NULL,
      1,
      0.701821,
      0.189351,
      2,
      3,
      1,
      0.699598,
      0.948117,
      1,
      3,
      1,
      1.829586,
      1.432793,
      NULL,
      0.907842,
      2,
      1.596469,
      0,
      1,
      NULL,
      2,
      3,
      0,
      3.060320,
      2.373395,
      0.065107,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.573391,
      0,
      1.470810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864802,
      NULL,
      NULL,
      NULL,
      1.013843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.490376,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744836,
      2.479501,
      3,
      0.066783,
      NULL,
      0,
      NULL,
      NULL,
      4.528797,
      0,
      2,
      1.302039,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.158816,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.468840,
      NULL,
      NULL,
      3,
      2.358701,
      0.830907,
      1.124952,
      0.001360,
      1.622992,
      2,
      3,
      3.479963,
      7.212213,
      2,
      NULL,
      2.830144,
      1.694159,
      2,
      2,
      2,
      2,
      1,
      3.173530,
      0,
      0,
      1.362908,
      1.182125,
      0.455226,
      4,
      NULL,
      2.429018,
      0,
      2,
      0.573336,
      3,
      2.705712,
      3.259284,
      2.446682,
      3,
      1.087831,
      3.661756,
      0,
      1.744809,
      1,
      NULL,
      3,
      NULL,
      6,
      3.114257,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.349193,
      3.260542,
      NULL,
      NULL,
      0.220512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.251234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.212135,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      382.050762,
      NULL,
      NULL,
      NULL,
      2.413546,
      NULL,
      NULL,
      NULL,
      1.894831,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799108,
      NULL,
      NULL,
      NULL,
      0.572326,
      NULL,
      NULL,
      NULL,
      2.295464,
      NULL,
      NULL,
      NULL,
      2.830254,
      NULL,
      NULL,
      NULL,
      0.297586,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.835007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.586817,
      163,
      2,
      1.719501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.147825,
      NULL,
      NULL,
      1,
      NULL,
      1.485805,
      83.227033,
      14.084367,
      1,
      3,
      0.834735,
      NULL,
      1.729993,
      1.364378,
      0,
      1.195690,
      1,
      2,
      0.910678,
      1.875792,
      0,
      0.732216,
      1.559157,
      NULL,
      1.503507,
      3.614338,
      NULL,
      1.310634,
      NULL,
      0.712144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813825,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493894,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      21.631670,
      NULL,
      3.360398,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1.215996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.655044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125097,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.631029,
      NULL,
      NULL,
      NULL,
      0.391820,
      0.555243,
      NULL,
      32,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.018640,
      1,
      0,
      2.732335,
      NULL,
      1.052959,
      0.144569,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.367376,
      1.005401,
      NULL,
      0,
      1.801522,
      NULL,
      0,
      0.658687,
      NULL,
      0,
      NULL,
      NULL,
      1.708945,
      3,
      NULL,
      0.226548,
      NULL,
      NULL,
      0.373817,
      NULL,
      NULL,
      NULL,
      1.223098,
      NULL,
      1,
      1.216442,
      NULL,
      2,
      0.023096,
      0.319203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654508,
      NULL,
      0.038834,
      NULL,
      1,
      NULL,
      1,
      1,
      4,
      NULL,
      0.911047,
      1.158658,
      28,
      25.519333,
      4,
      NULL,
      2,
      '01233',
      '',
      '',
      1.428967,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


