set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '4441314',
      5.229325,
      NULL,
      2,
      2,
      '1133',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      155,
      NULL,
      2,
      1.296236,
      1,
      '10- 5-1985',
      13,
      3,
      210,
      26.953491,
      3,
      NULL,
      '11-22-1975',
      '10- 4-1981',
      3,
      1,
      NULL,
      3.771363,
      1,
      2,
      2,
      0,
      1.797558,
      3,
      6,
      NULL,
      NULL,
      13.524576,
      11.830338,
      0,
      NULL,
      5,
      2,
      9.611712,
      1.378169,
      1,
      1,
      1,
      1.607552,
      1.749864,
      1.868823,
      NULL,
      NULL,
      NULL,
      12,
      2,
      1,
      1,
      1.680597,
      NULL,
      1,
      1,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      8,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.483791,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0.180242,
      0.601638,
      2,
      2,
      NULL,
      3.015136,
      0,
      0,
      1,
      0.529542,
      3.570323,
      2,
      NULL,
      NULL,
      1,
      5.161016,
      NULL,
      2,
      0.233699,
      NULL,
      NULL,
      NULL,
      0.073938,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      2,
      0,
      0,
      2,
      4,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      5,
      4,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      5,
      5,
      2,
      NULL,
      5,
      NULL,
      ' 8- 9-1999',
      NULL,
      NULL,
      1346,
      0,
      0,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.166051,
      NULL,
      3,
      1,
      0.900883,
      0,
      1.849103,
      6.596053,
      0,
      0.705480,
      4.598573,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576603,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.022789,
      1,
      1,
      1,
      0.709131,
      0,
      3.022097,
      0.749540,
      1,
      0.914330,
      35,
      72,
      7.342950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      3,
      2,
      NULL,
      0.535669,
      1,
      2,
      1,
      0.091808,
      0,
      NULL,
      1.067768,
      1,
      1.100777,
      NULL,
      0,
      0,
      1.491158,
      1,
      1,
      1,
      1.625715,
      1.999017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      28,
      12.740695,
      0,
      2.973026,
      1.609380,
      '44213',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.081728,
      8.419235,
      5.688945,
      34.819404,
      3,
      40.899812,
      5.056923,
      NULL,
      0,
      2.340845,
      0,
      2,
      1.813704,
      NULL,
      NULL,
      1.190276,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.223120,
      NULL,
      NULL,
      1.540800,
      NULL,
      NULL,
      0.443983,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.765694,
      7.553643,
      1,
      1.864791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320055,
      3,
      NULL,
      0,
      2.980700,
      NULL,
      NULL,
      2,
      3,
      0.065552,
      1.296157,
      0,
      1.220084,
      0.268010,
      1.567441,
      2.588275,
      0,
      NULL,
      2.271141,
      1.076670,
      1.755474,
      1.416966,
      3.074674,
      NULL,
      2.819784,
      NULL,
      1.569253,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.035614,
      1.852670,
      3.746519,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363246,
      NULL,
      NULL,
      NULL,
      0.590171,
      NULL,
      NULL,
      1.518866,
      NULL,
      NULL,
      2,
      1.960539,
      3.776686,
      NULL,
      NULL,
      NULL,
      0,
      2.277258,
      2,
      NULL,
      NULL,
      0.075645,
      0.224751,
      NULL,
      NULL,
      1.575141,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.735935,
      NULL,
      1.351276,
      0.270980,
      NULL,
      1.197148,
      3,
      6,
      2.766999,
      1,
      1,
      2.127710,
      6,
      0,
      2,
      0.184063,
      NULL,
      NULL,
      NULL,
      2.793414,
      3,
      2.731344,
      0.511576,
      1,
      NULL,
      1,
      6,
      2,
      0,
      2.298430,
      0.194327,
      NULL,
      0.779946,
      0,
      3,
      1,
      1.800080,
      NULL,
      3.069232,
      3.712952,
      3,
      1.666169,
      1.689125,
      4.225505,
      2.651117,
      2,
      3,
      1,
      NULL,
      0.256319,
      0.388195,
      0,
      1.741769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.031580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.426179,
      NULL,
      NULL,
      1.656845,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      38.530625,
      NULL,
      NULL,
      NULL,
      0.669488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.934921,
      NULL,
      NULL,
      NULL,
      1.588965,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.532444,
      NULL,
      NULL,
      NULL,
      0.274536,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      135.936320,
      1,
      NULL,
      NULL,
      1.817331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474637,
      NULL,
      NULL,
      0,
      NULL,
      0.579033,
      NULL,
      67,
      1,
      0,
      0.216943,
      1,
      0.260244,
      NULL,
      0.407476,
      1.875017,
      1,
      2.150729,
      1.269151,
      0,
      1,
      NULL,
      1,
      0.712148,
      0.239482,
      NULL,
      NULL,
      1.714388,
      NULL,
      0.709744,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.331824,
      NULL,
      0.266322,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503684,
      NULL,
      1.676396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423077,
      0.900778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.740610,
      NULL,
      3.378204,
      NULL,
      3.295881,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.600317,
      NULL,
      0,
      NULL,
      0,
      0.599604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.034417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.650558,
      1.712824,
      18,
      57.695228,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.686860,
      1.470935,
      1.237373,
      0,
      NULL,
      1,
      1.219067,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.583013,
      NULL,
      0.049028,
      NULL,
      NULL,
      NULL,
      0.332847,
      NULL,
      0,
      NULL,
      NULL,
      1.599290,
      3.288047,
      NULL,
      1.450097,
      NULL,
      NULL,
      1.574500,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.043331,
      NULL,
      0.458560,
      1,
      NULL,
      NULL,
      1.784454,
      0.583802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963034,
      NULL,
      0.356118,
      NULL,
      0.433439,
      NULL,
      1,
      4,
      1,
      1,
      0.484214,
      0.766473,
      NULL,
      80,
      1,
      1,
      0,
      '31402',
      '',
      '',
      1,
      '',
      '',
      '',
      1.495617,
      '',
      '',
      '');
commit;
end;
/


