set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6110735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3212411',
      NULL,
      NULL,
      0,
      3,
      '4131',
      NULL,
      1.394290,
      NULL,
      NULL,
      ' 9-21-1990',
      7.374114,
      NULL,
      0,
      NULL,
      0,
      ' 2-17-1993',
      34,
      1,
      205.279499,
      94.884525,
      3,
      '11-25-1990',
      '11-26-1985',
      NULL,
      NULL,
      0,
      1.577738,
      1.408490,
      2,
      2.328332,
      2,
      0.192768,
      1,
      142,
      7,
      9,
      0,
      37,
      14.514013,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      0.931935,
      1.046321,
      NULL,
      1.756995,
      NULL,
      0.459077,
      0.683912,
      4.954873,
      8,
      NULL,
      7,
      3,
      5,
      2,
      1,
      NULL,
      1,
      1,
      3,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.494965,
      2,
      1.832048,
      1,
      NULL,
      0,
      2,
      1.119740,
      0,
      0,
      0.648515,
      1.086435,
      1.094184,
      0,
      0.272972,
      0,
      0.541622,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0.831893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      4,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.198806,
      0,
      1,
      1,
      0,
      0.506128,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      1,
      4,
      4,
      NULL,
      NULL,
      NULL,
      4,
      5,
      5,
      NULL,
      1,
      5,
      4,
      0,
      NULL,
      1,
      ' 2-16-1993',
      698,
      NULL,
      276,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680799,
      NULL,
      2.682865,
      2.672546,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      0.532688,
      NULL,
      0.337770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.378442,
      NULL,
      0.593580,
      1.422605,
      1.723393,
      0,
      NULL,
      3,
      5804.449715,
      1.337633,
      1,
      24,
      133,
      1120,
      2,
      1.940106,
      1.041748,
      NULL,
      2,
      2,
      0,
      NULL,
      3,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1.421945,
      0.173022,
      1,
      0.742582,
      1.804044,
      0.678008,
      10.957358,
      7.656241,
      2,
      10.023905,
      8.108485,
      3.796463,
      3,
      NULL,
      5.680745,
      2.322729,
      1,
      0.669348,
      8,
      3,
      1,
      NULL,
      NULL,
      36,
      47,
      4,
      NULL,
      2,
      '33014',
      NULL,
      '',
      0.770978,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      14,
      116.560929,
      12,
      1.532144,
      NULL,
      28,
      127,
      3,
      2,
      3,
      2,
      2.931096,
      NULL,
      1,
      NULL,
      2.705316,
      1,
      0.264924,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.853936,
      NULL,
      1.086354,
      1.462013,
      NULL,
      NULL,
      3.907014,
      1.680943,
      0.705182,
      1,
      NULL,
      NULL,
      0.839900,
      0,
      1.960094,
      0.883850,
      1.147660,
      1.306645,
      3,
      6.578136,
      0,
      1,
      0.047457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917249,
      NULL,
      3.594646,
      0,
      0,
      0.399247,
      1,
      NULL,
      2.567592,
      1,
      0,
      3.985166,
      3,
      0,
      1,
      2,
      2,
      NULL,
      0,
      0,
      3.145833,
      0.918423,
      1,
      0.399545,
      1.577469,
      NULL,
      NULL,
      0.876717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.256171,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.112673,
      1.729456,
      NULL,
      NULL,
      5,
      1.349729,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      0.345053,
      6,
      NULL,
      NULL,
      NULL,
      0.609048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992111,
      NULL,
      NULL,
      0.503132,
      NULL,
      NULL,
      0.237569,
      NULL,
      NULL,
      1.039071,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      3.149287,
      1,
      NULL,
      2.511402,
      4.670356,
      NULL,
      1,
      1,
      1,
      NULL,
      2.399841,
      1,
      3,
      2.962488,
      NULL,
      0,
      2,
      4.551024,
      4,
      5.093368,
      2.342081,
      2.224501,
      0.222802,
      NULL,
      0,
      2,
      0,
      0,
      0.819691,
      2.286826,
      1,
      0,
      7.909968,
      3,
      1.468447,
      9,
      0,
      3.780108,
      2.303952,
      0,
      1,
      0,
      0,
      1.202627,
      NULL,
      0.723432,
      3.776725,
      NULL,
      NULL,
      1.350677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.719019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.164179,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.188610,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.343956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774328,
      NULL,
      NULL,
      NULL,
      0.924673,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.968573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.624540,
      NULL,
      NULL,
      NULL,
      1,
      76,
      NULL,
      1,
      NULL,
      NULL,
      1.914811,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.896933,
      5284.217940,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.542867,
      2,
      1,
      3.951919,
      1.286374,
      0.207235,
      NULL,
      NULL,
      0,
      0.704077,
      1,
      0.645031,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.991657,
      NULL,
      1.627994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.274222,
      NULL,
      0.141719,
      NULL,
      NULL,
      NULL,
      1.463421,
      NULL,
      1.130098,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.220406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      39.280462,
      NULL,
      2.334787,
      NULL,
      0.619105,
      NULL,
      1.186112,
      NULL,
      0.198284,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.029027,
      NULL,
      3.723620,
      NULL,
      2.730950,
      NULL,
      74,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.310209,
      1.097118,
      0,
      18.433694,
      30,
      0,
      1,
      0.569403,
      NULL,
      NULL,
      0,
      3,
      2.139185,
      1,
      0.340097,
      NULL,
      2,
      13.682429,
      1,
      3.710420,
      1,
      1,
      1,
      NULL,
      1.807855,
      3.826845,
      NULL,
      NULL,
      2,
      NULL,
      0.091487,
      NULL,
      NULL,
      1,
      1.789806,
      NULL,
      0,
      1.626352,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.249929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.178677,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      2,
      2,
      3,
      0,
      0.773569,
      2.188358,
      56,
      51,
      NULL,
      0,
      NULL,
      NULL,
      '23144',
      '00440',
      NULL,
      NULL,
      '',
      '',
      0.798815,
      '',
      '',
      '');
commit;
end;
/


