set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9622970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1.995255,
      NULL,
      NULL,
      ' 9- 5-1994',
      NULL,
      NULL,
      4,
      2,
      3.457528,
      ' 1-24-1996',
      41,
      1,
      163,
      95,
      NULL,
      NULL,
      NULL,
      '11-28-2002',
      1,
      1,
      0.144576,
      0,
      1.351281,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      11.519864,
      23.683936,
      3,
      21,
      5,
      2,
      4.072262,
      1.110335,
      NULL,
      NULL,
      1.635554,
      1.374754,
      1.279274,
      1.383496,
      NULL,
      1.064457,
      1.943053,
      0.728611,
      1,
      4,
      2,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      4,
      0,
      0,
      1,
      NULL,
      1,
      4.055990,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.032082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      2,
      3,
      2,
      1,
      NULL,
      3,
      0,
      5,
      0,
      1,
      1.116218,
      0.520951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.923700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.653346,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      3.682321,
      1,
      1.753122,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211454,
      2,
      0.468630,
      1.154813,
      2,
      0,
      0,
      0,
      NULL,
      1,
      0.470582,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      2,
      2,
      0,
      0,
      0,
      0,
      2,
      0,
      1.130942,
      6.855494,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0.652705,
      1.018590,
      0.571465,
      0,
      0,
      1,
      3,
      1.687807,
      NULL,
      9.895766,
      9.024199,
      4.143461,
      5,
      3,
      7.243863,
      4,
      2,
      6.168836,
      0,
      0.647078,
      NULL,
      27.801624,
      3,
      1.105799,
      70,
      NULL,
      NULL,
      NULL,
      NULL,
      4.866597,
      NULL,
      '21313',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.485567,
      '',
      '',
      '',
      2.531946,
      33.508303,
      4.065426,
      58.731163,
      NULL,
      23.823118,
      3,
      0.833602,
      1,
      1,
      3,
      NULL,
      1.522681,
      NULL,
      NULL,
      3.649618,
      1,
      1.986208,
      1.538891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.850041,
      3,
      2.143521,
      1,
      NULL,
      NULL,
      1.113006,
      3,
      1,
      1.127790,
      NULL,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.915821,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.735650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.031432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309045,
      NULL,
      NULL,
      1.234532,
      2.178740,
      0.135069,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.198662,
      NULL,
      1.480204,
      NULL,
      0.614845,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.838016,
      0.619039,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.352450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.195616,
      3,
      0.965895,
      0,
      3.002037,
      2.169740,
      3.404026,
      1,
      5,
      5,
      7.568136,
      5.986138,
      0.449460,
      NULL,
      NULL,
      1.943040,
      NULL,
      NULL,
      3.009003,
      1.852791,
      NULL,
      3,
      2.976793,
      0.288730,
      3,
      6.105028,
      4.646056,
      NULL,
      0,
      NULL,
      2,
      2.517796,
      0,
      2,
      0.810029,
      NULL,
      3.721038,
      0,
      NULL,
      0,
      5,
      9,
      2.203170,
      5.842495,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      1.535678,
      1,
      3.678432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.684598,
      NULL,
      NULL,
      1.466600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.313935,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      4.377787,
      NULL,
      NULL,
      NULL,
      48.018558,
      NULL,
      NULL,
      2.551853,
      3,
      NULL,
      NULL,
      0.017626,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.563485,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.140883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784010,
      NULL,
      NULL,
      NULL,
      0,
      0.868170,
      NULL,
      NULL,
      NULL,
      0.717132,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965303,
      NULL,
      NULL,
      NULL,
      0.387031,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.380442,
      2.251810,
      NULL,
      NULL,
      1.010762,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2,
      2,
      0,
      0.797159,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.973466,
      4,
      0.301003,
      NULL,
      NULL,
      1.717449,
      NULL,
      1,
      501,
      NULL,
      1,
      0.391869,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1.319946,
      0.232004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.308162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.866060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.828311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.676136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.212821,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.863319,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.261837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081230,
      1,
      NULL,
      NULL,
      NULL,
      0.564475,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.780553,
      NULL,
      0,
      1.871458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      0.543497,
      NULL,
      2,
      3,
      5,
      1,
      3,
      0.709023,
      0.548869,
      0.205874,
      NULL,
      0.870495,
      3,
      3,
      0.215012,
      1,
      NULL,
      1,
      1.045481,
      1.826226,
      0.402842,
      1,
      3.304438,
      0.127094,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      1.808236,
      0,
      1.044882,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0.181811,
      1,
      0,
      1,
      1.071097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.187270,
      0.712159,
      2.063932,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.807335,
      NULL,
      1.718720,
      6,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      3,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4.393643,
      4,
      3.679838,
      0.681345,
      '03220',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


