set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9904910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.929806,
      0,
      NULL,
      0.552946,
      1,
      1,
      1,
      NULL,
      '23211424',
      25.952879,
      12.494653,
      '0322132',
      2.533547,
      1,
      0,
      1,
      '0324',
      6.102489,
      0.226189,
      NULL,
      NULL,
      ' 3- 4-1989',
      17.935091,
      46.954510,
      NULL,
      0,
      NULL,
      ' 8-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 6- 0-1984',
      1,
      0.864735,
      0.475424,
      NULL,
      0,
      1,
      3,
      1.174447,
      NULL,
      NULL,
      NULL,
      5,
      5.930698,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.249147,
      NULL,
      0,
      1,
      1,
      1.368815,
      0,
      0,
      NULL,
      1,
      1.410144,
      2,
      2,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      9,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129464,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.270371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      5,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.155950,
      2,
      0,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      4,
      3,
      4,
      5,
      0,
      0,
      0,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      4,
      6,
      1,
      NULL,
      145.511889,
      ' 7-27-1995',
      174.925406,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.903121,
      NULL,
      1,
      NULL,
      0,
      6.707523,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007846,
      2.451503,
      1.034022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0.962692,
      1.840023,
      0,
      NULL,
      NULL,
      0,
      1.112976,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.527709,
      3,
      1,
      1,
      2,
      0,
      2,
      1,
      0,
      2,
      1,
      2.052438,
      1,
      1.692528,
      1,
      3,
      0,
      NULL,
      0.859160,
      0,
      1.070832,
      1.171000,
      1.753298,
      0.318406,
      1.274633,
      NULL,
      0,
      1,
      3.849986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.659646,
      21,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      '33103',
      NULL,
      '',
      0.320396,
      '',
      '',
      '',
      0.016305,
      '',
      '',
      '',
      NULL,
      9,
      11,
      4,
      0,
      20.104578,
      NULL,
      9.088836,
      5,
      0.019623,
      NULL,
      3.024887,
      0.965283,
      NULL,
      NULL,
      0.631945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      3.226866,
      1,
      NULL,
      NULL,
      1,
      2.070633,
      1.684040,
      0,
      NULL,
      NULL,
      2,
      3.696072,
      2,
      1.458784,
      NULL,
      NULL,
      2.109610,
      3.274487,
      3.535093,
      1.201837,
      NULL,
      NULL,
      2.117308,
      8,
      9.760642,
      NULL,
      0.285739,
      NULL,
      NULL,
      NULL,
      1.780523,
      NULL,
      NULL,
      NULL,
      2.207397,
      3,
      NULL,
      1.697341,
      2.989903,
      1.730271,
      1,
      NULL,
      NULL,
      3.872004,
      3.304958,
      2,
      3.121309,
      3.950067,
      2,
      0,
      1,
      1.096065,
      1,
      NULL,
      0.547050,
      3,
      0.595180,
      0,
      1.900345,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.685901,
      2.857606,
      2,
      7,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.326121,
      2,
      2,
      2,
      2.819890,
      2,
      1.457950,
      3.287093,
      3,
      1.527257,
      0,
      7.121241,
      NULL,
      0,
      3.147820,
      3,
      0.609980,
      0,
      NULL,
      NULL,
      2,
      2,
      0.520335,
      0.646114,
      NULL,
      NULL,
      1.912548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.988160,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.904770,
      2,
      NULL,
      NULL,
      NULL,
      9.699374,
      5,
      1,
      4,
      NULL,
      1.304838,
      NULL,
      5,
      2.879807,
      3.231295,
      0.249671,
      1,
      1.511700,
      2,
      1.477574,
      2.195703,
      3,
      2,
      2.720177,
      0,
      5.056577,
      1,
      0.519972,
      1,
      0,
      NULL,
      NULL,
      2,
      2,
      0.800521,
      3,
      2.561176,
      2,
      8.453018,
      NULL,
      3.880508,
      NULL,
      NULL,
      6,
      2.304737,
      3,
      0,
      1,
      NULL,
      1.421602,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.552220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700890,
      NULL,
      NULL,
      1.149471,
      NULL,
      NULL,
      1.026604,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.975437,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.896853,
      NULL,
      NULL,
      0.716906,
      NULL,
      1,
      1.003412,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814758,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.499740,
      NULL,
      NULL,
      NULL,
      1.518793,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.182654,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.814800,
      NULL,
      NULL,
      NULL,
      1.000305,
      NULL,
      NULL,
      NULL,
      1.460614,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      19,
      9,
      NULL,
      7.139042,
      NULL,
      0,
      NULL,
      NULL,
      0.580761,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1.782188,
      0,
      0.753191,
      0,
      0.109896,
      0.479551,
      0,
      1.156539,
      0.414211,
      1,
      0.466154,
      0.975216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818801,
      1,
      NULL,
      0,
      0,
      NULL,
      0.999072,
      0,
      NULL,
      1,
      1.933917,
      NULL,
      1,
      1.357907,
      NULL,
      1,
      1,
      NULL,
      0.803857,
      1.960828,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.527086,
      NULL,
      1,
      1.545607,
      NULL,
      1,
      0.057007,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412805,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      81.556692,
      0,
      NULL,
      NULL,
      '21442',
      NULL,
      NULL,
      0.726502,
      '',
      NULL,
      '',
      0.486340,
      '',
      '',
      '');
commit;
end;
/


