set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4144101',
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      0.949379,
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      NULL,
      1.740024,
      1,
      NULL,
      73,
      3,
      242,
      91,
      3,
      NULL,
      NULL,
      ' 1- 7-1986',
      1,
      1.471669,
      2,
      1,
      1.994894,
      3.111802,
      4,
      1,
      2,
      NULL,
      0,
      17.597818,
      NULL,
      8.020131,
      15,
      NULL,
      9.948544,
      5,
      NULL,
      9.531177,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.193672,
      NULL,
      0.341744,
      NULL,
      0,
      0,
      3,
      3,
      3,
      3.867326,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.521339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0.138276,
      NULL,
      0.686600,
      0,
      0,
      1,
      NULL,
      1,
      1,
      3,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      3,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.295175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.029202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      12.840598,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.704190,
      NULL,
      NULL,
      4.656121,
      0,
      1,
      2,
      3,
      2.399845,
      2,
      2,
      1,
      1.945301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.368464,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.868811,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.719244,
      2,
      1,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      0.402532,
      1,
      NULL,
      5.731078,
      1,
      0.628199,
      NULL,
      NULL,
      1.455697,
      5,
      0,
      NULL,
      1.402049,
      NULL,
      0,
      1,
      1.660514,
      NULL,
      1.160757,
      5,
      3,
      6.189051,
      9,
      NULL,
      1.902210,
      3.839790,
      3.354346,
      2.879697,
      3.240810,
      NULL,
      2,
      39,
      1,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '24023',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.471557,
      '',
      '',
      '',
      0.434507,
      10,
      196.706891,
      1,
      NULL,
      19,
      2,
      101,
      NULL,
      0.418218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.303503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.403150,
      NULL,
      NULL,
      0.083462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904314,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.786865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.737572,
      NULL,
      NULL,
      0.068940,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061238,
      NULL,
      NULL,
      1.103826,
      NULL,
      NULL,
      0.437948,
      NULL,
      NULL,
      1.928835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      1.064297,
      0,
      0.803799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.293218,
      NULL,
      NULL,
      0.133917,
      3,
      0.852161,
      0.468321,
      1.196951,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147109,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.980537,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229003,
      2,
      3,
      0.231459,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.794545,
      NULL,
      NULL,
      NULL,
      0.534599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703657,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.146598,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.936899,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.911039,
      353.655544,
      116.913098,
      1,
      NULL,
      NULL,
      0.354380,
      NULL,
      NULL,
      0.869716,
      131,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      82.387900,
      2.529487,
      NULL,
      1470.313740,
      NULL,
      2.984373,
      1,
      NULL,
      0.396771,
      0.661109,
      NULL,
      1,
      NULL,
      0,
      1.983492,
      0.897286,
      0,
      3.258601,
      NULL,
      1.026886,
      1,
      NULL,
      NULL,
      1.772641,
      NULL,
      0.923742,
      NULL,
      3,
      NULL,
      1.592625,
      NULL,
      1.369039,
      NULL,
      64.780115,
      NULL,
      3,
      36.962724,
      8.175401,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299058,
      NULL,
      2.605468,
      NULL,
      NULL,
      NULL,
      0.286237,
      NULL,
      NULL,
      NULL,
      0.790246,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.210023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.532852,
      1,
      0.306663,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      1,
      0.135707,
      0.274273,
      0,
      1.943824,
      1.108423,
      1.713183,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1.673600,
      1.930889,
      1,
      1,
      1.766807,
      NULL,
      0,
      1.293690,
      0.821468,
      0,
      NULL,
      0.612860,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      2,
      1.838107,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.758492,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.790193,
      NULL,
      0.694016,
      NULL,
      1,
      16,
      1.218408,
      NULL,
      0,
      1.805937,
      1.968669,
      NULL,
      0,
      NULL,
      0.644023,
      NULL,
      0,
      NULL,
      1.891251,
      NULL,
      0,
      NULL,
      1.247605,
      NULL,
      1.096840,
      NULL,
      1.861634,
      NULL,
      1.358589,
      NULL,
      3,
      NULL,
      1.042585,
      NULL,
      3,
      0.740254,
      0,
      NULL,
      0.258160,
      1.509090,
      1.939722,
      1.593770,
      2,
      0.329898,
      0,
      2,
      NULL,
      0.815542,
      NULL,
      NULL,
      NULL,
      88,
      2,
      0.474399,
      NULL,
      '32303',
      '31400',
      '',
      1,
      '',
      '',
      '',
      3.504742,
      '2322',
      '',
      '');
commit;
end;
/


